/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.config;

import java.util.Map;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import org.primefaces.config.PrimeEnvironment;
import org.primefaces.config.WebXmlParser;

public class PrimeConfiguration {
    private final boolean validateEmptyFields;
    private final boolean partialSubmitEnabled;
    private final boolean resetValuesEnabled;
    private final boolean interpretEmptyStringAsNull;
    private final String theme;
    private final boolean fontAwesomeEnabled;
    private final boolean clientSideValidationEnabled;
    private final String uploader;
    private final boolean transformMetadataEnabled;
    private final boolean legacyWidgetNamespace;
    private final boolean interpolateClientSideValidationMessages;
    private final boolean earlyPostParamEvaluation;
    private final boolean moveScriptsToBottom;
    private final boolean stringConverterAvailable;
    private final boolean beanValidationEnabled;
    private final Map<String, String> errorPages;

    public PrimeConfiguration(FacesContext context, PrimeEnvironment environment) {
        ExternalContext externalContext = context.getExternalContext();
        this.stringConverterAvailable = null != context.getApplication().createConverter(String.class);
        this.errorPages = WebXmlParser.getErrorPages(context);
        this.validateEmptyFields = this.resolveValidateEmptyFields(context, environment);
        String value = externalContext.getInitParameter("javax.faces.INTERPRET_EMPTY_STRING_SUBMITTED_VALUES_AS_NULL");
        this.interpretEmptyStringAsNull = value == null ? false : Boolean.valueOf(value);
        value = externalContext.getInitParameter("primefaces.SUBMIT");
        this.partialSubmitEnabled = value == null ? false : value.equalsIgnoreCase("partial");
        value = externalContext.getInitParameter("primefaces.RESET_VALUES");
        this.resetValuesEnabled = value == null ? false : Boolean.valueOf(value);
        value = externalContext.getInitParameter("primefaces.CLIENT_SIDE_VALIDATION");
        this.clientSideValidationEnabled = value == null ? false : Boolean.valueOf(value);
        value = externalContext.getInitParameter("primefaces.UPLOADER");
        this.uploader = value == null ? "auto" : value;
        this.theme = externalContext.getInitParameter("primefaces.THEME");
        value = externalContext.getInitParameter("primefaces.FONT_AWESOME");
        this.fontAwesomeEnabled = value == null ? false : Boolean.valueOf(value);
        value = externalContext.getInitParameter("primefaces.TRANSFORM_METADATA");
        this.transformMetadataEnabled = value == null ? false : Boolean.valueOf(value);
        value = externalContext.getInitParameter("primefaces.LEGACY_WIDGET_NAMESPACE");
        boolean bl = this.legacyWidgetNamespace = value == null ? false : Boolean.valueOf(value);
        this.beanValidationEnabled = environment.isBeanValidationAvailable() ? ((value = externalContext.getInitParameter("javax.faces.validator.DISABLE_DEFAULT_BEAN_VALIDATOR")) == null ? true : Boolean.valueOf(value) == false) : false;
        value = externalContext.getInitParameter("primefaces.INTERPOLATE_CLIENT_SIDE_VALIDATION_MESSAGES");
        this.interpolateClientSideValidationMessages = value == null ? false : Boolean.valueOf(value);
        value = externalContext.getInitParameter("primefaces.EARLY_POST_PARAM_EVALUATION");
        this.earlyPostParamEvaluation = value == null ? false : Boolean.valueOf(value);
        value = externalContext.getInitParameter("primefaces.MOVE_SCRIPTS_TO_BOTTOM");
        this.moveScriptsToBottom = value == null ? false : Boolean.valueOf(value);
    }

    protected boolean resolveValidateEmptyFields(FacesContext context, PrimeEnvironment environment) {
        ExternalContext externalContext = context.getExternalContext();
        String param = externalContext.getInitParameter("javax.faces.VALIDATE_EMPTY_FIELDS");
        if (param == null && externalContext.getApplicationMap().containsKey("javax.faces.VALIDATE_EMPTY_FIELDS")) {
            Object applicationMapValue = externalContext.getApplicationMap().get("javax.faces.VALIDATE_EMPTY_FIELDS");
            if (applicationMapValue instanceof String) {
                param = (String)applicationMapValue;
            } else if (applicationMapValue instanceof Boolean) {
                return (Boolean)applicationMapValue;
            }
        }
        param = param == null ? "auto" : param.toLowerCase();
        return param.equals("auto") && environment.isBeanValidationAvailable() || param.equals("true");
    }

    public boolean isValidateEmptyFields() {
        return this.validateEmptyFields;
    }

    public boolean isPartialSubmitEnabled() {
        return this.partialSubmitEnabled;
    }

    public boolean isResetValuesEnabled() {
        return this.resetValuesEnabled;
    }

    public boolean isInterpretEmptyStringAsNull() {
        return this.interpretEmptyStringAsNull;
    }

    public String getTheme() {
        return this.theme;
    }

    public boolean isFontAwesomeEnabled() {
        return this.fontAwesomeEnabled;
    }

    public boolean isClientSideValidationEnabled() {
        return this.clientSideValidationEnabled;
    }

    public String getUploader() {
        return this.uploader;
    }

    public boolean isTransformMetadataEnabled() {
        return this.transformMetadataEnabled;
    }

    public boolean isLegacyWidgetNamespace() {
        return this.legacyWidgetNamespace;
    }

    public boolean isInterpolateClientSideValidationMessages() {
        return this.interpolateClientSideValidationMessages;
    }

    public boolean isEarlyPostParamEvaluation() {
        return this.earlyPostParamEvaluation;
    }

    public boolean isMoveScriptsToBottom() {
        return this.moveScriptsToBottom;
    }

    public boolean isStringConverterAvailable() {
        return this.stringConverterAvailable;
    }

    public boolean isBeanValidationEnabled() {
        return this.beanValidationEnabled;
    }

    public Map<String, String> getErrorPages() {
        return this.errorPages;
    }
}

