/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.config;

import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.context.FacesContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.primefaces.util.LangUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class WebXmlParser {
    private static final Logger LOGGER = Logger.getLogger(WebXmlParser.class.getName());

    private WebXmlParser() {
    }

    public static Map<String, String> getErrorPages(FacesContext context) {
        Map<String, String> webXmlErrorPages = WebXmlParser.getWebXmlErrorPages(context);
        Map<String, String> webFragmentXmlsErrorPages = WebXmlParser.getWebFragmentXmlsErrorPages(context);
        Map<String, String> errorPages = webXmlErrorPages;
        if (errorPages == null) {
            errorPages = webFragmentXmlsErrorPages;
        } else if (webFragmentXmlsErrorPages != null) {
            for (Map.Entry<String, String> entry : webFragmentXmlsErrorPages.entrySet()) {
                if (errorPages.containsKey(entry.getKey())) continue;
                errorPages.put(entry.getKey(), entry.getValue());
            }
        }
        if (errorPages == null) {
            errorPages = new HashMap<String, String>();
        }
        return errorPages;
    }

    private static Map<String, String> getWebXmlErrorPages(FacesContext context) {
        try {
            Document webXml = WebXmlParser.toDocument(context.getExternalContext().getResource("/WEB-INF/web.xml"));
            if (webXml != null) {
                return WebXmlParser.parseErrorPages(webXml.getDocumentElement());
            }
        }
        catch (Throwable e) {
            LOGGER.log(Level.SEVERE, "Could not load or parse web.xml", e);
        }
        return null;
    }

    private static Map<String, String> getWebFragmentXmlsErrorPages(FacesContext context) {
        Map<String, String> webFragmentXmlsErrorPages = null;
        try {
            Enumeration<URL> webFragments = LangUtils.getContextClassLoader().getResources("META-INF/web-fragment.xml");
            while (webFragments.hasMoreElements()) {
                try {
                    URL url = webFragments.nextElement();
                    Document webFragmentXml = WebXmlParser.toDocument(url);
                    if (webFragmentXml == null) continue;
                    if (webFragmentXmlsErrorPages == null) {
                        webFragmentXmlsErrorPages = WebXmlParser.parseErrorPages(webFragmentXml.getDocumentElement());
                        continue;
                    }
                    Map<String, String> temp = WebXmlParser.parseErrorPages(webFragmentXml.getDocumentElement());
                    for (Map.Entry<String, String> entry : temp.entrySet()) {
                        if (webFragmentXmlsErrorPages.containsKey(entry.getKey())) continue;
                        webFragmentXmlsErrorPages.put(entry.getKey(), entry.getValue());
                    }
                }
                catch (Throwable e) {
                    LOGGER.log(Level.SEVERE, "Could not load or parse web-fragment.xml", e);
                }
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Could not get web-fragment.xml's from ClassLoader", e);
        }
        return webFragmentXmlsErrorPages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Document toDocument(URL url) throws Exception {
        Document document;
        InputStream is = null;
        if (url == null) {
            Document document2 = null;
            return document2;
        }
        is = url.openStream();
        if (is == null) {
            Document document3 = null;
            return document3;
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        factory.setNamespaceAware(false);
        factory.setExpandEntityReferences(false);
        try {
            factory.setFeature("http://xml.org/sax/features/namespaces", false);
            factory.setFeature("http://xml.org/sax/features/validation", false);
            factory.setFeature("http://apache.org/xml/features/nonvalidating/load-dtd-grammar", false);
            factory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        }
        catch (Throwable e) {
            LOGGER.warning("DocumentBuilderFactory#setFeature not implemented. Skipping...");
        }
        boolean absolute = false;
        try {
            absolute = url.toURI().isAbsolute();
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        DocumentBuilder builder = factory.newDocumentBuilder();
        if (absolute) {
            InputSource source = new InputSource(url.toExternalForm());
            source.setByteStream(is);
            document = builder.parse(source);
        } else {
            document = builder.parse(is);
        }
        Document document4 = document;
        return document4;
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static Map<String, String> parseErrorPages(Element webXml) throws Exception {
        HashMap<String, String> errorPages = new HashMap<String, String>();
        XPath xpath = XPathFactory.newInstance().newXPath();
        NodeList exceptionTypes = (NodeList)xpath.compile("error-page/exception-type").evaluate(webXml, XPathConstants.NODESET);
        for (int i = 0; i < exceptionTypes.getLength(); ++i) {
            Node node = exceptionTypes.item(i);
            String exceptionType = node.getTextContent().trim();
            String key = Throwable.class.getName().equals(exceptionType) ? null : exceptionType;
            String location = xpath.compile("location").evaluate(node.getParentNode()).trim();
            if (errorPages.containsKey(key)) continue;
            errorPages.put(key, location);
        }
        if (!errorPages.containsKey(null)) {
            String defaultLocation = xpath.compile("error-page[error-code=500]/location").evaluate(webXml).trim();
            if (LangUtils.isValueBlank(defaultLocation)) {
                defaultLocation = xpath.compile("error-page[not(error-code) and not(exception-type)]/location").evaluate(webXml).trim();
            }
            if (!LangUtils.isValueBlank(defaultLocation)) {
                errorPages.put(null, defaultLocation);
            }
        }
        return errorPages;
    }
}

