/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.expression.impl;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.component.visit.VisitCallback;
import javax.faces.context.FacesContext;
import org.primefaces.expression.ClientIdSearchExpressionResolver;
import org.primefaces.expression.SearchExpressionResolver;
import org.primefaces.expression.SearchExpressionUtils;
import org.primefaces.expression.impl.WidgetVarVisitCallback;

public class WidgetVarExpressionResolver
implements SearchExpressionResolver,
ClientIdSearchExpressionResolver {
    private static final Pattern PATTERN = Pattern.compile("@widgetVar\\((\\w+)\\)");

    @Override
    public UIComponent resolveComponent(FacesContext context, UIComponent source, UIComponent last, String expression, int options) {
        try {
            Matcher matcher = PATTERN.matcher(expression);
            if (matcher.matches()) {
                WidgetVarVisitCallback visitCallback = new WidgetVarVisitCallback(matcher.group(1));
                context.getViewRoot().visitTree(SearchExpressionUtils.createVisitContext(context, options), (VisitCallback)visitCallback);
                return visitCallback.getComponent();
            }
            throw new FacesException("Expression does not match following pattern @widgetVar(var). Expression: \"" + expression + "\"");
        }
        catch (Exception e) {
            throw new FacesException("Expression does not match following pattern @widgetVar(var). Expression: \"" + expression + "\"", (Throwable)e);
        }
    }

    @Override
    public String resolveClientIds(FacesContext context, UIComponent source, UIComponent last, String expression, int options) {
        return expression;
    }
}

