/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.metadata.transformer.impl;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.Date;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.PropertyNotFoundException;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.validation.constraints.Future;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.Past;
import javax.validation.constraints.Size;
import javax.validation.metadata.ConstraintDescriptor;
import org.primefaces.component.api.UICalendar;
import org.primefaces.component.spinner.Spinner;
import org.primefaces.context.PrimeApplicationContext;
import org.primefaces.metadata.BeanValidationMetadataExtractor;
import org.primefaces.metadata.transformer.AbstractInputMetadataTransformer;

public class BeanValidationInputMetadataTransformer
extends AbstractInputMetadataTransformer {
    private static final Logger LOGGER = Logger.getLogger(BeanValidationInputMetadataTransformer.class.getName());

    @Override
    public void transformInput(FacesContext context, PrimeApplicationContext applicationContext, UIInput input) throws IOException {
        UIInput editableValueHolder = input;
        if (editableValueHolder.isRequired() && this.isMaxlenghtSet(input)) {
            return;
        }
        try {
            Set<ConstraintDescriptor<?>> constraints = BeanValidationMetadataExtractor.extractDefaultConstraintDescriptors(context, applicationContext, input.getValueExpression("value"));
            if (constraints != null && !constraints.isEmpty()) {
                for (ConstraintDescriptor<?> constraintDescriptor : constraints) {
                    this.applyConstraint(constraintDescriptor, input, (EditableValueHolder)editableValueHolder);
                }
            }
        }
        catch (PropertyNotFoundException e) {
            String message = "Skip transform metadata for component \"" + input.getClientId(context) + "\" because the ValueExpression of the \"value\" attribute isn't resolvable completely (e.g. a sub-expression returns null)";
            LOGGER.log(Level.FINE, message);
        }
    }

    protected void applyConstraint(ConstraintDescriptor constraintDescriptor, UIInput input, EditableValueHolder editableValueHolder) {
        Size size;
        Annotation constraint = constraintDescriptor.getAnnotation();
        if (!this.isMaxlenghtSet(input) && constraint.annotationType().equals(Size.class) && (size = (Size)constraint).max() > 0) {
            this.setMaxlength(input, size.max());
        }
        if (input instanceof Spinner) {
            Spinner spinner = (Spinner)input;
            if (constraint.annotationType().equals(Max.class) && spinner.getMax() == Double.MAX_VALUE) {
                Max max = (Max)constraint;
                spinner.setMax(max.value());
            }
            if (constraint.annotationType().equals(Min.class) && spinner.getMin() == Double.MIN_VALUE) {
                Min min = (Min)constraint;
                spinner.setMin(min.value());
            }
        }
        if (input instanceof UICalendar) {
            UICalendar uicalendar = (UICalendar)input;
            if (constraint.annotationType().equals(Past.class) && uicalendar.getMaxdate() == null) {
                uicalendar.setMaxdate(new Date());
            }
            if (constraint.annotationType().equals(Future.class) && uicalendar.getMindate() == null) {
                uicalendar.setMindate(new Date());
            }
        }
    }
}

