/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.renderkit;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import org.primefaces.component.api.InputHolder;
import org.primefaces.component.api.RTLAware;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.LangUtils;

public abstract class InputRenderer
extends CoreRenderer {
    public Object getConvertedValue(FacesContext context, UIComponent component, Object submittedValue) throws ConverterException {
        Converter converter = ComponentUtils.getConverter(context, component);
        if (converter != null) {
            String convertableValue = submittedValue == null ? null : submittedValue.toString();
            return converter.getAsObject(context, component, convertableValue);
        }
        return submittedValue;
    }

    protected boolean isDisabled(UIInput component) {
        return Boolean.parseBoolean(String.valueOf(component.getAttributes().get("disabled")));
    }

    protected boolean isReadOnly(UIInput component) {
        return Boolean.parseBoolean(String.valueOf(component.getAttributes().get("readonly")));
    }

    protected boolean shouldDecode(UIInput component) {
        return !this.isDisabled(component) && !this.isReadOnly(component);
    }

    public <T extends UIComponent> void renderRTLDirection(FacesContext context, T component) throws IOException {
        if (ComponentUtils.isRTL(context, (RTLAware)component)) {
            context.getResponseWriter().writeAttribute("dir", (Object)"rtl", null);
        }
    }

    protected void renderARIARequired(FacesContext context, UIInput component) throws IOException {
        if (component.isRequired()) {
            ResponseWriter writer = context.getResponseWriter();
            writer.writeAttribute("aria-required", (Object)"true", null);
        }
    }

    protected void renderARIAInvalid(FacesContext context, UIInput component) throws IOException {
        if (!component.isValid()) {
            ResponseWriter writer = context.getResponseWriter();
            writer.writeAttribute("aria-invalid", (Object)"true", null);
        }
    }

    protected void renderAccessibilityAttributes(FacesContext context, UIInput component) throws IOException {
        this.renderAccessibilityAttributes(context, component, this.isDisabled(component), this.isReadOnly(component));
    }

    protected void renderAccessibilityAttributes(FacesContext context, UIInput component, boolean disabled, boolean readonly) throws IOException {
        InputHolder inputHolder;
        String labelledBy;
        ResponseWriter writer = context.getResponseWriter();
        this.renderARIARequired(context, component);
        this.renderARIAInvalid(context, component);
        if (component instanceof InputHolder && !LangUtils.isValueBlank(labelledBy = (inputHolder = (InputHolder)component).getLabelledBy())) {
            writer.writeAttribute("aria-labelledby", (Object)labelledBy, null);
        }
        if (disabled) {
            writer.writeAttribute("disabled", (Object)"disabled", null);
            writer.writeAttribute("aria-disabled", (Object)"true", null);
        }
        if (readonly) {
            writer.writeAttribute("readonly", (Object)"readonly", null);
            writer.writeAttribute("aria-readonly", (Object)"true", null);
        }
    }

    protected void renderARIACombobox(FacesContext context, UIInput component) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.writeAttribute("role", (Object)"combobox", null);
        writer.writeAttribute("aria-haspopup", (Object)"true", null);
        writer.writeAttribute("aria-expanded", (Object)"false", null);
    }
}

