/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.util;

import java.io.IOException;
import java.io.Writer;
import java.util.List;
import org.primefaces.model.charts.bubble.BubblePoint;
import org.primefaces.util.EscapeUtils;

public class ChartUtils {
    private ChartUtils() {
    }

    public static void writeDataValue(Writer fsw, String optionName, Object value, boolean hasComma) throws IOException {
        if (value == null) {
            return;
        }
        boolean isList = value instanceof List;
        if (hasComma) {
            fsw.write(",");
        }
        fsw.write("\"" + optionName + "\":");
        if (isList) {
            fsw.write("[");
            for (int i = 0; i < ((List)value).size(); ++i) {
                String writeText;
                Object item = ((List)value).get(i);
                if (item instanceof BubblePoint) {
                    BubblePoint point = (BubblePoint)item;
                    writeText = i == 0 ? "" : ",";
                    writeText = writeText + "{\"x\":" + point.getX() + ",\"y\":" + point.getY() + ",\"r\":" + point.getR() + "}";
                } else if (item instanceof String) {
                    String escapedText = EscapeUtils.forJavaScript((String)item);
                    writeText = i == 0 ? "\"" + escapedText + "\"" : ",\"" + escapedText + "\"";
                } else {
                    writeText = i == 0 ? item : "," + item;
                }
                fsw.write("" + writeText);
            }
            fsw.write("]");
        } else if (value instanceof String) {
            fsw.write("\"" + EscapeUtils.forJavaScript((String)value) + "\"");
        } else {
            fsw.write("" + value);
        }
    }
}

