/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.faces.FacesException;
import javax.faces.context.FacesContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.primefaces.component.fileupload.FileUpload;
import org.primefaces.context.PrimeApplicationContext;
import org.primefaces.shaded.commons.io.FilenameUtils;
import org.primefaces.shaded.commons.io.IOUtils;
import org.primefaces.shaded.owasp.esapi.SafeFile;
import org.primefaces.shaded.owasp.esapi.errors.ValidationException;
import org.primefaces.util.EscapeUtils;
import org.primefaces.util.LangUtils;
import org.primefaces.virusscan.VirusException;

public class FileUploadUtils {
    private static final Logger LOGGER = Logger.getLogger(FileUploadUtils.class.getName());
    private static final Pattern INVALID_FILENAME_PATTERN = Pattern.compile("([\\/:*?\"<>|])");

    private FileUploadUtils() {
    }

    public static String getValidFilename(String filename) {
        if (LangUtils.isValueBlank(filename)) {
            return null;
        }
        if (FileUploadUtils.isSystemWindows()) {
            if (!filename.contains("\\\\")) {
                String[] parts;
                for (String part : parts = filename.substring(FilenameUtils.getPrefixLength(filename)).split(Pattern.quote(File.separator))) {
                    if (!INVALID_FILENAME_PATTERN.matcher(part).find()) continue;
                    throw new FacesException("Invalid filename: " + filename);
                }
            } else {
                throw new FacesException("Invalid filename: " + filename);
            }
        }
        String name = FilenameUtils.getName(filename);
        String extension = FilenameUtils.EXTENSION_SEPARATOR_STR + FilenameUtils.getExtension(filename);
        if (extension.equals(FilenameUtils.EXTENSION_SEPARATOR_STR)) {
            throw new FacesException("File must have an extension");
        }
        if (name.isEmpty() || extension.equals(name)) {
            throw new FacesException("Filename can not be the empty string");
        }
        return name;
    }

    public static String getValidFilePath(String filePath) throws ValidationException {
        if (filePath == null || filePath.trim().equals("")) {
            throw new FacesException("Path can not be the empty string or null");
        }
        try {
            SafeFile file = new SafeFile(filePath);
            File parentFile = file.getParentFile();
            if (!file.exists()) {
                throw new ValidationException("Invalid directory", "Invalid directory, \"" + file + "\" does not exist.");
            }
            if (!parentFile.exists()) {
                throw new ValidationException("Invalid directory", "Invalid directory, specified parent does not exist.");
            }
            if (!parentFile.isDirectory()) {
                throw new ValidationException("Invalid directory", "Invalid directory, specified parent is not a directory.");
            }
            if (!file.getCanonicalPath().startsWith(parentFile.getCanonicalPath())) {
                throw new ValidationException("Invalid directory", "Invalid directory, \"" + file + "\" does not inside specified parent.");
            }
            if (!file.getCanonicalPath().equals(filePath)) {
                throw new ValidationException("Invalid directory", "Invalid directory name does not match the canonical path");
            }
        }
        catch (IOException ex) {
            throw new ValidationException("Invalid directory", "Failure to validate directory path");
        }
        return filePath;
    }

    public static boolean isSystemWindows() {
        return File.separatorChar == '\\';
    }

    public static boolean isValidType(FileUpload fileUpload, String fileName, InputStream inputStream) {
        try {
            boolean validType;
            boolean bl = validType = FileUploadUtils.isValidFileName(fileUpload, fileName) && FileUploadUtils.isValidFileContent(fileUpload, fileName, inputStream);
            if (validType && LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine(String.format("The uploaded file %s meets the filename and content type specifications", fileName));
            }
            return validType;
        }
        catch (IOException | ScriptException ex) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.log(Level.WARNING, String.format("The type of the uploaded file %s could not be validated", fileName), ex);
            }
            return false;
        }
    }

    private static boolean isValidFileName(FileUpload fileUpload, String fileName) throws ScriptException {
        String fileNameRegex = fileUpload.getAllowTypes();
        if (!LangUtils.isValueBlank(fileNameRegex)) {
            ScriptEngine engine = new ScriptEngineManager().getEngineByName("javascript");
            if (engine == null) {
                engine = new ScriptEngineManager(null).getEngineByName("javascript");
            }
            if (engine == null) {
                throw new ScriptException(new NullPointerException("JavaScript ScriptEngine not available via the context ClassLoader or the extension ClassLoader."));
            }
            String evalJs = String.format("%s.test(\"%s\")", fileNameRegex, EscapeUtils.forJavaScriptAttribute(fileName));
            if (!Boolean.TRUE.equals(engine.eval(evalJs))) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine(String.format("The uploaded filename %s does not match the specified regex %s", fileName, fileNameRegex));
                }
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isValidFileContent(FileUpload fileUpload, String fileName, InputStream inputStream) throws IOException {
        block45: {
            Path tempFile;
            block43: {
                boolean bl;
                block44: {
                    String contentType;
                    block41: {
                        boolean bl2;
                        block42: {
                            boolean tika;
                            if (!fileUpload.isValidateContentType()) {
                                if (LOGGER.isLoggable(Level.FINE)) {
                                    LOGGER.fine("Content type checking is disabled");
                                }
                                return true;
                            }
                            if (LangUtils.isValueBlank(fileUpload.getAccept())) {
                                return true;
                            }
                            boolean bl3 = tika = LangUtils.tryToLoadClassForName("org.apache.tika.filetypedetector.TikaFileTypeDetector") != null;
                            if (!tika && LOGGER.isLoggable(Level.WARNING)) {
                                LOGGER.warning("Could not find Apache Tika in classpath which is recommended for reliable content type checking");
                            }
                            String tempFileSuffix = tika ? null : "." + FilenameUtils.getExtension(fileName);
                            String tempFilePrefix = UUID.randomUUID().toString();
                            tempFile = Files.createTempFile(tempFilePrefix, tempFileSuffix, new FileAttribute[0]);
                            PushbackInputStream in = new PushbackInputStream(new BufferedInputStream(inputStream));
                            try (FileOutputStream out = new FileOutputStream(tempFile.toFile());){
                                IOUtils.copyLarge(in, out);
                            }
                            contentType = Files.probeContentType(tempFile);
                            if (contentType != null) break block41;
                            if (LOGGER.isLoggable(Level.WARNING)) {
                                LOGGER.warning(String.format("Could not determine content type of uploaded file %s, consider plugging in an adequate FileTypeDetector implementation", fileName));
                            }
                            bl2 = false;
                            try {
                                Files.delete(tempFile);
                            }
                            catch (Exception ex) {
                                if (!LOGGER.isLoggable(Level.WARNING)) break block42;
                                LOGGER.log(Level.WARNING, String.format("Could not delete temporary file %s, will try to delete on JVM exit", tempFile.toAbsolutePath()), ex);
                                try {
                                    tempFile.toFile().deleteOnExit();
                                }
                                catch (Exception ex1) {
                                    if (!LOGGER.isLoggable(Level.WARNING)) break block42;
                                    LOGGER.log(Level.WARNING, String.format("Could not register temporary file %s for deletion on JVM exit", tempFile.toAbsolutePath()), ex1);
                                }
                            }
                        }
                        return bl2;
                    }
                    try {
                        String[] accepts = fileUpload.getAccept().split(",");
                        boolean accepted = false;
                        for (String accept : accepts) {
                            if ((accept = accept.trim().toLowerCase()).startsWith(".") && fileName.toLowerCase().endsWith(accept)) {
                                accepted = true;
                                if (!LOGGER.isLoggable(Level.FINE)) break;
                                LOGGER.fine(String.format("The file extension %s of the uploaded file %s is accepted", accept, fileName));
                                break;
                            }
                            if (!FilenameUtils.wildcardMatch(contentType.toLowerCase(), accept)) continue;
                            accepted = true;
                            if (!LOGGER.isLoggable(Level.FINE)) break;
                            LOGGER.fine(String.format("The content type %s of the uploaded file %s is accepted by %s", contentType, fileName, accept));
                            break;
                        }
                        if (accepted) break block43;
                        if (LOGGER.isLoggable(Level.FINE)) {
                            LOGGER.fine(String.format("The uploaded file %s with content type %s does not match the accept specification %s", fileName, contentType, fileUpload.getAccept()));
                        }
                        bl = false;
                    }
                    catch (Throwable throwable) {
                        block46: {
                            try {
                                Files.delete(tempFile);
                            }
                            catch (Exception ex) {
                                if (!LOGGER.isLoggable(Level.WARNING)) break block46;
                                LOGGER.log(Level.WARNING, String.format("Could not delete temporary file %s, will try to delete on JVM exit", tempFile.toAbsolutePath()), ex);
                                try {
                                    tempFile.toFile().deleteOnExit();
                                }
                                catch (Exception ex1) {
                                    if (!LOGGER.isLoggable(Level.WARNING)) break block46;
                                    LOGGER.log(Level.WARNING, String.format("Could not register temporary file %s for deletion on JVM exit", tempFile.toAbsolutePath()), ex1);
                                }
                            }
                        }
                        throw throwable;
                    }
                    try {
                        Files.delete(tempFile);
                    }
                    catch (Exception ex) {
                        if (!LOGGER.isLoggable(Level.WARNING)) break block44;
                        LOGGER.log(Level.WARNING, String.format("Could not delete temporary file %s, will try to delete on JVM exit", tempFile.toAbsolutePath()), ex);
                        try {
                            tempFile.toFile().deleteOnExit();
                        }
                        catch (Exception ex1) {
                            if (!LOGGER.isLoggable(Level.WARNING)) break block44;
                            LOGGER.log(Level.WARNING, String.format("Could not register temporary file %s for deletion on JVM exit", tempFile.toAbsolutePath()), ex1);
                        }
                    }
                }
                return bl;
            }
            try {
                Files.delete(tempFile);
            }
            catch (Exception ex) {
                if (!LOGGER.isLoggable(Level.WARNING)) break block45;
                LOGGER.log(Level.WARNING, String.format("Could not delete temporary file %s, will try to delete on JVM exit", tempFile.toAbsolutePath()), ex);
                try {
                    tempFile.toFile().deleteOnExit();
                }
                catch (Exception ex1) {
                    if (LOGGER.isLoggable(Level.WARNING)) {
                        LOGGER.log(Level.WARNING, String.format("Could not register temporary file %s for deletion on JVM exit", tempFile.toAbsolutePath()), ex1);
                    }
                }
            }
        }
        return true;
    }

    public static void performVirusScan(FacesContext facesContext, FileUpload fileUpload, InputStream inputStream) throws VirusException {
        if (fileUpload.isPerformVirusScan()) {
            PrimeApplicationContext.getCurrentInstance(facesContext).getVirusScannerService().performVirusScan(inputStream);
        }
    }
}

