/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.component.speedtest;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.application.ResourceDependencies;
import javax.faces.application.ResourceDependency;
import javax.faces.component.UIComponent;
import javax.faces.component.UIComponentBase;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.FacesContext;
import javax.faces.event.AjaxBehaviorEvent;
import javax.faces.event.FacesEvent;
import org.primefaces.component.api.Widget;
import org.primefaces.extensions.event.SpeedTestEvent;
import org.primefaces.util.ComponentUtils;

@ResourceDependencies(value={@ResourceDependency(library="primefaces", name="jquery/jquery.js"), @ResourceDependency(library="primefaces", name="jquery/jquery-plugins.js"), @ResourceDependency(library="primefaces", name="core.js"), @ResourceDependency(library="primefaces", name="raphael/raphael.js"), @ResourceDependency(library="primefaces-extensions", name="primefaces-extensions.js"), @ResourceDependency(library="primefaces-extensions", name="speedtest/speedtest.js")})
public class Speedtest
extends UIComponentBase
implements ClientBehaviorHolder,
Widget {
    public static final String COMPONENT_FAMILY = "org.primefaces.extensions.component";
    public static final String COMPONENT_TYPE = "org.primefaces.extensions.component.Speedtest";
    private static final String DEFAULT_RENDERER = "org.primefaces.extensions.component.SpeedtestRenderer";
    private static final Collection<String> EVENT_NAMES = Collections.unmodifiableCollection(Arrays.asList("speedtest"));

    public Speedtest() {
        this.setRendererType(DEFAULT_RENDERER);
    }

    public String resolveWidgetVar() {
        return ComponentUtils.resolveWidgetVar((FacesContext)this.getFacesContext(), (Widget)this);
    }

    public String getFamily() {
        return COMPONENT_FAMILY;
    }

    public Collection<String> getEventNames() {
        return EVENT_NAMES;
    }

    public String getDefaultEventName() {
        return "speedtest";
    }

    private Double convertParam(String clientId, String paramName, Map<String, String> params) {
        Double res = 0.0;
        try {
            res = Double.valueOf(params.get(clientId + paramName));
        }
        catch (Exception e) {
            throw new FacesException("Speedtest: can not convert result value for '" + paramName + "'");
        }
        return res;
    }

    public void queueEvent(FacesEvent event) {
        FacesContext fc = FacesContext.getCurrentInstance();
        if (this.isSelfRequest(fc) && event instanceof AjaxBehaviorEvent) {
            Map params = fc.getExternalContext().getRequestParameterMap();
            String eventName = (String)params.get("javax.faces.behavior.event");
            String clientId = this.getClientId(fc);
            AjaxBehaviorEvent behaviorEvent = (AjaxBehaviorEvent)event;
            if ("speedtest".equals(eventName)) {
                Double pingTimeMS = this.convertParam(clientId, "_PingTimeMS", params);
                Double jitterTimeMS = this.convertParam(clientId, "_JitterTimeMS", params);
                Double speedMbpsDownload = this.convertParam(clientId, "_SpeedMbpsDownload", params);
                Double speedMbpsUpload = this.convertParam(clientId, "_SpeedMbpsUpload", params);
                SpeedTestEvent speedtestEvent = new SpeedTestEvent((UIComponent)this, behaviorEvent.getBehavior(), pingTimeMS, jitterTimeMS, speedMbpsDownload, speedMbpsUpload);
                speedtestEvent.setPhaseId(event.getPhaseId());
                super.queueEvent((FacesEvent)speedtestEvent);
                return;
            }
        }
        super.queueEvent(event);
    }

    private boolean isSelfRequest(FacesContext context) {
        return this.getClientId(context).equals(context.getExternalContext().getRequestParameterMap().get("javax.faces.source"));
    }

    public String getWidgetVar() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.widgetVar), null);
    }

    public void setWidgetVar(String _widgetVar) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.widgetVar), (Object)_widgetVar);
    }

    public String getCaptionPing() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.captionPing), (Object)"Ping");
    }

    public void setCaptionPing(String _captionPing) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.captionPing), (Object)_captionPing);
    }

    public String getCaptionJitter() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.captionJitter), (Object)"Jitter");
    }

    public void setCaptionJitter(String _captionJitter) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.captionJitter), (Object)_captionJitter);
    }

    public String getCaptionDownload() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.captionDownload), (Object)"Download");
    }

    public void setCaptionDownload(String _captionDownload) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.captionDownload), (Object)_captionDownload);
    }

    public String getCaptionUpload() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.captionUpload), (Object)"Upload");
    }

    public void setCaptionUpload(String _captionUpload) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.captionUpload), (Object)_captionUpload);
    }

    public String getColorPing() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.colorPing), (Object)"#993333");
    }

    public void setColorPing(String _colorPing) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.colorPing), (Object)_colorPing);
    }

    public String getColorJitter() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.colorJitter), (Object)"#d2900a");
    }

    public void setColorJitter(String _colorJitter) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.colorJitter), (Object)_colorJitter);
    }

    public String getColorDownload() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.colorDownload), (Object)"#339933");
    }

    public void setColorDownload(String _colorDownload) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.colorDownload), (Object)_colorDownload);
    }

    public String getColorUpload() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.colorUpload), (Object)"#333399");
    }

    public void setColorUpload(String _colorUpload) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.colorUpload), (Object)_colorUpload);
    }

    public String getStyle() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.style), null);
    }

    public void setStyle(String _style) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.style), (Object)_style);
    }

    public String getStyleClass() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.styleClass), null);
    }

    public void setStyleClass(String _styleClass) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.styleClass), (Object)_styleClass);
    }

    public String getFile() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.file), null);
    }

    public void setFile(String _File) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.file), (Object)_File);
    }

    protected static enum PropertyKeys {
        widgetVar,
        captionPing,
        captionJitter,
        captionDownload,
        captionUpload,
        colorPing,
        colorJitter,
        colorDownload,
        colorUpload,
        file,
        style,
        styleClass;

        private String toString;

        private PropertyKeys(String toString) {
            this.toString = toString;
        }

        private PropertyKeys() {
        }

        public String toString() {
            return this.toString != null ? this.toString : super.toString();
        }
    }
}

