/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.calendar;

import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.el.ValueExpression;
import javax.faces.application.FacesMessage;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import org.primefaces.component.api.UICalendar;
import org.primefaces.renderkit.InputRenderer;
import org.primefaces.util.CalendarUtils;
import org.primefaces.util.HTML;
import org.primefaces.util.MessageFactory;

public abstract class BaseCalendarRenderer
extends InputRenderer {
    public void decode(FacesContext context, UIComponent component) {
        UICalendar uicalendar = (UICalendar)component;
        if (!this.shouldDecode((UIInput)uicalendar)) {
            return;
        }
        String param = uicalendar.getClientId(context) + "_input";
        String submittedValue = (String)context.getExternalContext().getRequestParameterMap().get(param);
        if (submittedValue != null) {
            uicalendar.setSubmittedValue(submittedValue);
        }
        this.decodeBehaviors(context, (UIComponent)uicalendar);
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        UICalendar uicalendar = (UICalendar)component;
        String markupValue = CalendarUtils.getValueAsString(context, uicalendar);
        String widgetValue = uicalendar.isTimeOnly() ? CalendarUtils.getTimeOnlyValueAsString(context, uicalendar) : markupValue;
        this.encodeMarkup(context, uicalendar, markupValue);
        this.encodeScript(context, uicalendar, widgetValue);
    }

    protected abstract void encodeMarkup(FacesContext var1, UICalendar var2, String var3) throws IOException;

    protected abstract void encodeScript(FacesContext var1, UICalendar var2, String var3) throws IOException;

    protected void encodeInput(FacesContext context, UICalendar uicalendar, String id, String value, boolean popup) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String type = popup ? uicalendar.getType() : "hidden";
        String inputStyle = uicalendar.getInputStyle();
        String inputStyleClass = uicalendar.getInputStyleClass();
        writer.startElement("input", null);
        writer.writeAttribute("id", (Object)id, null);
        writer.writeAttribute("name", (Object)id, null);
        writer.writeAttribute("type", (Object)type, null);
        if (!this.isValueBlank(value)) {
            writer.writeAttribute("value", (Object)value, null);
        }
        boolean readonly = false;
        boolean disabled = false;
        if (popup) {
            inputStyleClass = inputStyleClass == null ? "ui-inputfield ui-widget ui-state-default ui-corner-all" : "ui-inputfield ui-widget ui-state-default ui-corner-all " + inputStyleClass;
            boolean bl = readonly = uicalendar.isReadonly() || uicalendar.isReadonlyInput();
            if (uicalendar.isDisabled()) {
                inputStyleClass = inputStyleClass + " ui-state-disabled";
                disabled = true;
            }
            if (!uicalendar.isValid()) {
                inputStyleClass = inputStyleClass + " ui-state-error";
            }
            writer.writeAttribute("class", (Object)inputStyleClass, null);
            if (inputStyle != null) {
                writer.writeAttribute("style", (Object)inputStyle, null);
            }
            this.renderPassThruAttributes(context, (UIComponent)uicalendar, HTML.INPUT_TEXT_ATTRS_WITHOUT_EVENTS);
            this.renderDomEvents(context, (UIComponent)uicalendar, HTML.INPUT_TEXT_EVENTS);
        }
        this.renderAccessibilityAttributes(context, (UIInput)uicalendar, disabled, readonly);
        this.renderValidationMetadata(context, (EditableValueHolder)uicalendar);
        writer.endElement("input");
    }

    @Override
    public Object getConvertedValue(FacesContext context, UIComponent component, Object value) throws ConverterException {
        UICalendar uicalendar = (UICalendar)component;
        String submittedValue = (String)value;
        SimpleDateFormat format = null;
        if (this.isValueBlank(submittedValue)) {
            return null;
        }
        try {
            Converter converter = uicalendar.getConverter();
            if (converter != null) {
                return converter.getAsObject(context, (UIComponent)uicalendar, submittedValue);
            }
        }
        catch (ConverterException e) {
            uicalendar.setConversionFailed(true);
            throw e;
        }
        try {
            Converter converter;
            Class type;
            ValueExpression ve = uicalendar.getValueExpression("value");
            if (ve != null && (type = ve.getType(context.getELContext())) != null && type != Object.class && type != Date.class && (converter = context.getApplication().createConverter(type)) != null) {
                return converter.getAsObject(context, (UIComponent)uicalendar, submittedValue);
            }
        }
        catch (ConverterException e) {
            uicalendar.setConversionFailed(true);
            throw e;
        }
        format = new SimpleDateFormat(uicalendar.calculatePattern(), uicalendar.calculateLocale(context));
        format.setLenient(false);
        format.setTimeZone(CalendarUtils.calculateTimeZone(uicalendar.getTimeZone()));
        try {
            return format.parse(submittedValue);
        }
        catch (ParseException e) {
            uicalendar.setConversionFailed(true);
            FacesMessage message = null;
            Object[] params = new Object[]{submittedValue, format.format(new Date()), MessageFactory.getLabel(context, (UIComponent)uicalendar)};
            message = uicalendar.isTimeOnly() ? MessageFactory.getMessage("javax.faces.converter.DateTimeConverter.TIME", FacesMessage.SEVERITY_ERROR, params) : (uicalendar.hasTime() ? MessageFactory.getMessage("javax.faces.converter.DateTimeConverter.DATETIME", FacesMessage.SEVERITY_ERROR, params) : MessageFactory.getMessage("javax.faces.converter.DateTimeConverter.DATE", FacesMessage.SEVERITY_ERROR, params));
            throw new ConverterException(message);
        }
    }
}

