/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.calendar;

import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.faces.application.FacesMessage;
import javax.faces.application.ResourceDependencies;
import javax.faces.application.ResourceDependency;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.event.AjaxBehaviorEvent;
import javax.faces.event.FacesEvent;
import javax.faces.event.PhaseId;
import org.primefaces.component.calendar.CalendarBase;
import org.primefaces.event.DateViewChangeEvent;
import org.primefaces.event.SelectEvent;
import org.primefaces.util.CalendarUtils;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.LangUtils;
import org.primefaces.util.MessageFactory;

@ResourceDependencies(value={@ResourceDependency(library="primefaces", name="components.css"), @ResourceDependency(library="primefaces", name="jquery/jquery.js"), @ResourceDependency(library="primefaces", name="jquery/jquery-plugins.js"), @ResourceDependency(library="primefaces", name="core.js"), @ResourceDependency(library="primefaces", name="components.js")})
public class Calendar
extends CalendarBase {
    public static final String COMPONENT_TYPE = "org.primefaces.component.Calendar";
    private static final Collection<String> EVENT_NAMES = LangUtils.unmodifiableList("blur", "change", "valueChange", "click", "dblclick", "focus", "keydown", "keypress", "keyup", "mousedown", "mousemove", "mouseout", "mouseover", "mouseup", "select", "dateSelect", "viewChange", "close");
    private static final Collection<String> UNOBSTRUSIVE_EVENT_NAMES = LangUtils.unmodifiableList("dateSelect", "viewChange", "close");
    private final Map<String, AjaxBehaviorEvent> customEvents = new HashMap<String, AjaxBehaviorEvent>();

    public boolean isPopup() {
        return this.getMode().equalsIgnoreCase("popup");
    }

    public Collection<String> getEventNames() {
        return EVENT_NAMES;
    }

    @Override
    public Collection<String> getUnobstrusiveEventNames() {
        return UNOBSTRUSIVE_EVENT_NAMES;
    }

    public void queueEvent(FacesEvent event) {
        FacesContext context = this.getFacesContext();
        if (ComponentUtils.isRequestSource((UIComponent)this, context) && event instanceof AjaxBehaviorEvent) {
            Map params = context.getExternalContext().getRequestParameterMap();
            String eventName = (String)params.get("javax.faces.behavior.event");
            String clientId = this.getClientId(context);
            AjaxBehaviorEvent behaviorEvent = (AjaxBehaviorEvent)event;
            if (eventName != null) {
                if (eventName.equals("dateSelect")) {
                    this.customEvents.put("dateSelect", (AjaxBehaviorEvent)event);
                } else if (eventName.equals("close")) {
                    this.customEvents.put("close", (AjaxBehaviorEvent)event);
                } else if (eventName.equals("viewChange")) {
                    int month = Integer.parseInt((String)params.get(clientId + "_month"));
                    int year = Integer.parseInt((String)params.get(clientId + "_year"));
                    DateViewChangeEvent dateViewChangeEvent = new DateViewChangeEvent((UIComponent)this, behaviorEvent.getBehavior(), month, year);
                    dateViewChangeEvent.setPhaseId(behaviorEvent.getPhaseId());
                    super.queueEvent((FacesEvent)dateViewChangeEvent);
                } else {
                    super.queueEvent(event);
                }
            }
        } else {
            super.queueEvent(event);
        }
    }

    public void validate(FacesContext context) {
        super.validate(context);
        if (this.isValid() && ComponentUtils.isRequestSource((UIComponent)this, context)) {
            Iterator<String> customEventIter = this.customEvents.keySet().iterator();
            while (customEventIter.hasNext()) {
                AjaxBehaviorEvent behaviorEvent = this.customEvents.get(customEventIter.next());
                SelectEvent selectEvent = new SelectEvent((UIComponent)this, behaviorEvent.getBehavior(), this.getValue());
                if (behaviorEvent.getPhaseId().equals(PhaseId.APPLY_REQUEST_VALUES)) {
                    selectEvent.setPhaseId(PhaseId.PROCESS_VALIDATIONS);
                } else {
                    selectEvent.setPhaseId(PhaseId.INVOKE_APPLICATION);
                }
                super.queueEvent((FacesEvent)selectEvent);
            }
        }
    }

    protected void validateValue(FacesContext context, Object value) {
        super.validateValue(context, value);
        if (this.isValid() && !Calendar.isEmpty((Object)value) && value instanceof Date) {
            Date maxDate;
            Date date = (Date)value;
            Date minDate = CalendarUtils.getObjectAsDate(context, this, this.getMindate());
            if (minDate != null && date.before(minDate)) {
                this.setValid(false);
            }
            if (this.isValid() && (maxDate = CalendarUtils.getObjectAsDate(context, this, this.getMaxdate())) != null && date.after(maxDate)) {
                this.setValid(false);
            }
            if (!this.isValid()) {
                FacesMessage msg = null;
                String validatorMessage = this.getValidatorMessage();
                msg = validatorMessage != null ? new FacesMessage(FacesMessage.SEVERITY_ERROR, validatorMessage, validatorMessage) : MessageFactory.getMessage("primefaces.calendar.OUT_OF_RANGE", FacesMessage.SEVERITY_ERROR, null);
                context.addMessage(this.getClientId(context), msg);
            }
        }
    }
}

