/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.datatable.feature;

import java.io.IOException;
import java.util.Map;
import javax.faces.context.FacesContext;
import org.primefaces.component.datatable.DataTable;
import org.primefaces.component.datatable.DataTableRenderer;
import org.primefaces.component.datatable.TableState;
import org.primefaces.component.datatable.feature.DataTableFeature;

public class ResizableColumnsFeature
implements DataTableFeature {
    @Override
    public void decode(FacesContext context, DataTable table) {
        if (table.isMultiViewState()) {
            Map params = context.getExternalContext().getRequestParameterMap();
            String resizableColumnParam = (String)params.get(table.getClientId(context) + "_resizableColumnState");
            TableState ts = table.getTableState(true);
            ts.setResizableColumnsAsString(resizableColumnParam);
        }
    }

    @Override
    public void encode(FacesContext context, DataTableRenderer renderer, DataTable table) throws IOException {
        throw new RuntimeException("ResizableColumnsFeature should not encode.");
    }

    @Override
    public boolean shouldDecode(FacesContext context, DataTable table) {
        return context.getExternalContext().getRequestParameterMap().containsKey(table.getClientId(context) + "_resizableColumnState");
    }

    @Override
    public boolean shouldEncode(FacesContext context, DataTable table) {
        return false;
    }
}

