/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.datepicker;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import javax.faces.component.UIComponent;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.ConverterException;
import org.primefaces.component.api.UICalendar;
import org.primefaces.component.calendar.BaseCalendarRenderer;
import org.primefaces.component.datepicker.DatePicker;
import org.primefaces.expression.SearchExpressionFacade;
import org.primefaces.util.CalendarUtils;
import org.primefaces.util.WidgetBuilder;

public class DatePickerRenderer
extends BaseCalendarRenderer {
    @Override
    protected void encodeMarkup(FacesContext context, UICalendar uicalendar, String value) throws IOException {
        DatePicker datepicker = (DatePicker)uicalendar;
        ResponseWriter writer = context.getResponseWriter();
        String clientId = datepicker.getClientId(context);
        String styleClass = datepicker.getStyleClass();
        styleClass = styleClass == null ? "ui-calendar" : "ui-calendar " + styleClass;
        styleClass = "p-datepicker " + styleClass;
        String inputId = clientId + "_input";
        boolean inline = datepicker.isInline();
        writer.startElement("span", (UIComponent)datepicker);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.writeAttribute("class", (Object)styleClass, null);
        if (datepicker.getStyle() != null) {
            writer.writeAttribute("style", (Object)datepicker.getStyle(), null);
        }
        if (inline) {
            writer.startElement("div", null);
            writer.writeAttribute("id", (Object)(clientId + "_inline"), null);
            writer.endElement("div");
        }
        this.encodeInput(context, datepicker, inputId, value, !inline);
        writer.endElement("span");
    }

    @Override
    protected void encodeScript(FacesContext context, UICalendar uicalendar, String value) throws IOException {
        String onYearChange;
        String onMonthChange;
        String beforeShow;
        String dateTemplate;
        List disabledDates;
        DatePicker datepicker = (DatePicker)uicalendar;
        String clientId = datepicker.getClientId(context);
        Locale locale = datepicker.calculateLocale(context);
        String pattern = datepicker.isTimeOnly() ? datepicker.calculateTimeOnlyPattern() : datepicker.calculatePattern();
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.init("DatePicker", datepicker.resolveWidgetVar(), clientId);
        String defaultDate = null;
        if (datepicker.isConversionFailed()) {
            defaultDate = CalendarUtils.getValueAsString(context, datepicker, new Date());
        } else if (!this.isValueBlank(value)) {
            defaultDate = value;
        }
        wb.attr("defaultDate", defaultDate, null).attr("inline", datepicker.isInline()).attr("userLocale", locale.toString()).attr("dateFormat", CalendarUtils.convertPattern(pattern)).attr("showIcon", datepicker.isShowIcon(), false).attr("buttonTabindex", datepicker.getButtonTabindex()).attr("focusOnSelect", datepicker.isFocusOnSelect(), false).attr("disabled", datepicker.isDisabled(), false).attr("yearRange", datepicker.getYearRange(), null).attr("minDate", CalendarUtils.getValueAsString(context, datepicker, datepicker.getMindate()), null).attr("maxDate", CalendarUtils.getValueAsString(context, datepicker, datepicker.getMaxdate()), null).attr("selectionMode", datepicker.getSelectionMode(), null).attr("showOnFocus", datepicker.isShowOnFocus(), false).attr("shortYearCutoff", datepicker.getShortYearCutoff(), null).attr("monthNavigator", datepicker.isMonthNavigator(), false).attr("yearNavigator", datepicker.isYearNavigator(), false).attr("showButtonBar", datepicker.isShowButtonBar(), false).attr("panelStyleClass", datepicker.getPanelStyleClass(), null).attr("panelStyle", datepicker.getPanelStyle(), null).attr("keepInvalid", datepicker.isKeepInvalid(), false).attr("maxDateCount", datepicker.getMaxDateCount(), Integer.MAX_VALUE).attr("numberOfMonths", datepicker.getNumberOfMonths(), 1).attr("view", datepicker.getView(), null).attr("touchUI", datepicker.isTouchUI(), false).attr("appendTo", SearchExpressionFacade.resolveClientId(context, (UIComponent)datepicker, datepicker.getAppendTo()), null).attr("icon", datepicker.getTriggerButtonIcon(), null);
        List disabledDays = datepicker.getDisabledDays();
        if (disabledDays != null) {
            CalendarUtils.encodeListValue(context, datepicker, "disabledDays", disabledDays);
        }
        if ((disabledDates = datepicker.getDisabledDates()) != null) {
            CalendarUtils.encodeListValue(context, datepicker, "disabledDates", disabledDates);
        }
        if ((dateTemplate = datepicker.getDateTemplate()) != null) {
            wb.nativeAttr("dateTemplate", dateTemplate);
        }
        if ((beforeShow = datepicker.getBeforeShow()) != null) {
            wb.nativeAttr("preShow", beforeShow);
        }
        if ((onMonthChange = datepicker.getOnMonthChange()) != null) {
            wb.nativeAttr("onMonthChange", onMonthChange);
        }
        if ((onYearChange = datepicker.getOnYearChange()) != null) {
            wb.nativeAttr("onYearChange", onYearChange);
        }
        if (datepicker.isShowOtherMonths()) {
            wb.attr("showOtherMonths", true).attr("selectOtherMonths", datepicker.isSelectOtherMonths());
        }
        if (datepicker.hasTime()) {
            wb.attr("showTime", datepicker.isShowTime(), false).attr("hourFormat", datepicker.getHourFormat(), null).attr("timeOnly", datepicker.isTimeOnly(), false).attr("showSeconds", datepicker.isShowSeconds(), false).attr("stepHour", datepicker.getStepHour(), 1).attr("stepMinute", datepicker.getStepMinute(), 1).attr("stepSecond", datepicker.getStepSecond(), 1).attr("hideOnDateTimeSelect", datepicker.isHideOnDateTimeSelect(), false);
        }
        this.encodeClientBehaviors(context, (ClientBehaviorHolder)datepicker);
        wb.finish();
    }

    @Override
    public Object getConvertedValue(FacesContext context, UIComponent component, Object value) throws ConverterException {
        String selectionMode;
        DatePicker datepicker = (DatePicker)component;
        String submittedValue = (String)value;
        if (this.isValueBlank(submittedValue)) {
            return null;
        }
        switch (selectionMode = datepicker.getSelectionMode()) {
            case "multiple": {
                String[] parts = submittedValue.split(",");
                ArrayList<Object> multi = new ArrayList<Object>();
                for (String part : parts) {
                    multi.add(super.getConvertedValue(context, component, part));
                }
                return multi;
            }
            case "range": {
                String[] parts = submittedValue.split("-");
                ArrayList<Object> range = new ArrayList<Object>();
                if (parts.length == 2) {
                    for (String part : parts) {
                        range.add(super.getConvertedValue(context, component, part));
                    }
                }
                return range;
            }
        }
        return super.getConvertedValue(context, component, value);
    }
}

