/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.export;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Paragraph;
import javax.faces.component.UIComponent;
import javax.faces.component.visit.VisitCallback;
import javax.faces.component.visit.VisitContext;
import javax.faces.component.visit.VisitResult;
import javax.faces.view.facelets.FaceletException;
import org.primefaces.component.datatable.DataTable;
import org.primefaces.component.export.PDFExporter;

public class PDFExportVisitCallback
implements VisitCallback {
    private final PDFExporter exporter;
    private final Document document;
    private final boolean pageOnly;
    private final boolean selectionOnly;
    private final String encoding;

    public PDFExportVisitCallback(PDFExporter exporter, Document document, boolean pageOnly, boolean selectionOnly, String encoding) {
        this.exporter = exporter;
        this.document = document;
        this.pageOnly = pageOnly;
        this.selectionOnly = selectionOnly;
        this.encoding = encoding;
    }

    public VisitResult visit(VisitContext context, UIComponent target) {
        DataTable dt = (DataTable)target;
        try {
            this.document.add((Element)this.exporter.exportPDFTable(context.getFacesContext(), dt, this.pageOnly, this.selectionOnly, this.encoding));
            Paragraph preface = new Paragraph();
            this.exporter.addEmptyLine(preface, 3);
            this.document.add((Element)preface);
        }
        catch (DocumentException e) {
            throw new FaceletException(e.getMessage());
        }
        return VisitResult.ACCEPT;
    }
}

