/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.filedownload;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import javax.el.ELContext;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.component.StateHolder;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ActionEvent;
import javax.faces.event.ActionListener;
import org.primefaces.context.PrimeRequestContext;
import org.primefaces.model.StreamedContent;
import org.primefaces.util.ComponentUtils;

public class FileDownloadActionListener
implements ActionListener,
StateHolder {
    private ValueExpression value;
    private ValueExpression contentDisposition;
    private ValueExpression monitorKey;

    public FileDownloadActionListener() {
    }

    public FileDownloadActionListener(ValueExpression value, ValueExpression contentDisposition, ValueExpression monitorKey) {
        this.value = value;
        this.contentDisposition = contentDisposition;
        this.monitorKey = monitorKey;
    }

    public void processAction(ActionEvent actionEvent) throws AbortProcessingException {
        FacesContext context = FacesContext.getCurrentInstance();
        ELContext elContext = context.getELContext();
        StreamedContent content = (StreamedContent)this.value.getValue(elContext);
        if (content == null) {
            return;
        }
        ExternalContext externalContext = context.getExternalContext();
        String contentDispositionValue = this.contentDisposition != null ? (String)this.contentDisposition.getValue(elContext) : "attachment";
        String monitorKeyValue = this.monitorKey != null ? "_" + (String)this.monitorKey.getValue(elContext) : "";
        InputStream inputStream = null;
        try {
            int length;
            externalContext.setResponseContentType(content.getContentType());
            externalContext.setResponseHeader("Content-Disposition", ComponentUtils.createContentDisposition(contentDispositionValue, content.getName()));
            externalContext.addResponseCookie("primefaces.download" + monitorKeyValue, "true", Collections.emptyMap());
            if (content.getContentLength() != null) {
                externalContext.setResponseContentLength(content.getContentLength().intValue());
            }
            if (PrimeRequestContext.getCurrentInstance(context).isSecure()) {
                externalContext.setResponseHeader("Cache-Control", "public");
                externalContext.setResponseHeader("Pragma", "public");
            }
            byte[] buffer = new byte[2048];
            inputStream = content.getStream();
            OutputStream outputStream = externalContext.getResponseOutputStream();
            while ((length = inputStream.read(buffer)) != -1) {
                outputStream.write(buffer, 0, length);
            }
            if (!externalContext.isResponseCommitted()) {
                externalContext.setResponseStatus(200);
            }
            externalContext.responseFlushBuffer();
            context.responseComplete();
        }
        catch (IOException e) {
            throw new FacesException((Throwable)e);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public boolean isTransient() {
        return false;
    }

    public void setTransient(boolean value) {
    }

    public void restoreState(FacesContext facesContext, Object state) {
        Object[] values = (Object[])state;
        this.value = (ValueExpression)values[0];
        this.contentDisposition = (ValueExpression)values[1];
        this.monitorKey = (ValueExpression)values[2];
    }

    public Object saveState(FacesContext facesContext) {
        Object[] values = new Object[]{this.value, this.contentDisposition, this.monitorKey};
        return values;
    }
}

