/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.fileupload;

import java.io.IOException;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.servlet.ServletRequestWrapper;
import org.apache.commons.fileupload.FileItem;
import org.primefaces.component.fileupload.FileUpload;
import org.primefaces.event.FileUploadEvent;
import org.primefaces.model.DefaultUploadedFile;
import org.primefaces.model.UploadedFileWrapper;
import org.primefaces.util.FileUploadUtils;
import org.primefaces.virusscan.VirusException;
import org.primefaces.webapp.MultipartRequest;

public class CommonsFileUploadDecoder {
    private CommonsFileUploadDecoder() {
    }

    public static void decode(FacesContext context, FileUpload fileUpload, String inputToDecodeId) {
        MultipartRequest multipartRequest = null;
        Object request = context.getExternalContext().getRequest();
        while (request instanceof ServletRequestWrapper) {
            if (request instanceof MultipartRequest) {
                multipartRequest = (MultipartRequest)((Object)request);
                break;
            }
            request = ((ServletRequestWrapper)request).getRequest();
        }
        if (multipartRequest != null) {
            try {
                if (fileUpload.getMode().equals("simple")) {
                    CommonsFileUploadDecoder.decodeSimple(context, fileUpload, multipartRequest, inputToDecodeId);
                } else {
                    CommonsFileUploadDecoder.decodeAdvanced(context, fileUpload, multipartRequest);
                }
            }
            catch (IOException ioe) {
                throw new FacesException((Throwable)ioe);
            }
        }
    }

    private static void decodeSimple(FacesContext context, FileUpload fileUpload, MultipartRequest request, String inputToDecodeId) throws IOException {
        FileItem file = request.getFileItem(inputToDecodeId);
        if (file != null && !file.getName().isEmpty()) {
            DefaultUploadedFile uploadedFile = new DefaultUploadedFile(file, fileUpload);
            if (CommonsFileUploadDecoder.isValidFile(context, fileUpload, uploadedFile)) {
                fileUpload.setSubmittedValue(new UploadedFileWrapper(uploadedFile));
            } else {
                fileUpload.setSubmittedValue("");
            }
        }
    }

    private static void decodeAdvanced(FacesContext context, FileUpload fileUpload, MultipartRequest request) throws IOException {
        DefaultUploadedFile uploadedFile;
        String clientId = fileUpload.getClientId(context);
        FileItem file = request.getFileItem(clientId);
        if (file != null && CommonsFileUploadDecoder.isValidFile(context, fileUpload, uploadedFile = new DefaultUploadedFile(file, fileUpload))) {
            fileUpload.queueEvent(new FileUploadEvent((UIComponent)fileUpload, uploadedFile));
        }
    }

    private static boolean isValidFile(FacesContext context, FileUpload fileUpload, DefaultUploadedFile uploadedFile) throws IOException {
        boolean valid;
        boolean bl = valid = (fileUpload.getSizeLimit() == null || uploadedFile.getSize() <= fileUpload.getSizeLimit()) && FileUploadUtils.isValidType(fileUpload, uploadedFile.getFileName(), uploadedFile.getInputstream());
        if (valid) {
            try {
                FileUploadUtils.performVirusScan(context, fileUpload, uploadedFile.getInputstream());
            }
            catch (VirusException ex) {
                return false;
            }
        }
        return valid;
    }
}

