/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.headerrow;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.column.Column;
import org.primefaces.component.datatable.DataTable;
import org.primefaces.component.headerrow.HeaderRow;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.MessageFactory;

public class HeaderRowRenderer
extends CoreRenderer {
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        HeaderRow row = (HeaderRow)component;
        DataTable table = (DataTable)row.getParent();
        ResponseWriter writer = context.getResponseWriter();
        boolean isExpandableRowGroups = table.isExpandableRowGroups();
        writer.startElement("tr", null);
        writer.writeAttribute("class", (Object)"ui-rowgroup-header ui-datatable-headerrow ui-widget-header", null);
        boolean isFirstColumn = true;
        for (int i = 0; i < row.getChildCount(); ++i) {
            UIComponent child = (UIComponent)row.getChildren().get(i);
            if (!child.isRendered() || !(child instanceof Column)) continue;
            Column column = (Column)child;
            String style = column.getStyle();
            String styleClass = column.getStyleClass();
            writer.startElement("td", null);
            if (style != null) {
                writer.writeAttribute("style", (Object)style, null);
            }
            if (styleClass != null) {
                writer.writeAttribute("class", (Object)styleClass, null);
            }
            if (column.getRowspan() != 1) {
                writer.writeAttribute("rowspan", (Object)column.getRowspan(), null);
            }
            if (column.getColspan() != 1) {
                writer.writeAttribute("colspan", (Object)column.getColspan(), null);
            }
            if (isExpandableRowGroups && isFirstColumn) {
                String ariaLabel = MessageFactory.getMessage("primefaces.rowgrouptoggler.aria.ROW_GROUP_TOGGLER", null);
                writer.startElement("a", null);
                writer.writeAttribute("class", (Object)"ui-rowgroup-toggler", null);
                writer.writeAttribute("aria-expanded", (Object)String.valueOf(true), null);
                writer.writeAttribute("aria-label", (Object)ariaLabel, null);
                writer.writeAttribute("href", (Object)"#", null);
                writer.startElement("span", null);
                writer.writeAttribute("class", (Object)"ui-rowgroup-toggler-icon ui-icon ui-icon-circle-triangle-s", null);
                writer.endElement("span");
                writer.endElement("a");
                isFirstColumn = false;
            }
            column.encodeAll(context);
            writer.endElement("td");
        }
        writer.endElement("tr");
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }
}

