/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.inputmask;

import java.io.IOException;
import java.util.regex.Pattern;
import javax.faces.FacesException;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.inputmask.InputMask;
import org.primefaces.renderkit.InputRenderer;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.HTML;
import org.primefaces.util.LangUtils;
import org.primefaces.util.SharedStringBuilder;
import org.primefaces.util.WidgetBuilder;

public class InputMaskRenderer
extends InputRenderer {
    private static final String REGEX_METACHARS = "<([{\\^-=$!|]})?*+.>";
    private static final String SB_PATTERN = InputMaskRenderer.class.getName() + "#translateMaskIntoRegex";

    public void decode(FacesContext context, UIComponent component) {
        InputMask inputMask = (InputMask)component;
        if (!this.shouldDecode((UIInput)inputMask)) {
            return;
        }
        this.decodeBehaviors(context, (UIComponent)inputMask);
        String clientId = inputMask.getClientId(context);
        String submittedValue = (String)context.getExternalContext().getRequestParameterMap().get(clientId);
        if (submittedValue != null) {
            Pattern pattern;
            if (!submittedValue.isEmpty() && !(pattern = this.translateMaskIntoRegex(context, inputMask)).matcher(submittedValue).matches()) {
                submittedValue = "";
            }
            inputMask.setSubmittedValue(submittedValue);
        }
    }

    protected Pattern translateMaskIntoRegex(FacesContext context, InputMask inputMask) {
        String mask = inputMask.getMask();
        if (LangUtils.isValueBlank(mask)) {
            throw new FacesException("InputMask requires a value for the 'mask' attribute.");
        }
        StringBuilder regex = SharedStringBuilder.get(context, SB_PATTERN);
        boolean optionalFound = false;
        for (char c : mask.toCharArray()) {
            if (c == '?') {
                optionalFound = true;
                continue;
            }
            regex.append(this.translateMaskCharIntoRegex(c, optionalFound));
        }
        return Pattern.compile(regex.toString());
    }

    protected String translateMaskCharIntoRegex(char c, boolean optional) {
        if (c == '?') {
            return "";
        }
        String translated = c == '9' ? "[0-9]" : (c == 'a' ? "[A-Za-z]" : (c == '*' ? "[A-Za-z0-9]" : (REGEX_METACHARS.indexOf(c) >= 0 ? "\\" + c : String.valueOf(c))));
        return optional ? translated + "?" : translated;
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        InputMask inputMask = (InputMask)component;
        this.encodeMarkup(context, inputMask);
        this.encodeScript(context, inputMask);
    }

    protected void encodeScript(FacesContext context, InputMask inputMask) throws IOException {
        String clientId = inputMask.getClientId(context);
        String mask = inputMask.getMask();
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.init("InputMask", inputMask.resolveWidgetVar(), clientId);
        String slotChar = inputMask.getSlotChar();
        if (mask != null) {
            wb.attr("mask", mask).attr("placeholder", slotChar, null).attr("autoclear", inputMask.isAutoClear(), true);
        }
        wb.finish();
    }

    protected void encodeMarkup(FacesContext context, InputMask inputMask) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = inputMask.getClientId(context);
        String styleClass = inputMask.getStyleClass();
        String defaultClass = "ui-inputfield ui-inputmask ui-widget ui-state-default ui-corner-all";
        defaultClass = !inputMask.isValid() ? defaultClass + " ui-state-error" : defaultClass;
        defaultClass = inputMask.isDisabled() ? defaultClass + " ui-state-disabled" : defaultClass;
        styleClass = styleClass == null ? defaultClass : defaultClass + " " + styleClass;
        writer.startElement("input", null);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.writeAttribute("name", (Object)clientId, null);
        writer.writeAttribute("type", (Object)inputMask.getType(), "text");
        String valueToRender = ComponentUtils.getValueToRender(context, (UIComponent)inputMask);
        if (valueToRender != null) {
            writer.writeAttribute("value", (Object)valueToRender, null);
        }
        this.renderAccessibilityAttributes(context, (UIInput)inputMask);
        this.renderPassThruAttributes(context, (UIComponent)inputMask, HTML.INPUT_TEXT_ATTRS_WITHOUT_EVENTS);
        this.renderDomEvents(context, (UIComponent)inputMask, HTML.INPUT_TEXT_EVENTS);
        if (inputMask.getStyle() != null) {
            writer.writeAttribute("style", (Object)inputMask.getStyle(), "style");
        }
        writer.writeAttribute("class", (Object)styleClass, "styleClass");
        this.renderValidationMetadata(context, (EditableValueHolder)inputMask);
        writer.endElement("input");
    }
}

