/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.layout;

import java.util.Collection;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.application.ResourceDependencies;
import javax.faces.application.ResourceDependency;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.event.AjaxBehaviorEvent;
import javax.faces.event.BehaviorEvent;
import javax.faces.event.FacesEvent;
import org.primefaces.component.layout.LayoutBase;
import org.primefaces.component.layout.LayoutUnit;
import org.primefaces.event.AbstractAjaxBehaviorEvent;
import org.primefaces.event.CloseEvent;
import org.primefaces.event.ResizeEvent;
import org.primefaces.event.ToggleEvent;
import org.primefaces.model.Visibility;
import org.primefaces.util.MapBuilder;

@ResourceDependencies(value={@ResourceDependency(library="primefaces", name="components.css"), @ResourceDependency(library="primefaces", name="layout/layout.css"), @ResourceDependency(library="primefaces", name="jquery/jquery.js"), @ResourceDependency(library="primefaces", name="jquery/jquery-plugins.js"), @ResourceDependency(library="primefaces", name="core.js"), @ResourceDependency(library="primefaces", name="components.js"), @ResourceDependency(library="primefaces", name="layout/layout.js")})
public class Layout
extends LayoutBase {
    public static final String COMPONENT_TYPE = "org.primefaces.component.Layout";
    public static final String UNIT_CLASS = "ui-layout-unit ui-widget ui-widget-content ui-corner-all";
    public static final String UNIT_HEADER_CLASS = "ui-layout-unit-header ui-widget-header ui-corner-all";
    public static final String UNIT_CONTENT_CLASS = "ui-layout-unit-content ui-widget-content";
    public static final String UNIT_FOOTER_CLASS = "ui-layout-unit-footer ui-widget-header ui-corner-all";
    public static final String UNIT_HEADER_TITLE_CLASS = "ui-layout-unit-header-title";
    public static final String UNIT_FOOTER_TITLE_CLASS = "ui-layout-unit-footer-title";
    public static final String UNIT_HEADER_ICON_CLASS = "ui-layout-unit-header-icon ui-state-default ui-corner-all";
    private static final Map<String, Class<? extends BehaviorEvent>> BEHAVIOR_EVENT_MAPPING = MapBuilder.builder().put("close", CloseEvent.class).put("resize", ResizeEvent.class).build();
    private static final Collection<String> EVENT_NAMES = BEHAVIOR_EVENT_MAPPING.keySet();

    @Override
    public Map<String, Class<? extends BehaviorEvent>> getBehaviorEventMapping() {
        return BEHAVIOR_EVENT_MAPPING;
    }

    public Collection<String> getEventNames() {
        return EVENT_NAMES;
    }

    protected LayoutUnit getLayoutUnitByPosition(String name) {
        for (UIComponent child : this.getChildren()) {
            LayoutUnit layoutUnit;
            if (!(child instanceof LayoutUnit) || !(layoutUnit = (LayoutUnit)child).getPosition().equalsIgnoreCase(name)) continue;
            return layoutUnit;
        }
        return null;
    }

    public boolean isNested() {
        return this.getParent() instanceof LayoutUnit;
    }

    public boolean isElementLayout() {
        return !this.isNested() && !this.isFullPage();
    }

    public void processDecodes(FacesContext context) {
        if (this.isSelfRequest(context)) {
            this.decode(context);
        } else {
            super.processDecodes(context);
        }
    }

    public void processValidators(FacesContext context) {
        if (!this.isSelfRequest(context)) {
            super.processValidators(context);
        }
    }

    public void processUpdates(FacesContext context) {
        if (!this.isSelfRequest(context)) {
            super.processUpdates(context);
        }
    }

    private boolean isSelfRequest(FacesContext context) {
        return this.getClientId(context).equals(context.getExternalContext().getRequestParameterMap().get("javax.faces.source"));
    }

    public void queueEvent(FacesEvent event) {
        FacesContext context = this.getFacesContext();
        Map params = context.getExternalContext().getRequestParameterMap();
        String eventName = (String)params.get("javax.faces.behavior.event");
        String clientId = this.getClientId(context);
        if (this.isSelfRequest(context)) {
            AjaxBehaviorEvent behaviorEvent = (AjaxBehaviorEvent)event;
            AbstractAjaxBehaviorEvent wrapperEvent = null;
            if (eventName.equals("toggle")) {
                boolean collapsed = Boolean.parseBoolean((String)params.get(clientId + "_collapsed"));
                LayoutUnit unit = this.getLayoutUnitByPosition((String)params.get(clientId + "_unit"));
                Visibility visibility = collapsed ? Visibility.HIDDEN : Visibility.VISIBLE;
                unit.setCollapsed(collapsed);
                wrapperEvent = new ToggleEvent((UIComponent)unit, behaviorEvent.getBehavior(), visibility);
            } else if (eventName.equals("close")) {
                LayoutUnit unit = this.getLayoutUnitByPosition((String)params.get(clientId + "_unit"));
                unit.setVisible(false);
                wrapperEvent = new CloseEvent((UIComponent)unit, behaviorEvent.getBehavior());
            } else if (eventName.equals("resize")) {
                LayoutUnit unit = this.getLayoutUnitByPosition((String)params.get(clientId + "_unit"));
                String position = unit.getPosition();
                int width = Integer.parseInt((String)params.get(clientId + "_width"));
                int height = Integer.parseInt((String)params.get(clientId + "_height"));
                if (position.equals("west") || position.equals("east")) {
                    unit.setSize(String.valueOf(width));
                } else if (position.equals("north") || position.equals("south")) {
                    unit.setSize(String.valueOf(height));
                }
                wrapperEvent = new ResizeEvent((UIComponent)unit, behaviorEvent.getBehavior(), width, height);
            }
            if (wrapperEvent == null) {
                throw new FacesException("Component " + this.getClass().getName() + " does not support event " + eventName + "!");
            }
            wrapperEvent.setPhaseId(behaviorEvent.getPhaseId());
            super.queueEvent(wrapperEvent);
        } else {
            super.queueEvent(event);
        }
    }
}

