/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.picklist;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import org.primefaces.component.column.Column;
import org.primefaces.component.picklist.PickList;
import org.primefaces.model.DualListModel;
import org.primefaces.renderkit.InputRenderer;
import org.primefaces.renderkit.RendererUtils;
import org.primefaces.util.WidgetBuilder;

public class PickListRenderer
extends InputRenderer {
    public void decode(FacesContext context, UIComponent component) {
        PickList pickList = (PickList)component;
        if (!this.shouldDecode(pickList)) {
            return;
        }
        String clientId = pickList.getClientId(context);
        Map params = context.getExternalContext().getRequestParameterValuesMap();
        String sourceParamKey = clientId + "_source";
        String targetParamKey = clientId + "_target";
        String[] sourceParam = params.containsKey(sourceParamKey) ? (String[])params.get(sourceParamKey) : new String[]{};
        String[] targetParam = params.containsKey(targetParamKey) ? (String[])params.get(targetParamKey) : new String[]{};
        pickList.setSubmittedValue(new String[][]{sourceParam, targetParam});
        this.decodeBehaviors(context, (UIComponent)pickList);
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        PickList pickList = (PickList)component;
        this.encodeMarkup(facesContext, pickList);
        this.encodeScript(facesContext, pickList);
    }

    protected void encodeMarkup(FacesContext context, PickList pickList) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = pickList.getClientId(context);
        DualListModel model = this.getModelValueToRender(context, pickList);
        String styleClass = pickList.getStyleClass();
        styleClass = styleClass == null ? "ui-picklist ui-widget ui-helper-clearfix" : "ui-picklist ui-widget ui-helper-clearfix " + styleClass;
        String labelDisplay = pickList.getLabelDisplay();
        boolean vertical = pickList.getOrientation().equals("vertical");
        if (vertical) {
            styleClass = styleClass + " ui-picklist-vertical";
        }
        if (pickList.isResponsive()) {
            styleClass = styleClass + " ui-picklist-responsive";
        }
        writer.startElement("div", (UIComponent)pickList);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.writeAttribute("class", (Object)styleClass, null);
        if (pickList.getStyle() != null) {
            writer.writeAttribute("style", (Object)pickList.getStyle(), null);
        }
        if (pickList.isShowSourceControls()) {
            this.encodeListControls(context, pickList, "ui-picklist-source-controls ui-picklist-buttons", labelDisplay);
        }
        this.encodeList(context, pickList, clientId + "_source", "ui-widget-content ui-picklist-list ui-picklist-source", model.getSource(), pickList.getFacet("sourceCaption"), pickList.isShowSourceFilter(), true);
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"ui-picklist-buttons", null);
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"ui-picklist-buttons-cell", null);
        if (vertical) {
            this.encodeButton(context, pickList.getAddLabel(), "ui-picklist-button-add", "ui-icon ui-icon-arrow-1-s", labelDisplay);
            this.encodeButton(context, pickList.getAddAllLabel(), "ui-picklist-button-add-all", "ui-icon ui-icon-arrowstop-1-s", labelDisplay);
            this.encodeButton(context, pickList.getRemoveLabel(), "ui-picklist-button-remove", "ui-icon ui-icon-arrow-1-n", labelDisplay);
            this.encodeButton(context, pickList.getRemoveAllLabel(), "ui-picklist-button-remove-all", "ui-icon ui-icon-arrowstop-1-n", labelDisplay);
        } else {
            this.encodeButton(context, pickList.getAddLabel(), "ui-picklist-button-add", "ui-icon ui-icon-arrow-1-e", labelDisplay);
            this.encodeButton(context, pickList.getAddAllLabel(), "ui-picklist-button-add-all", "ui-icon ui-icon-arrowstop-1-e", labelDisplay);
            this.encodeButton(context, pickList.getRemoveLabel(), "ui-picklist-button-remove", "ui-icon ui-icon-arrow-1-w", labelDisplay);
            this.encodeButton(context, pickList.getRemoveAllLabel(), "ui-picklist-button-remove-all", "ui-icon ui-icon-arrowstop-1-w", labelDisplay);
        }
        writer.endElement("div");
        writer.endElement("div");
        this.encodeList(context, pickList, clientId + "_target", "ui-widget-content ui-picklist-list ui-picklist-target", model.getTarget(), pickList.getFacet("targetCaption"), pickList.isShowTargetFilter(), false);
        if (pickList.isShowTargetControls()) {
            this.encodeListControls(context, pickList, "ui-picklist-target-controls ui-picklist-buttons", labelDisplay);
        }
        this.encodeAriaRegion(context, clientId);
        writer.endElement("div");
    }

    protected void encodeScript(FacesContext context, PickList pickList) throws IOException {
        String clientId = pickList.getClientId(context);
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.init("PickList", pickList.resolveWidgetVar(), clientId).attr("effect", pickList.getEffect()).attr("effectSpeed", pickList.getEffectSpeed()).attr("escape", pickList.isEscape()).attr("showSourceControls", pickList.isShowSourceControls(), false).attr("showTargetControls", pickList.isShowTargetControls(), false).attr("disabled", pickList.isDisabled(), false).attr("filterEvent", pickList.getFilterEvent(), null).attr("filterDelay", pickList.getFilterDelay(), Integer.MAX_VALUE).attr("filterMatchMode", pickList.getFilterMatchMode(), null).nativeAttr("filterFunction", pickList.getFilterFunction(), null).attr("showCheckbox", pickList.isShowCheckbox(), false).callback("onTransfer", "function(e)", pickList.getOnTransfer()).attr("tabindex", pickList.getTabindex(), "0");
        this.encodeClientBehaviors(context, pickList);
        wb.finish();
    }

    protected void encodeListControls(FacesContext context, PickList pickList, String styleClass, String labelDisplay) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)styleClass, null);
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"ui-picklist-buttons-cell", null);
        this.encodeButton(context, pickList.getMoveUpLabel(), "ui-picklist-button-move-up", "ui-icon ui-icon-arrow-1-n", labelDisplay);
        this.encodeButton(context, pickList.getMoveTopLabel(), "ui-picklist-button-move-top", "ui-icon ui-icon-arrowstop-1-n", labelDisplay);
        this.encodeButton(context, pickList.getMoveDownLabel(), "ui-picklist-button-move-down", "ui-icon ui-icon-arrow-1-s", labelDisplay);
        this.encodeButton(context, pickList.getMoveBottomLabel(), "ui-picklist-button-move-bottom", "ui-icon ui-icon-arrowstop-1-s", labelDisplay);
        writer.endElement("div");
        writer.endElement("div");
    }

    protected void encodeCaption(FacesContext context, UIComponent caption) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"ui-picklist-caption ui-widget-header ui-corner-tl ui-corner-tr", null);
        caption.encodeAll(context);
        writer.endElement("div");
    }

    protected void encodeButton(FacesContext context, String title, String styleClass, String icon, String labelDisplay) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        boolean tooltip = labelDisplay.equals("tooltip");
        String buttonClass = tooltip ? "ui-button ui-widget ui-state-default ui-corner-all ui-button-icon-only" : "ui-button ui-widget ui-state-default ui-corner-all ui-button-text-icon-left";
        writer.startElement("button", null);
        writer.writeAttribute("type", (Object)"button", null);
        writer.writeAttribute("class", (Object)(buttonClass + " " + styleClass), null);
        if (tooltip) {
            writer.writeAttribute("title", (Object)title, null);
        }
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)("ui-button-icon-left ui-icon ui-c " + icon), null);
        writer.endElement("span");
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)"ui-button-text ui-c", null);
        writer.writeText((Object)title, null);
        writer.endElement("span");
        writer.endElement("button");
    }

    protected void encodeList(FacesContext context, PickList pickList, String listId, String styleClass, List model, UIComponent caption, boolean filter, boolean isSource) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"ui-picklist-list-wrapper", null);
        if (!isSource) {
            this.renderARIARequired(context, pickList);
        }
        if (filter) {
            this.encodeFilter(context, pickList, listId + "_filter", isSource);
        }
        if (caption != null) {
            this.encodeCaption(context, caption);
            styleClass = styleClass + " ui-corner-bottom";
        } else {
            styleClass = styleClass + " ui-corner-all";
        }
        writer.startElement("ul", null);
        writer.writeAttribute("class", (Object)styleClass, null);
        writer.writeAttribute("role", (Object)"menu", null);
        this.encodeOptions(context, pickList, model);
        writer.endElement("ul");
        this.encodeListInput(context, listId);
        writer.endElement("div");
    }

    protected void encodeListInput(FacesContext context, String clientId) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("select", null);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.writeAttribute("name", (Object)clientId, null);
        writer.writeAttribute("multiple", (Object)"multiple", null);
        writer.writeAttribute("class", (Object)"ui-helper-hidden", null);
        writer.endElement("select");
    }

    protected void encodeOptions(FacesContext context, PickList pickList, List model) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String var = pickList.getVar();
        Converter converter = pickList.getConverter();
        boolean showCheckbox = pickList.isShowCheckbox();
        for (Object item : model) {
            context.getExternalContext().getRequestMap().put(var, item);
            String itemValue = converter != null ? converter.getAsString(context, (UIComponent)pickList, pickList.getItemValue()) : pickList.getItemValue().toString();
            String itemLabel = pickList.getItemLabel();
            String itemClass = pickList.isItemDisabled() ? "ui-picklist-item ui-corner-all ui-state-disabled" : "ui-picklist-item ui-corner-all";
            writer.startElement("li", null);
            writer.writeAttribute("class", (Object)itemClass, null);
            writer.writeAttribute("data-item-value", (Object)itemValue, null);
            writer.writeAttribute("data-item-label", (Object)itemLabel, null);
            writer.writeAttribute("role", (Object)"menuitem", null);
            if (pickList.getChildCount() > 0) {
                writer.startElement("table", null);
                writer.writeAttribute("role", (Object)"presentation", null);
                writer.startElement("tbody", null);
                writer.startElement("tr", null);
                if (showCheckbox) {
                    writer.startElement("td", null);
                    RendererUtils.encodeCheckbox(context, false);
                    writer.endElement("td");
                }
                for (UIComponent kid : pickList.getChildren()) {
                    if (!(kid instanceof Column) || !kid.isRendered()) continue;
                    Column column = (Column)kid;
                    writer.startElement("td", null);
                    if (column.getStyle() != null) {
                        writer.writeAttribute("style", (Object)column.getStyle(), null);
                    }
                    if (column.getStyleClass() != null) {
                        writer.writeAttribute("class", (Object)column.getStyleClass(), null);
                    }
                    this.renderChildren(context, (UIComponent)column);
                    writer.endElement("td");
                }
                writer.endElement("tr");
                writer.endElement("tbody");
                writer.endElement("table");
            } else {
                if (showCheckbox) {
                    RendererUtils.encodeCheckbox(context, false);
                }
                if (pickList.isEscape()) {
                    writer.writeText((Object)itemLabel, null);
                } else {
                    writer.write(itemLabel);
                }
            }
            writer.endElement("li");
        }
        context.getExternalContext().getRequestMap().remove(var);
    }

    @Override
    public Object getConvertedValue(FacesContext context, UIComponent component, Object submittedValue) throws ConverterException {
        try {
            PickList pickList = (PickList)component;
            String[][] value = (String[][])submittedValue;
            String[] sourceValue = value[0];
            String[] targetValue = value[1];
            DualListModel model = new DualListModel();
            pickList.populateModel(context, sourceValue, model.getSource());
            pickList.populateModel(context, targetValue, model.getTarget());
            return model;
        }
        catch (Exception exception) {
            throw new ConverterException((Throwable)exception);
        }
    }

    protected void encodeFilter(FacesContext context, PickList pickList, String name, boolean isSource) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String styleClass = "ui-picklist-filter ui-inputfield ui-inputtext ui-widget ui-state-default ui-corner-all" + (isSource ? " ui-source-filter-input" : " ui-target-filter-input");
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"ui-picklist-filter-container", null);
        writer.startElement("input", null);
        writer.writeAttribute("id", (Object)name, null);
        writer.writeAttribute("name", (Object)name, null);
        writer.writeAttribute("type", (Object)"text", null);
        writer.writeAttribute("class", (Object)styleClass, null);
        writer.endElement("input");
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)"ui-icon ui-icon-search", null);
        writer.endElement("span");
        writer.endElement("div");
    }

    protected void encodeAriaRegion(FacesContext context, String clientId) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("div", null);
        writer.writeAttribute("id", (Object)(clientId + "_ariaRegion"), null);
        writer.writeAttribute("class", (Object)"ui-helper-hidden-accessible", null);
        writer.writeAttribute("role", (Object)"region", null);
        writer.writeAttribute("aria-live", (Object)"polite", null);
        writer.writeAttribute("aria-atomic", (Object)"true", null);
        writer.endElement("div");
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }

    protected DualListModel getModelValueToRender(FacesContext context, PickList pickList) {
        Object submittedValue = pickList.getSubmittedValue();
        if (submittedValue != null) {
            return (DualListModel)this.getConvertedValue(context, (UIComponent)pickList, submittedValue);
        }
        return (DualListModel)pickList.getValue();
    }
}

