/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.resizable;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIGraphic;
import javax.faces.context.FacesContext;
import org.primefaces.component.resizable.Resizable;
import org.primefaces.expression.SearchExpressionFacade;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.WidgetBuilder;

public class ResizableRenderer
extends CoreRenderer {
    public void decode(FacesContext context, UIComponent component) {
        this.decodeBehaviors(context, component);
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        Resizable resizable = (Resizable)component;
        String clientId = resizable.getClientId(context);
        UIComponent target = SearchExpressionFacade.resolveComponent(context, (UIComponent)resizable, resizable.getFor(), 4);
        String targetId = target.getClientId(context);
        WidgetBuilder wb = this.getWidgetBuilder(context);
        if (target instanceof UIGraphic) {
            wb.initWithComponentLoad("Resizable", resizable.resolveWidgetVar(), clientId, targetId);
        } else {
            wb.init("Resizable", resizable.resolveWidgetVar(), clientId);
        }
        wb.attr("target", targetId).attr("minWidth", resizable.getMinWidth(), Integer.MIN_VALUE).attr("maxWidth", resizable.getMaxWidth(), Integer.MAX_VALUE).attr("minHeight", resizable.getMinHeight(), Integer.MIN_VALUE).attr("maxHeight", resizable.getMaxHeight(), Integer.MAX_VALUE);
        if (resizable.isAnimate()) {
            wb.attr("animate", true).attr("animateEasing", resizable.getEffect()).attr("animateDuration", resizable.getEffectDuration());
        }
        if (resizable.isProxy()) {
            wb.attr("helper", "ui-resizable-proxy");
        }
        wb.attr("handles", resizable.getHandles(), null).attr("grid", resizable.getGrid(), 1).attr("aspectRatio", resizable.isAspectRatio(), false).attr("ghost", resizable.isGhost(), false);
        if (resizable.isContainment()) {
            wb.attr("isContainment", true);
            wb.attr("parentComponentId", resizable.getParent().getClientId(context));
        }
        wb.callback("onStart", "function(event,ui)", resizable.getOnStart()).callback("onResize", "function(event,ui)", resizable.getOnResize()).callback("onStop", "function(event,ui)", resizable.getOnStop());
        this.encodeClientBehaviors(context, resizable);
        wb.finish();
    }
}

