/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.timeline;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import javax.faces.application.ResourceDependencies;
import javax.faces.application.ResourceDependency;
import javax.faces.component.ContextCallback;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.event.AjaxBehaviorEvent;
import javax.faces.event.BehaviorEvent;
import javax.faces.event.FacesEvent;
import org.primefaces.component.timeline.TimelineBase;
import org.primefaces.event.timeline.TimelineAddEvent;
import org.primefaces.event.timeline.TimelineDragDropEvent;
import org.primefaces.event.timeline.TimelineLazyLoadEvent;
import org.primefaces.event.timeline.TimelineModificationEvent;
import org.primefaces.event.timeline.TimelineRangeEvent;
import org.primefaces.event.timeline.TimelineSelectEvent;
import org.primefaces.model.timeline.TimelineEvent;
import org.primefaces.model.timeline.TimelineGroup;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.DateUtils;
import org.primefaces.util.MapBuilder;
import org.primefaces.visit.UIDataContextCallback;

@ResourceDependencies(value={@ResourceDependency(library="primefaces", name="components.css"), @ResourceDependency(library="primefaces", name="jquery/jquery.js"), @ResourceDependency(library="primefaces", name="jquery/jquery-plugins.js"), @ResourceDependency(library="primefaces", name="core.js"), @ResourceDependency(library="primefaces", name="components.js"), @ResourceDependency(library="primefaces", name="timeline/timeline.css"), @ResourceDependency(library="primefaces", name="timeline/timeline.js")})
public class Timeline
extends TimelineBase {
    public static final String COMPONENT_TYPE = "org.primefaces.component.Timeline";
    private static final Map<String, Class<? extends BehaviorEvent>> BEHAVIOR_EVENT_MAPPING = MapBuilder.builder().put("add", TimelineAddEvent.class).put("change", TimelineModificationEvent.class).put("changed", TimelineModificationEvent.class).put("edit", TimelineModificationEvent.class).put("delete", TimelineModificationEvent.class).put("select", TimelineSelectEvent.class).put("rangechange", TimelineRangeEvent.class).put("rangechanged", TimelineRangeEvent.class).put("lazyload", TimelineLazyLoadEvent.class).put("drop", TimelineDragDropEvent.class).build();
    private static final Collection<String> EVENT_NAMES = BEHAVIOR_EVENT_MAPPING.keySet();

    @Override
    public Map<String, Class<? extends BehaviorEvent>> getBehaviorEventMapping() {
        return BEHAVIOR_EVENT_MAPPING;
    }

    public Collection<String> getEventNames() {
        return EVENT_NAMES;
    }

    public void queueEvent(FacesEvent event) {
        FacesContext context = FacesContext.getCurrentInstance();
        if (this.isSelfRequest(context)) {
            Map params = context.getExternalContext().getRequestParameterMap();
            String eventName = (String)params.get("javax.faces.behavior.event");
            String clientId = this.getClientId(context);
            AjaxBehaviorEvent behaviorEvent = (AjaxBehaviorEvent)event;
            if ("add".equals(eventName)) {
                TimeZone targetTZ = ComponentUtils.resolveTimeZone(this.getTimeZone());
                TimeZone browserTZ = ComponentUtils.resolveTimeZone(this.getBrowserTimeZone());
                TimelineAddEvent te = new TimelineAddEvent((UIComponent)this, behaviorEvent.getBehavior(), DateUtils.toUtcDate(browserTZ, targetTZ, (String)params.get(clientId + "_startDate")), DateUtils.toUtcDate(browserTZ, targetTZ, (String)params.get(clientId + "_endDate")), this.getGroup((String)params.get(clientId + "_group")));
                te.setPhaseId(behaviorEvent.getPhaseId());
                super.queueEvent((FacesEvent)te);
                return;
            }
            if ("change".equals(eventName) || "changed".equals(eventName)) {
                TimelineEvent clonedEvent = null;
                TimelineEvent timelineEvent = this.getValue().getEvent((String)params.get(clientId + "_eventIdx"));
                if (timelineEvent != null) {
                    clonedEvent = new TimelineEvent();
                    clonedEvent.setData(timelineEvent.getData());
                    clonedEvent.setEditable(timelineEvent.isEditable());
                    clonedEvent.setStyleClass(timelineEvent.getStyleClass());
                    TimeZone targetTZ = ComponentUtils.resolveTimeZone(this.getTimeZone());
                    TimeZone browserTZ = ComponentUtils.resolveTimeZone(this.getBrowserTimeZone());
                    clonedEvent.setStartDate(DateUtils.toUtcDate(browserTZ, targetTZ, (String)params.get(clientId + "_startDate")));
                    clonedEvent.setEndDate(DateUtils.toUtcDate(browserTZ, targetTZ, (String)params.get(clientId + "_endDate")));
                    clonedEvent.setGroup(this.getGroup((String)params.get(clientId + "_group")));
                }
                TimelineModificationEvent te = new TimelineModificationEvent((UIComponent)this, behaviorEvent.getBehavior(), clonedEvent);
                te.setPhaseId(behaviorEvent.getPhaseId());
                super.queueEvent((FacesEvent)te);
                return;
            }
            if ("edit".equals(eventName) || "delete".equals(eventName)) {
                TimelineEvent clonedEvent = null;
                TimelineEvent timelineEvent = this.getValue().getEvent((String)params.get(clientId + "_eventIdx"));
                if (timelineEvent != null) {
                    clonedEvent = new TimelineEvent();
                    clonedEvent.setData(timelineEvent.getData());
                    clonedEvent.setStartDate((Date)timelineEvent.getStartDate().clone());
                    clonedEvent.setEndDate(timelineEvent.getEndDate() != null ? (Date)timelineEvent.getEndDate().clone() : null);
                    clonedEvent.setEditable(timelineEvent.isEditable());
                    clonedEvent.setGroup(timelineEvent.getGroup());
                    clonedEvent.setStyleClass(timelineEvent.getStyleClass());
                }
                TimelineModificationEvent te = new TimelineModificationEvent((UIComponent)this, behaviorEvent.getBehavior(), clonedEvent);
                te.setPhaseId(behaviorEvent.getPhaseId());
                super.queueEvent((FacesEvent)te);
                return;
            }
            if ("select".equals(eventName)) {
                TimelineEvent timelineEvent = this.getValue().getEvent((String)params.get(clientId + "_eventIdx"));
                TimelineSelectEvent te = new TimelineSelectEvent((UIComponent)this, behaviorEvent.getBehavior(), timelineEvent);
                te.setPhaseId(behaviorEvent.getPhaseId());
                super.queueEvent((FacesEvent)te);
                return;
            }
            if ("rangechange".equals(eventName) || "rangechanged".equals(eventName)) {
                TimeZone targetTZ = ComponentUtils.resolveTimeZone(this.getTimeZone());
                TimeZone browserTZ = ComponentUtils.resolveTimeZone(this.getBrowserTimeZone());
                TimelineRangeEvent te = new TimelineRangeEvent((UIComponent)this, behaviorEvent.getBehavior(), DateUtils.toUtcDate(browserTZ, targetTZ, (String)params.get(clientId + "_startDate")), DateUtils.toUtcDate(browserTZ, targetTZ, (String)params.get(clientId + "_endDate")));
                te.setPhaseId(behaviorEvent.getPhaseId());
                super.queueEvent((FacesEvent)te);
                return;
            }
            if ("lazyload".equals(eventName)) {
                TimeZone targetTZ = ComponentUtils.resolveTimeZone(this.getTimeZone());
                TimeZone browserTZ = ComponentUtils.resolveTimeZone(this.getBrowserTimeZone());
                TimelineLazyLoadEvent te = new TimelineLazyLoadEvent((UIComponent)this, behaviorEvent.getBehavior(), DateUtils.toUtcDate(browserTZ, targetTZ, (String)params.get(clientId + "_startDateFirst")), DateUtils.toUtcDate(browserTZ, targetTZ, (String)params.get(clientId + "_endDateFirst")), DateUtils.toUtcDate(browserTZ, targetTZ, (String)params.get(clientId + "_startDateSecond")), DateUtils.toUtcDate(browserTZ, targetTZ, (String)params.get(clientId + "_endDateSecond")));
                te.setPhaseId(behaviorEvent.getPhaseId());
                super.queueEvent((FacesEvent)te);
                return;
            }
            if ("drop".equals(eventName)) {
                Object data = null;
                String dragId = (String)params.get(clientId + "_dragId");
                String uiDataId = (String)params.get(clientId + "_uiDataId");
                if (dragId != null && uiDataId != null) {
                    UIDataContextCallback contextCallback = new UIDataContextCallback(dragId);
                    context.getViewRoot().invokeOnComponent(context, uiDataId, (ContextCallback)contextCallback);
                    data = contextCallback.getData();
                }
                TimeZone targetTZ = ComponentUtils.resolveTimeZone(this.getTimeZone());
                TimeZone browserTZ = ComponentUtils.resolveTimeZone(this.getBrowserTimeZone());
                TimelineDragDropEvent te = new TimelineDragDropEvent((UIComponent)this, behaviorEvent.getBehavior(), DateUtils.toUtcDate(browserTZ, targetTZ, (String)params.get(clientId + "_startDate")), DateUtils.toUtcDate(browserTZ, targetTZ, (String)params.get(clientId + "_endDate")), this.getGroup((String)params.get(clientId + "_group")), dragId, data);
                te.setPhaseId(behaviorEvent.getPhaseId());
                super.queueEvent((FacesEvent)te);
                return;
            }
        }
        super.queueEvent(event);
    }

    private String getGroup(String groupParam) {
        int idxGroupOrder;
        List<TimelineGroup> groups = this.getValue().getGroups();
        if (groups == null || groupParam == null) {
            return groupParam;
        }
        int idx = groupParam.indexOf("</span>");
        if (idx > -1 && (idxGroupOrder = (groupParam = groupParam.substring(0, idx)).indexOf("#")) > -1) {
            String groupOrder = groupParam.substring(idxGroupOrder + 1);
            return groups.get(Integer.valueOf(groupOrder)).getId();
        }
        return groupParam;
    }

    private boolean isSelfRequest(FacesContext context) {
        return this.getClientId(context).equals(context.getExternalContext().getRequestParameterMap().get("javax.faces.source"));
    }
}

