/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.treetable;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.el.ELContext;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.application.ResourceDependencies;
import javax.faces.application.ResourceDependency;
import javax.faces.component.UIComponent;
import javax.faces.component.UINamingContainer;
import javax.faces.context.FacesContext;
import javax.faces.event.AjaxBehaviorEvent;
import javax.faces.event.BehaviorEvent;
import javax.faces.event.FacesEvent;
import javax.faces.event.PhaseId;
import org.primefaces.component.api.DynamicColumn;
import org.primefaces.component.api.UIColumn;
import org.primefaces.component.column.Column;
import org.primefaces.component.columngroup.ColumnGroup;
import org.primefaces.component.columns.Columns;
import org.primefaces.component.treetable.TreeTableBase;
import org.primefaces.event.AbstractAjaxBehaviorEvent;
import org.primefaces.event.CellEditEvent;
import org.primefaces.event.ColumnResizeEvent;
import org.primefaces.event.NodeCollapseEvent;
import org.primefaces.event.NodeExpandEvent;
import org.primefaces.event.NodeSelectEvent;
import org.primefaces.event.NodeUnselectEvent;
import org.primefaces.event.RowEditEvent;
import org.primefaces.event.data.PageEvent;
import org.primefaces.event.data.SortEvent;
import org.primefaces.model.SortOrder;
import org.primefaces.model.TreeNode;
import org.primefaces.model.filter.ContainsFilterConstraint;
import org.primefaces.model.filter.EndsWithFilterConstraint;
import org.primefaces.model.filter.EqualsFilterConstraint;
import org.primefaces.model.filter.ExactFilterConstraint;
import org.primefaces.model.filter.FilterConstraint;
import org.primefaces.model.filter.GlobalFilterConstraint;
import org.primefaces.model.filter.GreaterThanEqualsFilterConstraint;
import org.primefaces.model.filter.GreaterThanFilterConstraint;
import org.primefaces.model.filter.InFilterConstraint;
import org.primefaces.model.filter.LessThanEqualsFilterConstraint;
import org.primefaces.model.filter.LessThanFilterConstraint;
import org.primefaces.model.filter.StartsWithFilterConstraint;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.LocaleUtils;
import org.primefaces.util.MapBuilder;

@ResourceDependencies(value={@ResourceDependency(library="primefaces", name="components.css"), @ResourceDependency(library="primefaces", name="jquery/jquery.js"), @ResourceDependency(library="primefaces", name="jquery/jquery-plugins.js"), @ResourceDependency(library="primefaces", name="core.js"), @ResourceDependency(library="primefaces", name="components.js")})
public class TreeTable
extends TreeTableBase {
    public static final String COMPONENT_TYPE = "org.primefaces.component.TreeTable";
    public static final String CONTAINER_CLASS = "ui-treetable ui-widget";
    public static final String RESIZABLE_CONTAINER_CLASS = "ui-treetable ui-treetable-resizable ui-widget";
    public static final String HEADER_CLASS = "ui-treetable-header ui-widget-header ui-corner-top";
    public static final String DATA_CLASS = "ui-treetable-data ui-widget-content";
    public static final String FOOTER_CLASS = "ui-treetable-footer ui-widget-header ui-corner-bottom";
    public static final String COLUMN_HEADER_CLASS = "ui-state-default";
    public static final String SORTABLE_COLUMN_HEADER_CLASS = "ui-state-default ui-sortable-column";
    public static final String ROW_CLASS = "ui-widget-content";
    public static final String SELECTED_ROW_CLASS = "ui-widget-content ui-state-highlight ui-selected";
    public static final String COLUMN_CONTENT_WRAPPER = "ui-tt-c";
    public static final String EXPAND_ICON = "ui-treetable-toggler ui-icon ui-icon-triangle-1-e ui-c";
    public static final String COLLAPSE_ICON = "ui-treetable-toggler ui-icon ui-icon-triangle-1-s ui-c";
    public static final String SCROLLABLE_CONTAINER_CLASS = "ui-treetable-scrollable";
    public static final String SCROLLABLE_HEADER_CLASS = "ui-widget-header ui-treetable-scrollable-header";
    public static final String SCROLLABLE_HEADER_BOX_CLASS = "ui-treetable-scrollable-header-box";
    public static final String SCROLLABLE_BODY_CLASS = "ui-treetable-scrollable-body";
    public static final String SCROLLABLE_FOOTER_CLASS = "ui-widget-header ui-treetable-scrollable-footer";
    public static final String SCROLLABLE_FOOTER_BOX_CLASS = "ui-treetable-scrollable-footer-box";
    public static final String SELECTABLE_NODE_CLASS = "ui-treetable-selectable-node";
    public static final String RESIZABLE_COLUMN_CLASS = "ui-resizable-column";
    public static final String INDENT_CLASS = "ui-treetable-indent";
    public static final String EMPTY_MESSAGE_ROW_CLASS = "ui-widget-content ui-treetable-empty-message";
    public static final String PARTIAL_SELECTED_CLASS = "ui-treetable-partialselected";
    public static final String SORTABLE_COLUMN_ICON_CLASS = "ui-sortable-column-icon ui-icon ui-icon-carat-2-n-s";
    public static final String SORTABLE_COLUMN_ASCENDING_ICON_CLASS = "ui-sortable-column-icon ui-icon ui-icon ui-icon-carat-2-n-s ui-icon-triangle-1-n";
    public static final String SORTABLE_COLUMN_DESCENDING_ICON_CLASS = "ui-sortable-column-icon ui-icon ui-icon ui-icon-carat-2-n-s ui-icon-triangle-1-s";
    public static final String REFLOW_CLASS = "ui-treetable-reflow";
    public static final String FILTER_COLUMN_CLASS = "ui-filter-column";
    public static final String COLUMN_INPUT_FILTER_CLASS = "ui-column-filter ui-inputfield ui-inputtext ui-widget ui-state-default ui-corner-all";
    public static final String COLUMN_CUSTOM_FILTER_CLASS = "ui-column-customfilter";
    public static final String HIDDEN_COLUMN_CLASS = "ui-helper-hidden";
    public static final String STATIC_COLUMN_CLASS = "ui-static-column";
    public static final String EDITABLE_COLUMN_CLASS = "ui-editable-column";
    public static final String EDITING_ROW_CLASS = "ui-row-editing";
    public static final String STARTS_WITH_MATCH_MODE = "startsWith";
    public static final String ENDS_WITH_MATCH_MODE = "endsWith";
    public static final String CONTAINS_MATCH_MODE = "contains";
    public static final String EXACT_MATCH_MODE = "exact";
    public static final String LESS_THAN_MODE = "lt";
    public static final String LESS_THAN_EQUALS_MODE = "lte";
    public static final String GREATER_THAN_MODE = "gt";
    public static final String GREATER_THAN_EQUALS_MODE = "gte";
    public static final String EQUALS_MODE = "equals";
    public static final String IN_MODE = "in";
    public static final String GLOBAL_MODE = "global";
    static final Map<String, FilterConstraint> FILTER_CONSTRAINTS = MapBuilder.builder().put("startsWith", new StartsWithFilterConstraint()).put("endsWith", (StartsWithFilterConstraint)((Object)new EndsWithFilterConstraint())).put("contains", (StartsWithFilterConstraint)((Object)new ContainsFilterConstraint())).put("exact", (StartsWithFilterConstraint)((Object)new ExactFilterConstraint())).put("lt", (StartsWithFilterConstraint)((Object)new LessThanFilterConstraint())).put("lte", (StartsWithFilterConstraint)((Object)new LessThanEqualsFilterConstraint())).put("gt", (StartsWithFilterConstraint)((Object)new GreaterThanFilterConstraint())).put("gte", (StartsWithFilterConstraint)((Object)new GreaterThanEqualsFilterConstraint())).put("equals", (StartsWithFilterConstraint)((Object)new EqualsFilterConstraint())).put("in", (StartsWithFilterConstraint)((Object)new InFilterConstraint())).put("global", (StartsWithFilterConstraint)((Object)new GlobalFilterConstraint())).build();
    private static final Map<String, Class<? extends BehaviorEvent>> BEHAVIOR_EVENT_MAPPING = MapBuilder.builder().put("select", NodeSelectEvent.class).put("unselect", NodeUnselectEvent.class).put("expand", NodeExpandEvent.class).put("collapse", NodeCollapseEvent.class).put("colResize", ColumnResizeEvent.class).put("sort", SortEvent.class).put("rowEdit", RowEditEvent.class).put("rowEditInit", RowEditEvent.class).put("rowEditCancel", RowEditEvent.class).put("cellEdit", CellEditEvent.class).put("cellEditInit", CellEditEvent.class).put("cellEditCancel", CellEditEvent.class).put("page", PageEvent.class).build();
    private static final Collection<String> EVENT_NAMES = BEHAVIOR_EVENT_MAPPING.keySet();
    private int columnsCount = -1;
    private UIColumn sortColumn;
    private List<UIColumn> columns;
    private Columns dynamicColumns;
    private List<String> filteredRowKeys = new ArrayList<String>();
    private List filterMetadata;

    @Override
    public Map<String, Class<? extends BehaviorEvent>> getBehaviorEventMapping() {
        return BEHAVIOR_EVENT_MAPPING;
    }

    public Collection<String> getEventNames() {
        return EVENT_NAMES;
    }

    public boolean isSelectionRequest(FacesContext context) {
        return context.getExternalContext().getRequestParameterMap().containsKey(this.getClientId(context) + "_instantSelection");
    }

    public boolean isSortRequest(FacesContext context) {
        return context.getExternalContext().getRequestParameterMap().containsKey(this.getClientId(context) + "_sorting");
    }

    public boolean isPaginationRequest(FacesContext context) {
        return context.getExternalContext().getRequestParameterMap().containsKey(this.getClientId(context) + "_pagination");
    }

    public boolean isRowEditRequest(FacesContext context) {
        return context.getExternalContext().getRequestParameterMap().containsKey(this.getClientId(context) + "_rowEditAction");
    }

    public boolean isCellEditRequest(FacesContext context) {
        return context.getExternalContext().getRequestParameterMap().containsKey(this.getClientId(context) + "_cellInfo");
    }

    public boolean isCellEditCancelRequest(FacesContext context) {
        return context.getExternalContext().getRequestParameterMap().containsKey(this.getClientId(context) + "_cellEditCancel");
    }

    public boolean isCellEditInitRequest(FacesContext context) {
        return context.getExternalContext().getRequestParameterMap().containsKey(this.getClientId(context) + "_cellEditInit");
    }

    public boolean isFilterRequest(FacesContext context) {
        return context.getExternalContext().getRequestParameterMap().containsKey(this.getClientId(context) + "_filtering");
    }

    @Override
    public void queueEvent(FacesEvent event) {
        FacesContext context = this.getFacesContext();
        if (ComponentUtils.isRequestSource((UIComponent)this, context) && event instanceof AjaxBehaviorEvent) {
            Map params = context.getExternalContext().getRequestParameterMap();
            String eventName = (String)params.get("javax.faces.behavior.event");
            String clientId = this.getClientId(context);
            AbstractAjaxBehaviorEvent wrapperEvent = null;
            AjaxBehaviorEvent behaviorEvent = (AjaxBehaviorEvent)event;
            if (eventName.equals("expand")) {
                String nodeKey = (String)params.get(clientId + "_expand");
                this.setRowKey(nodeKey);
                TreeNode node = this.getRowNode();
                wrapperEvent = new NodeExpandEvent((UIComponent)this, behaviorEvent.getBehavior(), node);
                wrapperEvent.setPhaseId(PhaseId.APPLY_REQUEST_VALUES);
            } else if (eventName.equals("collapse")) {
                String nodeKey = (String)params.get(clientId + "_collapse");
                this.setRowKey(nodeKey);
                TreeNode node = this.getRowNode();
                node.setExpanded(false);
                wrapperEvent = new NodeCollapseEvent((UIComponent)this, behaviorEvent.getBehavior(), node);
                wrapperEvent.setPhaseId(PhaseId.APPLY_REQUEST_VALUES);
            } else if (eventName.equals("select")) {
                String nodeKey = (String)params.get(clientId + "_instantSelection");
                this.setRowKey(nodeKey);
                TreeNode node = this.getRowNode();
                wrapperEvent = new NodeSelectEvent((UIComponent)this, behaviorEvent.getBehavior(), node);
                wrapperEvent.setPhaseId(behaviorEvent.getPhaseId());
            } else if (eventName.equals("unselect")) {
                String nodeKey = (String)params.get(clientId + "_instantUnselection");
                this.setRowKey(nodeKey);
                TreeNode node = this.getRowNode();
                wrapperEvent = new NodeUnselectEvent((UIComponent)this, behaviorEvent.getBehavior(), node);
                wrapperEvent.setPhaseId(behaviorEvent.getPhaseId());
            } else if (eventName.equals("colResize")) {
                String columnId = (String)params.get(clientId + "_columnId");
                int width = Integer.parseInt((String)params.get(clientId + "_width"));
                int height = Integer.parseInt((String)params.get(clientId + "_height"));
                wrapperEvent = new ColumnResizeEvent((UIComponent)this, behaviorEvent.getBehavior(), width, height, this.findColumn(columnId));
            } else if (eventName.equals("sort")) {
                SortOrder order = SortOrder.valueOf((String)params.get(clientId + "_sortDir"));
                UIColumn sortColumn = this.findColumn((String)params.get(clientId + "_sortKey"));
                wrapperEvent = new SortEvent((UIComponent)this, behaviorEvent.getBehavior(), sortColumn, order, 0);
            } else if (eventName.equals("rowEdit") || eventName.equals("rowEditCancel") || eventName.equals("rowEditInit")) {
                String nodeKey = (String)params.get(clientId + "_rowEditIndex");
                this.setRowKey(nodeKey);
                wrapperEvent = new RowEditEvent((UIComponent)this, behaviorEvent.getBehavior(), this.getRowNode());
                wrapperEvent.setPhaseId(behaviorEvent.getPhaseId());
            } else if (eventName.equals("cellEdit") || eventName.equals("cellEditCancel") || eventName.equals("cellEditInit")) {
                String[] cellInfo = ((String)params.get(clientId + "_cellInfo")).split(",");
                String rowKey = cellInfo[0];
                int cellIndex = Integer.parseInt(cellInfo[1]);
                int i = -1;
                UIColumn column = null;
                for (UIColumn col : this.getColumns()) {
                    if (!col.isRendered() || ++i != cellIndex) continue;
                    column = col;
                    break;
                }
                wrapperEvent = new CellEditEvent((UIComponent)this, behaviorEvent.getBehavior(), column, rowKey);
                wrapperEvent.setPhaseId(behaviorEvent.getPhaseId());
            } else if (eventName.equals("page")) {
                int rows = this.getRowsToRender();
                int first = Integer.parseInt((String)params.get(clientId + "_first"));
                int page = rows > 0 ? first / rows : 0;
                wrapperEvent = new PageEvent((UIComponent)this, behaviorEvent.getBehavior(), page);
                wrapperEvent.setPhaseId(behaviorEvent.getPhaseId());
            }
            super.queueEvent((FacesEvent)wrapperEvent);
        } else {
            super.queueEvent(event);
        }
    }

    @Override
    public void processDecodes(FacesContext context) {
        if (this.isToggleRequest(context)) {
            this.decode(context);
        } else {
            super.processDecodes(context);
        }
    }

    public UIColumn findColumn(String clientId) {
        for (UIColumn column : this.getColumns()) {
            if (!column.getColumnKey().equals(clientId)) continue;
            return column;
        }
        FacesContext context = this.getFacesContext();
        ColumnGroup headerGroup = this.getColumnGroup("header");
        for (UIComponent row : headerGroup.getChildren()) {
            for (UIComponent col : row.getChildren()) {
                if (!col.getClientId(context).equals(clientId)) continue;
                return (UIColumn)col;
            }
        }
        throw new FacesException("Cannot find column with key: " + clientId);
    }

    public boolean hasFooterColumn() {
        for (UIComponent child : this.getChildren()) {
            Column column;
            if (!(child instanceof Column) || !child.isRendered() || (column = (Column)child).getFacet("footer") == null && column.getFooterText() == null) continue;
            return true;
        }
        return false;
    }

    private boolean isToggleRequest(FacesContext context) {
        String clientId;
        Map params = context.getExternalContext().getRequestParameterMap();
        return params.get((clientId = this.getClientId(context)) + "_expand") != null || params.get(clientId + "_collapse") != null;
    }

    public boolean isResizeRequest(FacesContext context) {
        String clientId;
        Map params = context.getExternalContext().getRequestParameterMap();
        return params.get((clientId = this.getClientId(context)) + "_colResize") != null;
    }

    public int getColumnsCount() {
        if (this.columnsCount == -1) {
            this.columnsCount = 0;
            for (UIComponent kid : this.getChildren()) {
                if (!kid.isRendered() || !(kid instanceof Column)) continue;
                ++this.columnsCount;
            }
        }
        return this.columnsCount;
    }

    public String getScrollState() {
        String name;
        Map params = this.getFacesContext().getExternalContext().getRequestParameterMap();
        String value = (String)params.get(name = this.getClientId() + "_scrollState");
        return value == null ? "0,0" : value;
    }

    public boolean isCheckboxSelection() {
        String selectionMode = this.getSelectionMode();
        return selectionMode != null && selectionMode.equals("checkbox");
    }

    public UIColumn getSortColumn() {
        return this.sortColumn;
    }

    public void setSortColumn(UIColumn column) {
        this.sortColumn = column;
    }

    public void clearDefaultSorted() {
        this.getStateHelper().remove((Serializable)((Object)"defaultSorted"));
    }

    public void setDefaultSorted() {
        this.getStateHelper().put((Serializable)((Object)"defaultSorted"), (Object)"defaultSorted");
    }

    public boolean isDefaultSorted() {
        return this.getStateHelper().get((Serializable)((Object)"defaultSorted")) != null;
    }

    public Locale resolveDataLocale() {
        FacesContext context = this.getFacesContext();
        return LocaleUtils.resolveLocale(this.getDataLocale(), this.getClientId(context));
    }

    public ColumnGroup getColumnGroup(String target) {
        for (UIComponent child : this.getChildren()) {
            ColumnGroup colGroup;
            String type;
            if (!(child instanceof ColumnGroup) || (type = (colGroup = (ColumnGroup)child).getType()) == null || !type.equals(target)) continue;
            return colGroup;
        }
        return null;
    }

    public List<UIColumn> getColumns() {
        if (this.columns == null) {
            this.columns = new ArrayList<UIColumn>();
            FacesContext context = this.getFacesContext();
            char separator = UINamingContainer.getSeparatorChar((FacesContext)context);
            for (UIComponent child : this.getChildren()) {
                if (child instanceof Column) {
                    this.columns.add((UIColumn)child);
                    continue;
                }
                if (!(child instanceof Columns)) continue;
                Columns uiColumns = (Columns)child;
                String uiColumnsClientId = uiColumns.getClientId(context);
                for (int i = 0; i < uiColumns.getRowCount(); ++i) {
                    DynamicColumn dynaColumn = new DynamicColumn(i, uiColumns);
                    dynaColumn.setColumnKey(uiColumnsClientId + separator + i);
                    this.columns.add(dynaColumn);
                }
            }
        }
        return this.columns;
    }

    public void setColumns(List<UIColumn> columns) {
        this.columns = columns;
    }

    public Columns getDynamicColumns() {
        return this.dynamicColumns;
    }

    public void setDynamicColumns(Columns value) {
        this.dynamicColumns = value;
    }

    public Object saveState(FacesContext context) {
        if (this.dynamicColumns != null) {
            this.dynamicColumns.setRowIndex(-1);
        }
        return super.saveState(context);
    }

    @Override
    protected void validateSelection(FacesContext context) {
        String selectionMode = this.getSelectionMode();
        if (selectionMode != null && this.isRequired()) {
            boolean isValueBlank;
            Object selection = this.getLocalSelectedNodes();
            boolean bl = selectionMode.equalsIgnoreCase("single") ? selection == null : (isValueBlank = ((TreeNode[])selection).length == 0);
            if (isValueBlank) {
                super.updateSelection(context);
            }
        }
        super.validateSelection(context);
    }

    @Override
    public int getRowCount() {
        TreeNode root = this.getValue();
        if (root == null) {
            return -1;
        }
        List<TreeNode> children = root.getChildren();
        return children == null ? -1 : children.size();
    }

    @Override
    public int getPage() {
        if (this.getRowCount() > 0) {
            int rows = this.getRowsToRender();
            if (rows > 0) {
                int first = this.getFirst();
                return first / rows;
            }
            return 0;
        }
        return 0;
    }

    @Override
    public int getRowsToRender() {
        int rows = this.getRows();
        return rows == 0 ? this.getRowCount() : rows;
    }

    @Override
    public int getPageCount() {
        return (int)Math.ceil((double)this.getRowCount() * 1.0 / (double)this.getRowsToRender());
    }

    public UIComponent getHeader() {
        return this.getFacet("header");
    }

    public UIComponent getFooter() {
        return this.getFacet("footer");
    }

    public void calculateFirst() {
        int rows = this.getRows();
        if (rows > 0) {
            int first = this.getFirst();
            int rowCount = this.getRowCount();
            if (rowCount > 0 && first >= rowCount) {
                int numberOfPages = (int)Math.ceil((double)rowCount * 1.0 / (double)rows);
                this.setFirst(Math.max((numberOfPages - 1) * rows, 0));
            }
        }
    }

    public void updatePaginationData(FacesContext context) {
        String componentClientId = this.getClientId(context);
        Map params = context.getExternalContext().getRequestParameterMap();
        ELContext elContext = context.getELContext();
        String firstParam = (String)params.get(componentClientId + "_first");
        String rowsParam = (String)params.get(componentClientId + "_rows");
        this.setFirst(Integer.valueOf(firstParam));
        this.setRows(Integer.valueOf(rowsParam));
        ValueExpression firstVe = this.getValueExpression("first");
        ValueExpression rowsVe = this.getValueExpression("rows");
        if (firstVe != null && !firstVe.isReadOnly(elContext)) {
            firstVe.setValue(context.getELContext(), (Object)this.getFirst());
        }
        if (rowsVe != null && !rowsVe.isReadOnly(elContext)) {
            rowsVe.setValue(context.getELContext(), (Object)this.getRows());
        }
    }

    public boolean isFilteringEnabled() {
        Object value = this.getStateHelper().get((Serializable)((Object)"filtering"));
        return value != null;
    }

    public void enableFiltering() {
        this.getStateHelper().put((Serializable)((Object)"filtering"), (Object)true);
    }

    public void updateFilteredNode(FacesContext context, TreeNode node) {
        ValueExpression ve = this.getValueExpression("filteredNode");
        if (ve != null) {
            ve.setValue(context.getELContext(), (Object)node);
        } else {
            this.setFilteredNode(node);
        }
    }

    public List<String> getFilteredRowKeys() {
        return this.filteredRowKeys;
    }

    public void setFilteredRowKeys(List<String> filteredRowKeys) {
        this.filteredRowKeys = filteredRowKeys;
    }

    public List getFilterMetadata() {
        return this.filterMetadata;
    }

    public void setFilterMetadata(List filterMetadata) {
        this.filterMetadata = filterMetadata;
    }

    @Override
    protected void preDecode(FacesContext context) {
        this.resetDynamicColumns();
        super.preDecode(context);
    }

    @Override
    protected void preValidate(FacesContext context) {
        this.resetDynamicColumns();
        super.preValidate(context);
    }

    @Override
    protected void preUpdate(FacesContext context) {
        this.resetDynamicColumns();
        super.preUpdate(context);
    }

    @Override
    protected void preEncode(FacesContext context) {
        this.resetDynamicColumns();
        super.preEncode(context);
    }

    private void resetDynamicColumns() {
        Columns dynamicCols = this.getDynamicColumns();
        if (dynamicCols != null && this.isNestedWithinIterator().booleanValue()) {
            dynamicCols.setRowIndex(-1);
            this.setColumns(null);
        }
    }

    public void updateColumnsVisibility(FacesContext context) {
        Map params = context.getExternalContext().getRequestParameterMap();
        String columnTogglerParam = (String)params.get(this.getClientId(context) + "_columnTogglerState");
        if (columnTogglerParam != null) {
            String[] togglableColumns;
            for (String togglableColumn : togglableColumns = columnTogglerParam.split(",")) {
                int sepIndex = togglableColumn.lastIndexOf("_");
                UIColumn column = this.findColumn(togglableColumn.substring(0, sepIndex));
                if (column == null) continue;
                ((Column)column).setVisible(Boolean.valueOf(togglableColumn.substring(sepIndex + 1)));
            }
        }
    }
}

