/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.event;

import java.util.ArrayList;
import javax.faces.component.UIComponent;
import javax.faces.component.UIPanel;
import javax.faces.component.ValueHolder;
import javax.faces.component.behavior.Behavior;
import org.primefaces.component.api.Pageable;
import org.primefaces.component.api.UIColumn;
import org.primefaces.component.api.UIData;
import org.primefaces.component.api.UITree;
import org.primefaces.component.celleditor.CellEditor;
import org.primefaces.component.datatable.DataTable;
import org.primefaces.component.treetable.TreeTable;
import org.primefaces.event.AbstractAjaxBehaviorEvent;

public class CellEditEvent
extends AbstractAjaxBehaviorEvent {
    private static final long serialVersionUID = 1L;
    private Object oldValue;
    private Object newValue;
    private int rowIndex;
    private UIColumn column;
    private String rowKey;

    public CellEditEvent(UIComponent component, Behavior behavior, int rowIndex, UIColumn column) {
        super(component, behavior);
        this.rowIndex = rowIndex;
        this.column = column;
        this.oldValue = this.resolveValue();
    }

    public CellEditEvent(UIComponent component, Behavior behavior, int rowIndex, UIColumn column, String rowKey) {
        this(component, behavior, rowIndex, column);
        this.rowKey = rowKey;
    }

    public CellEditEvent(UIComponent component, Behavior behavior, UIColumn column, String rowKey) {
        super(component, behavior);
        this.rowKey = rowKey;
        this.column = column;
        this.oldValue = this.resolveValue();
    }

    public Object getOldValue() {
        return this.oldValue;
    }

    public Object getNewValue() {
        if (this.newValue == null) {
            this.newValue = this.resolveValue();
        }
        return this.newValue;
    }

    public int getRowIndex() {
        return this.rowIndex;
    }

    public UIColumn getColumn() {
        return this.column;
    }

    public String getRowKey() {
        return this.rowKey;
    }

    private Object resolveValue() {
        Pageable data;
        if (this.source instanceof UIData) {
            data = (DataTable)this.source;
            ((UIData)((Object)data)).setRowModel(this.rowIndex);
        } else if (this.source instanceof UITree) {
            data = (TreeTable)this.source;
            ((UITree)((Object)data)).setRowKey(this.rowKey);
        }
        ArrayList<Object> value = null;
        for (UIComponent child : this.column.getChildren()) {
            if (!(child instanceof CellEditor)) continue;
            UIComponent inputFacet = child.getFacet("input");
            if (inputFacet instanceof UIPanel) {
                ArrayList<Object> values = new ArrayList<Object>();
                for (UIComponent kid : inputFacet.getChildren()) {
                    if (!(kid instanceof ValueHolder)) continue;
                    values.add(((ValueHolder)kid).getValue());
                }
                value = values;
                continue;
            }
            value = ((ValueHolder)inputFacet).getValue();
        }
        return value;
    }
}

