/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.model;

import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.model.DataModel;
import javax.faces.model.DataModelEvent;
import javax.faces.model.DataModelListener;
import org.primefaces.model.LazyDataModelIterator;
import org.primefaces.model.SelectableDataModel;
import org.primefaces.model.SortMeta;
import org.primefaces.model.SortOrder;

public abstract class LazyDataModel<T>
extends DataModel<T>
implements SelectableDataModel<T>,
Serializable {
    private static final long serialVersionUID = 1L;
    private int rowIndex = -1;
    private int rowCount;
    private int pageSize;
    private List<T> data;

    public boolean isRowAvailable() {
        if (this.data == null) {
            return false;
        }
        return this.rowIndex >= 0 && this.rowIndex < this.data.size();
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public T getRowData() {
        return this.data.get(this.rowIndex);
    }

    public int getRowIndex() {
        return this.rowIndex;
    }

    public void setRowIndex(int rowIndex) {
        int oldIndex = this.rowIndex;
        this.rowIndex = rowIndex == -1 || this.pageSize == 0 ? -1 : rowIndex % this.pageSize;
        if (this.data == null) {
            return;
        }
        DataModelListener[] listeners = this.getDataModelListeners();
        if (listeners != null && oldIndex != this.rowIndex) {
            Object rowData = null;
            if (this.isRowAvailable()) {
                rowData = this.getRowData();
            }
            DataModelEvent dataModelEvent = new DataModelEvent((DataModel)this, rowIndex, rowData);
            for (int i = 0; i < listeners.length; ++i) {
                listeners[i].rowSelected(dataModelEvent);
            }
        }
    }

    public List<T> getWrappedData() {
        return this.data;
    }

    public void setWrappedData(Object list) {
        this.data = (List)list;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public void setRowCount(int rowCount) {
        this.rowCount = rowCount;
    }

    public List<T> load(int first, int pageSize, String sortField, SortOrder sortOrder, Map<String, Object> filters) {
        throw new UnsupportedOperationException("Lazy loading is not implemented.");
    }

    public List<T> load(int first, int pageSize, List<SortMeta> multiSortMeta, Map<String, Object> filters) {
        throw new UnsupportedOperationException("Lazy loading is not implemented.");
    }

    @Override
    public T getRowData(String rowKey) {
        throw new UnsupportedOperationException(this.getMessage("getRowData(String rowKey) must be implemented by %s when basic rowKey algorithm is not used [component=%s,view=%s]."));
    }

    @Override
    public Object getRowKey(T object) {
        throw new UnsupportedOperationException(this.getMessage("getRowKey(T object) must be implemented by %s when basic rowKey algorithm is not used [component=%s,view=%s]."));
    }

    private String getMessage(String format) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        String viewId = facesContext.getViewRoot().getViewId();
        UIComponent component = UIComponent.getCurrentComponent((FacesContext)facesContext);
        String clientId = component == null ? "<unknown>" : component.getClientId(facesContext);
        return String.format(format, this.getClass().getName(), clientId, viewId);
    }

    public Iterator<T> iterator() {
        return new LazyDataModelIterator(this);
    }

    public Iterator<T> iterator(String sortField, SortOrder sortOrder, Map<String, Object> filters) {
        return new LazyDataModelIterator(this, sortField, sortOrder, filters);
    }

    public Iterator<T> iterator(List<SortMeta> multiSortMeta, Map<String, Object> filters) {
        return new LazyDataModelIterator(this, multiSortMeta, filters);
    }
}

