/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.model.map;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.primefaces.model.map.Circle;
import org.primefaces.model.map.MapModel;
import org.primefaces.model.map.Marker;
import org.primefaces.model.map.Overlay;
import org.primefaces.model.map.Polygon;
import org.primefaces.model.map.Polyline;
import org.primefaces.model.map.Rectangle;

public class DefaultMapModel
implements MapModel,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String MARKER_ID_PREFIX = "marker";
    private static final String POLYLINE_ID_PREFIX = "polyline_";
    private static final String POLYGON_ID_PREFIX = "polygon_";
    private static final String CIRCLE_ID_PREFIX = "circle_";
    private static final String RECTANGLE_ID_PREFIX = "rectangle_";
    private List<Marker> markers = new ArrayList<Marker>();
    private List<Polyline> polylines = new ArrayList<Polyline>();
    private List<Polygon> polygons = new ArrayList<Polygon>();
    private List<Circle> circles = new ArrayList<Circle>();
    private List<Rectangle> rectangles = new ArrayList<Rectangle>();

    @Override
    public List<Marker> getMarkers() {
        return this.markers;
    }

    @Override
    public List<Polyline> getPolylines() {
        return this.polylines;
    }

    @Override
    public List<Polygon> getPolygons() {
        return this.polygons;
    }

    @Override
    public List<Circle> getCircles() {
        return this.circles;
    }

    @Override
    public List<Rectangle> getRectangles() {
        return this.rectangles;
    }

    @Override
    public void addOverlay(Overlay overlay) {
        if (overlay instanceof Marker) {
            overlay.setId(MARKER_ID_PREFIX + UUID.randomUUID().toString());
            this.markers.add((Marker)overlay);
        } else if (overlay instanceof Polyline) {
            overlay.setId(POLYLINE_ID_PREFIX + UUID.randomUUID().toString());
            this.polylines.add((Polyline)overlay);
        } else if (overlay instanceof Polygon) {
            overlay.setId(POLYGON_ID_PREFIX + UUID.randomUUID().toString());
            this.polygons.add((Polygon)overlay);
        } else if (overlay instanceof Circle) {
            overlay.setId(CIRCLE_ID_PREFIX + UUID.randomUUID().toString());
            this.circles.add((Circle)overlay);
        } else if (overlay instanceof Rectangle) {
            overlay.setId(RECTANGLE_ID_PREFIX + UUID.randomUUID().toString());
            this.rectangles.add((Rectangle)overlay);
        }
    }

    @Override
    public Overlay findOverlay(String id) {
        List<Overlay> list = null;
        if (id.startsWith(MARKER_ID_PREFIX)) {
            list = this.markers;
        } else if (id.startsWith(POLYLINE_ID_PREFIX)) {
            list = this.polylines;
        } else if (id.startsWith(POLYGON_ID_PREFIX)) {
            list = this.polygons;
        } else if (id.startsWith(CIRCLE_ID_PREFIX)) {
            list = this.circles;
        } else if (id.startsWith(RECTANGLE_ID_PREFIX)) {
            list = this.rectangles;
        }
        for (Overlay overlay : list) {
            if (!overlay.getId().equals(id)) continue;
            return overlay;
        }
        return null;
    }
}

