/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.util;

import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import org.primefaces.component.api.UICalendar;
import org.primefaces.convert.DatePatternConverter;
import org.primefaces.convert.PatternConverter;
import org.primefaces.convert.TimePatternConverter;
import org.primefaces.util.EscapeUtils;

public class CalendarUtils {
    private static final PatternConverter[] PATTERN_CONVERTERS = new PatternConverter[]{new TimePatternConverter(), new DatePatternConverter()};

    private CalendarUtils() {
    }

    public static final String getValueAsString(FacesContext context, UICalendar calendar) {
        Object submittedValue = calendar.getSubmittedValue();
        if (submittedValue != null) {
            return submittedValue.toString();
        }
        return CalendarUtils.getValueAsString(context, calendar, calendar.getValue());
    }

    public static Date getObjectAsDate(FacesContext context, UICalendar calendar, Object value) {
        Object obj;
        Converter converter;
        Locale locale;
        if (value == null) {
            return null;
        }
        if (value instanceof Date) {
            return (Date)value;
        }
        String pattern = calendar.calculatePattern();
        if (pattern != null && (locale = calendar.calculateLocale(context)) != null) {
            SimpleDateFormat dateFormat = new SimpleDateFormat(pattern, locale);
            try {
                return dateFormat.parse(value.toString());
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        if (calendar.getConverter() != null) {
            try {
                Object obj2 = calendar.getConverter().getAsObject(context, (UIComponent)calendar, value.toString());
                if (obj2 instanceof Date) {
                    return (Date)obj2;
                }
            }
            catch (ConverterException obj2) {
                // empty catch block
            }
        }
        if ((converter = context.getApplication().createConverter(value.getClass())) != null && (obj = converter.getAsObject(context, (UIComponent)calendar, value.toString())) instanceof Date) {
            return (Date)obj;
        }
        return null;
    }

    public static final String getValueAsString(FacesContext context, UICalendar calendar, Object value) {
        if (value == null) {
            return null;
        }
        return CalendarUtils.getValueAsString(context, calendar, value, calendar.calculatePattern());
    }

    public static final String getTimeOnlyValueAsString(FacesContext context, UICalendar calendar) {
        Object value = calendar.getValue();
        if (value == null) {
            return null;
        }
        return CalendarUtils.getValueAsString(context, calendar, value, calendar.calculateTimeOnlyPattern());
    }

    public static final String getValueAsString(FacesContext context, UICalendar calendar, Object value, String pattern) {
        if (value instanceof List) {
            String valuesAsString = "";
            String separator = "multiple".equals(calendar.getSelectionMode()) ? "," : " - ";
            List values = (List)value;
            for (int i = 0; i < values.size(); ++i) {
                if (i != 0) {
                    valuesAsString = valuesAsString + separator;
                }
                valuesAsString = valuesAsString + CalendarUtils.getValue(context, calendar, values.get(i), pattern);
            }
            return valuesAsString;
        }
        return CalendarUtils.getValue(context, calendar, value, pattern);
    }

    public static final String getValue(FacesContext context, UICalendar calendar, Object value, String pattern) {
        Converter converter;
        Class type;
        if (calendar.getConverter() != null) {
            return calendar.getConverter().getAsString(context, (UIComponent)calendar, value);
        }
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof Date) {
            SimpleDateFormat format = new SimpleDateFormat(pattern, calendar.calculateLocale(context));
            format.setTimeZone(CalendarUtils.calculateTimeZone(calendar.getTimeZone()));
            return format.format((Date)value);
        }
        ValueExpression ve = calendar.getValueExpression("value");
        if (ve != null && (type = ve.getType(context.getELContext())) != null && type != Object.class && type != Date.class && (converter = context.getApplication().createConverter(type)) != null) {
            return converter.getAsString(context, (UIComponent)calendar, value);
        }
        throw new FacesException("Value could be either String or java.util.Date");
    }

    public static final String convertPattern(String pattern) {
        if (pattern == null) {
            return null;
        }
        String convertedPattern = pattern;
        for (PatternConverter converter : PATTERN_CONVERTERS) {
            convertedPattern = converter.convert(convertedPattern);
        }
        return convertedPattern;
    }

    public static void encodeListValue(FacesContext context, UICalendar uicalendar, String optionName, List<Object> values) throws IOException {
        if (values == null) {
            return;
        }
        ResponseWriter writer = context.getResponseWriter();
        writer.write("," + optionName + ":[");
        for (int i = 0; i < values.size(); ++i) {
            String preText;
            Object item = values.get(i);
            String string = preText = i == 0 ? "" : ",";
            if (item instanceof Date) {
                writer.write(preText + "\"" + EscapeUtils.forJavaScript(CalendarUtils.getValueAsString(context, uicalendar, item)) + "\"");
                continue;
            }
            writer.write(preText + "" + item);
        }
        writer.write("]");
    }

    public static TimeZone calculateTimeZone(Object usertimeZone) {
        return CalendarUtils.calculateTimeZone(usertimeZone, TimeZone.getDefault());
    }

    public static TimeZone calculateTimeZone(Object usertimeZone, TimeZone defaultTimeZone) {
        if (usertimeZone != null) {
            if (usertimeZone instanceof String) {
                return TimeZone.getTimeZone((String)usertimeZone);
            }
            if (usertimeZone instanceof TimeZone) {
                return (TimeZone)usertimeZone;
            }
            throw new IllegalArgumentException("TimeZone could be either String or java.util.TimeZone");
        }
        return defaultTimeZone;
    }
}

