/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.soap.server.endpoint;

import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.springframework.util.CollectionUtils;
import org.springframework.ws.soap.server.endpoint.AbstractSoapFaultDefinitionExceptionResolver;
import org.springframework.ws.soap.server.endpoint.SoapFaultDefinition;
import org.springframework.ws.soap.server.endpoint.SoapFaultDefinitionEditor;

public class SoapFaultMappingExceptionResolver
extends AbstractSoapFaultDefinitionExceptionResolver {
    private Properties exceptionMappings;

    public void setExceptionMappings(Properties mappings) {
        this.exceptionMappings = mappings;
    }

    protected SoapFaultDefinition getFaultDefinition(Object endpoint, Exception ex) {
        if (!CollectionUtils.isEmpty((Map)this.exceptionMappings)) {
            String definitionText = null;
            int deepest = Integer.MAX_VALUE;
            Iterator<Object> iterator = this.exceptionMappings.keySet().iterator();
            while (iterator.hasNext()) {
                String exceptionMapping = (String)iterator.next();
                int depth = this.getDepth(exceptionMapping, ex);
                if (depth < 0 || depth >= deepest) continue;
                deepest = depth;
                definitionText = this.exceptionMappings.getProperty(exceptionMapping);
            }
            if (definitionText != null) {
                SoapFaultDefinitionEditor editor = new SoapFaultDefinitionEditor();
                editor.setAsText(definitionText);
                return (SoapFaultDefinition)editor.getValue();
            }
        }
        return null;
    }

    protected int getDepth(String exceptionMapping, Exception ex) {
        return this.getDepth(exceptionMapping, ex.getClass(), 0);
    }

    private int getDepth(String exceptionMapping, Class exceptionClass, int depth) {
        if (exceptionClass.getName().indexOf(exceptionMapping) != -1) {
            return depth;
        }
        if (exceptionClass.equals(Throwable.class)) {
            return -1;
        }
        return this.getDepth(exceptionMapping, exceptionClass.getSuperclass(), depth + 1);
    }
}

