package mx.com.amx.mx.dda.ws.dto;

import java.io.Serializable;

import javax.xml.bind.annotation.XmlElement;

/**
 * Representa en el ambito de DDA la respuesta obtenida por SAP respecto del Envio de Mercancia a SAP
 * Los nombres estan tomados del Excel de inventario de Interfaces. 
 */
public class RespSAPEnvMercDTO implements Serializable 
{
	private static final long serialVersionUID = 1L;
	private String DocMaterial;
	private String EjercDoc;
	private String Mensaje;
	
	public String getDocMaterial() {
		return DocMaterial;
	}

	public void setDocMaterial(String docMaterial) {
		DocMaterial = docMaterial;
	}

	public String getEjercDoc() {
		return EjercDoc;
	}

	public void setEjercDoc(String ejercDoc) {
		EjercDoc = ejercDoc;
	}

	public String getMensaje() {
		return Mensaje;
	}

	public void setMensaje(String mensaje) {
		Mensaje = mensaje;
	}

	public String toString() 
	{
		StringBuilder result = new StringBuilder();
		String NEW_LINE = System.getProperty("line.separator");
		result.append(" [Begin of Class] " + NEW_LINE);
		result.append(this.getClass().getSimpleName() + " Object {" + NEW_LINE);
		result.append(" DocMaterial: _" + this.getDocMaterial() + "_" + NEW_LINE);
		result.append(" EjercDoc: _" + this.getEjercDoc() + "_" + NEW_LINE);
		result.append(" Mensaje: _" + this.getMensaje() + "_" + NEW_LINE);
		result.append(" [End of Class] " + NEW_LINE);
		result.append("}");
		NEW_LINE = null;

		return result.toString();
	}
}
