package mx.com.amx.mx.dda.ws.utils;


import java.math.BigDecimal;

import org.apache.log4j.Logger;


public class ArithmeticManager 
{
	private final Logger LOG = Logger.getLogger(this.getClass().getSimpleName());
	
	public ArithmeticManager()
	{
		super();
	}
	

	public int comparaCantidades(String pstCantidadAComparar, String pstCantidadReferencia) throws Exception 
	{
		LOG.debug("    - [" + this.getClass().getSimpleName() + "::comparaCantidades]");
		LOG.debug("    - Parametros: ");
		LOG.debug("           Cantidad a Comparar: " + pstCantidadAComparar);
		LOG.debug("           Cantidad a referencia: " + pstCantidadReferencia);

		int resultado = 0;

		String lstCantidadComparar = (pstCantidadAComparar != null && pstCantidadAComparar.trim().length() > 0) ? pstCantidadAComparar : "0.0";
		String lstCantidadReferencia = (pstCantidadReferencia != null && pstCantidadReferencia.trim().length() > 0) ? pstCantidadReferencia : "0.0";

		try 
		{
			BigDecimal lnuCantidadComparar = new BigDecimal(lstCantidadComparar);
			BigDecimal lnuCantidadReferencia = new BigDecimal(lstCantidadReferencia);

			resultado = lnuCantidadComparar.compareTo(lnuCantidadReferencia);
		} 
		catch (NumberFormatException nf) 
		{
			LOG.info("Ocurrio un error al parsear las cantidades CantidadAComparar[" + lstCantidadComparar+ "] y CantidadReferencia[" + lstCantidadReferencia + "]");
			LOG.error("Exception[" + this.getClass().getSimpleName() + "::comparaCantidades]: " + nf.getMessage());
			throw new Exception(nf.getMessage());
		} 
		catch (Exception e) 
		{
			LOG.error("Exception[" + this.getClass().getSimpleName() + "::comparaCantidades]: " + e.getMessage());
			throw new Exception(e.getMessage());
		}

		return resultado;
	}
	
	public String obtenerDiferencia(String pstCantidadTotal, String pstCantidadRestar, String pstResultadoDefault) throws Exception 
	{
		LOG.debug("    - [" + this.getClass().getSimpleName() + "::obtenerDiferencia]");
		LOG.debug("    - Parametros: ");
		LOG.debug("           CantidadTotal: " + pstCantidadTotal);
		LOG.debug("           CantidadRestar: " + pstCantidadRestar);
		LOG.debug("           ResultadoDefault: " + pstResultadoDefault);

		String resultado = "-1";
		BigDecimal bdResultado = new BigDecimal("0.0");
		String lstCantidadTotal = (pstCantidadTotal != null && pstCantidadTotal.trim().length() > 0) ? pstCantidadTotal : "0.0";
		String lstCantidadRestar = (pstCantidadRestar != null && pstCantidadRestar.trim().length() > 0) ? pstCantidadRestar : "0.0";
		String lstResDefault = (pstResultadoDefault != null && pstResultadoDefault.trim().length() > 0) ? pstResultadoDefault : "";

		if(!lstResDefault.equals(""))
		{
			resultado = lstResDefault;
		}
		
		try 
		{
			BigDecimal lnuCantidadTotal = new BigDecimal(lstCantidadTotal);
			BigDecimal lnuCantidadRestar = new BigDecimal(lstCantidadRestar);

			bdResultado = lnuCantidadTotal.subtract(lnuCantidadRestar);
			bdResultado = bdResultado.setScale(4, BigDecimal.ROUND_HALF_UP);
			resultado = bdResultado.toString();
		} 
		catch (NumberFormatException nf) 
		{
			LOG.info("Ocurrio un error al parsear las cantidades CantidadTotal[" + lstCantidadTotal + "] y CantidadRestar["+ lstCantidadRestar + "]");
			LOG.error("Exception[" + this.getClass().getSimpleName() + "::obtenerDiferencia]: "+ nf.getMessage());
			throw new Exception(nf.getMessage());
		} 
		catch (Exception e) 
		{
			LOG.error("Exception[" + this.getClass().getSimpleName() + "::obtenerDiferencia]: "+ e.getMessage());
			throw new Exception(e.getMessage());
		}
		return resultado;
	}
	
	
}
