/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.server.endpoint.mapping;

import org.springframework.context.support.ApplicationObjectSupport;
import org.springframework.core.Ordered;
import org.springframework.ws.context.MessageContext;
import org.springframework.ws.server.EndpointInterceptor;
import org.springframework.ws.server.EndpointInvocationChain;
import org.springframework.ws.server.EndpointMapping;

public abstract class AbstractEndpointMapping
extends ApplicationObjectSupport
implements EndpointMapping,
Ordered {
    private int order = Integer.MAX_VALUE;
    private Object defaultEndpoint;
    private EndpointInterceptor[] interceptors;

    public EndpointInterceptor[] getInterceptors() {
        return this.interceptors;
    }

    public final void setInterceptors(EndpointInterceptor[] interceptors) {
        this.interceptors = interceptors;
    }

    public final int getOrder() {
        return this.order;
    }

    public final void setOrder(int order) {
        this.order = order;
    }

    public final EndpointInvocationChain getEndpoint(MessageContext messageContext) throws Exception {
        String endpointName;
        Object endpoint = this.getEndpointInternal(messageContext);
        if (endpoint == null) {
            endpoint = this.defaultEndpoint;
        }
        if (endpoint == null) {
            return null;
        }
        if (endpoint instanceof String && (endpoint = this.resolveStringEndpoint(endpointName = (String)endpoint)) == null) {
            return null;
        }
        return this.createEndpointInvocationChain(messageContext, endpoint, this.interceptors);
    }

    protected EndpointInvocationChain createEndpointInvocationChain(MessageContext messageContext, Object endpoint, EndpointInterceptor[] interceptors) {
        return new EndpointInvocationChain(endpoint, interceptors);
    }

    protected final Object getDefaultEndpoint() {
        return this.defaultEndpoint;
    }

    public final void setDefaultEndpoint(Object defaultEndpoint) {
        this.defaultEndpoint = defaultEndpoint;
    }

    protected Object resolveStringEndpoint(String endpointName) {
        if (this.getApplicationContext().containsBean(endpointName)) {
            return this.getApplicationContext().getBean(endpointName);
        }
        return null;
    }

    protected abstract Object getEndpointInternal(MessageContext var1) throws Exception;
}

