/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.transport;

import java.io.IOException;
import org.springframework.ws.WebServiceMessage;
import org.springframework.ws.WebServiceMessageFactory;
import org.springframework.ws.transport.TransportInputStream;
import org.springframework.ws.transport.TransportOutputStream;
import org.springframework.ws.transport.WebServiceConnection;

public abstract class AbstractWebServiceConnection
implements WebServiceConnection {
    private TransportInputStream tis;
    private TransportOutputStream tos;

    public final void send(WebServiceMessage message) throws IOException {
        this.onSendBeforeWrite(message);
        this.tos = this.createTransportOutputStream();
        if (this.tos == null) {
            return;
        }
        message.writeTo(this.tos);
        this.tos.flush();
        this.onSendAfterWrite(message);
    }

    protected void onSendBeforeWrite(WebServiceMessage message) throws IOException {
    }

    protected abstract TransportOutputStream createTransportOutputStream() throws IOException;

    protected void onSendAfterWrite(WebServiceMessage message) throws IOException {
    }

    public final WebServiceMessage receive(WebServiceMessageFactory messageFactory) throws IOException {
        this.onReceiveBeforeRead();
        this.tis = this.createTransportInputStream();
        if (this.tis == null) {
            return null;
        }
        WebServiceMessage message = messageFactory.createWebServiceMessage(this.tis);
        this.onReceiveAfterRead(message);
        return message;
    }

    protected void onReceiveBeforeRead() throws IOException {
    }

    protected abstract TransportInputStream createTransportInputStream() throws IOException;

    protected void onReceiveAfterRead(WebServiceMessage message) throws IOException {
    }

    public final void close() throws IOException {
        IOException ioex = null;
        if (this.tis != null) {
            try {
                this.tis.close();
            }
            catch (IOException ex) {
                ioex = ex;
            }
        }
        if (this.tos != null) {
            try {
                this.tos.close();
            }
            catch (IOException ex) {
                ioex = ex;
            }
        }
        this.onClose();
        if (ioex != null) {
            throw ioex;
        }
    }

    protected void onClose() throws IOException {
    }
}

