/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.rowset;

import java.io.Serializable;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import javax.sql.RowSetMetaData;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.OracleConnection;

public class OracleRowSetMetaData
implements RowSetMetaData,
Serializable {
    private int columnCount;
    private int[] nullable;
    private int[] columnDisplaySize;
    private int[] precision;
    private int[] scale;
    private int[] columnType;
    private boolean[] searchable;
    private boolean[] caseSensitive;
    private boolean[] readOnly;
    private boolean[] writable;
    private boolean[] definatelyWritable;
    private boolean[] currency;
    private boolean[] autoIncrement;
    private boolean[] signed;
    private String[] columnLabel;
    private String[] schemaName;
    private String[] columnName;
    private String[] tableName;
    private String[] columnTypeName;
    private String[] catalogName;
    private String[] columnClassName;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Thu_Apr_04_15:09:24_PDT_2013";
    public static final boolean TRACE = false;

    OracleRowSetMetaData(int n2) throws SQLException {
        this.columnCount = n2;
        this.searchable = new boolean[this.columnCount];
        this.caseSensitive = new boolean[this.columnCount];
        this.readOnly = new boolean[this.columnCount];
        this.nullable = new int[this.columnCount];
        this.signed = new boolean[this.columnCount];
        this.columnDisplaySize = new int[this.columnCount];
        this.columnType = new int[this.columnCount];
        this.columnLabel = new String[this.columnCount];
        this.columnName = new String[this.columnCount];
        this.schemaName = new String[this.columnCount];
        this.precision = new int[this.columnCount];
        this.scale = new int[this.columnCount];
        this.tableName = new String[this.columnCount];
        this.columnTypeName = new String[this.columnCount];
        this.writable = new boolean[this.columnCount];
        this.definatelyWritable = new boolean[this.columnCount];
        this.currency = new boolean[this.columnCount];
        this.autoIncrement = new boolean[this.columnCount];
        this.catalogName = new String[this.columnCount];
        this.columnClassName = new String[this.columnCount];
        for (int i2 = 0; i2 < this.columnCount; ++i2) {
            this.searchable[i2] = false;
            this.caseSensitive[i2] = false;
            this.readOnly[i2] = false;
            this.nullable[i2] = 1;
            this.signed[i2] = false;
            this.columnDisplaySize[i2] = 0;
            this.columnType[i2] = 0;
            this.columnLabel[i2] = "";
            this.columnName[i2] = "";
            this.schemaName[i2] = "";
            this.precision[i2] = 0;
            this.scale[i2] = 0;
            this.tableName[i2] = "";
            this.columnTypeName[i2] = "";
            this.writable[i2] = false;
            this.definatelyWritable[i2] = false;
            this.currency[i2] = false;
            this.autoIncrement[i2] = true;
            this.catalogName[i2] = "";
            this.columnClassName[i2] = "";
        }
    }

    OracleRowSetMetaData(ResultSetMetaData resultSetMetaData) throws SQLException {
        this.columnCount = resultSetMetaData.getColumnCount();
        this.searchable = new boolean[this.columnCount];
        this.caseSensitive = new boolean[this.columnCount];
        this.readOnly = new boolean[this.columnCount];
        this.nullable = new int[this.columnCount];
        this.signed = new boolean[this.columnCount];
        this.columnDisplaySize = new int[this.columnCount];
        this.columnType = new int[this.columnCount];
        this.columnLabel = new String[this.columnCount];
        this.columnName = new String[this.columnCount];
        this.schemaName = new String[this.columnCount];
        this.precision = new int[this.columnCount];
        this.scale = new int[this.columnCount];
        this.tableName = new String[this.columnCount];
        this.columnTypeName = new String[this.columnCount];
        this.writable = new boolean[this.columnCount];
        this.definatelyWritable = new boolean[this.columnCount];
        this.currency = new boolean[this.columnCount];
        this.autoIncrement = new boolean[this.columnCount];
        this.catalogName = new String[this.columnCount];
        this.columnClassName = new String[this.columnCount];
        for (int i2 = 0; i2 < this.columnCount; ++i2) {
            this.searchable[i2] = resultSetMetaData.isSearchable(i2 + 1);
            this.caseSensitive[i2] = resultSetMetaData.isCaseSensitive(i2 + 1);
            this.readOnly[i2] = resultSetMetaData.isReadOnly(i2 + 1);
            this.nullable[i2] = resultSetMetaData.isNullable(i2 + 1);
            this.signed[i2] = resultSetMetaData.isSigned(i2 + 1);
            this.columnDisplaySize[i2] = resultSetMetaData.getColumnDisplaySize(i2 + 1);
            this.columnType[i2] = resultSetMetaData.getColumnType(i2 + 1);
            this.columnLabel[i2] = resultSetMetaData.getColumnLabel(i2 + 1);
            this.columnName[i2] = resultSetMetaData.getColumnName(i2 + 1);
            this.schemaName[i2] = resultSetMetaData.getSchemaName(i2 + 1);
            if (this.columnType[i2] == 2 || this.columnType[i2] == 2 || this.columnType[i2] == -5 || this.columnType[i2] == 3 || this.columnType[i2] == 8 || this.columnType[i2] == 6 || this.columnType[i2] == 4) {
                this.precision[i2] = resultSetMetaData.getPrecision(i2 + 1);
                this.scale[i2] = resultSetMetaData.getScale(i2 + 1);
            } else {
                this.precision[i2] = 0;
                this.scale[i2] = 0;
            }
            this.tableName[i2] = resultSetMetaData.getTableName(i2 + 1);
            this.columnTypeName[i2] = resultSetMetaData.getColumnTypeName(i2 + 1);
            this.writable[i2] = resultSetMetaData.isWritable(i2 + 1);
            this.definatelyWritable[i2] = resultSetMetaData.isDefinitelyWritable(i2 + 1);
            this.currency[i2] = resultSetMetaData.isCurrency(i2 + 1);
            this.autoIncrement[i2] = resultSetMetaData.isAutoIncrement(i2 + 1);
            this.catalogName[i2] = resultSetMetaData.getCatalogName(i2 + 1);
            this.columnClassName[i2] = resultSetMetaData.getColumnClassName(i2 + 1);
        }
    }

    private void validateColumnIndex(int n2) throws SQLException {
        if (n2 < 1 || n2 > this.columnCount) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "" + n2);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
    }

    @Override
    public int getColumnCount() throws SQLException {
        return this.columnCount;
    }

    @Override
    public boolean isAutoIncrement(int n2) throws SQLException {
        this.validateColumnIndex(n2);
        return this.autoIncrement[n2 - 1];
    }

    @Override
    public boolean isCaseSensitive(int n2) throws SQLException {
        this.validateColumnIndex(n2);
        return this.caseSensitive[n2 - 1];
    }

    @Override
    public boolean isSearchable(int n2) throws SQLException {
        this.validateColumnIndex(n2);
        return this.searchable[n2 - 1];
    }

    @Override
    public boolean isCurrency(int n2) throws SQLException {
        this.validateColumnIndex(n2);
        return this.currency[n2 - 1];
    }

    @Override
    public int isNullable(int n2) throws SQLException {
        this.validateColumnIndex(n2);
        return this.nullable[n2 - 1];
    }

    @Override
    public boolean isSigned(int n2) throws SQLException {
        this.validateColumnIndex(n2);
        return this.signed[n2 - 1];
    }

    @Override
    public int getColumnDisplaySize(int n2) throws SQLException {
        this.validateColumnIndex(n2);
        return this.columnDisplaySize[n2 - 1];
    }

    @Override
    public String getColumnLabel(int n2) throws SQLException {
        this.validateColumnIndex(n2);
        return this.columnLabel[n2 - 1];
    }

    @Override
    public String getColumnName(int n2) throws SQLException {
        this.validateColumnIndex(n2);
        return this.columnName[n2 - 1];
    }

    @Override
    public String getSchemaName(int n2) throws SQLException {
        this.validateColumnIndex(n2);
        return this.schemaName[n2 - 1];
    }

    @Override
    public int getPrecision(int n2) throws SQLException {
        this.validateColumnIndex(n2);
        return this.precision[n2 - 1];
    }

    @Override
    public int getScale(int n2) throws SQLException {
        this.validateColumnIndex(n2);
        return this.scale[n2 - 1];
    }

    @Override
    public String getTableName(int n2) throws SQLException {
        this.validateColumnIndex(n2);
        return this.tableName[n2 - 1];
    }

    @Override
    public String getCatalogName(int n2) throws SQLException {
        this.validateColumnIndex(n2);
        return this.catalogName[n2 - 1];
    }

    @Override
    public int getColumnType(int n2) throws SQLException {
        this.validateColumnIndex(n2);
        return this.columnType[n2 - 1];
    }

    @Override
    public String getColumnTypeName(int n2) throws SQLException {
        this.validateColumnIndex(n2);
        return this.columnTypeName[n2 - 1];
    }

    @Override
    public boolean isReadOnly(int n2) throws SQLException {
        this.validateColumnIndex(n2);
        return this.readOnly[n2 - 1];
    }

    @Override
    public boolean isWritable(int n2) throws SQLException {
        this.validateColumnIndex(n2);
        return this.writable[n2 - 1];
    }

    @Override
    public boolean isDefinitelyWritable(int n2) throws SQLException {
        this.validateColumnIndex(n2);
        return this.definatelyWritable[n2 - 1];
    }

    @Override
    public String getColumnClassName(int n2) throws SQLException {
        this.validateColumnIndex(n2);
        return this.columnClassName[n2 - 1];
    }

    @Override
    public void setAutoIncrement(int n2, boolean bl) throws SQLException {
        this.validateColumnIndex(n2);
        this.autoIncrement[n2 - 1] = bl;
    }

    @Override
    public void setCaseSensitive(int n2, boolean bl) throws SQLException {
        this.validateColumnIndex(n2);
        this.caseSensitive[n2 - 1] = bl;
    }

    @Override
    public void setCatalogName(int n2, String string) throws SQLException {
        this.validateColumnIndex(n2);
        this.catalogName[n2 - 1] = string;
    }

    @Override
    public void setColumnCount(int n2) throws SQLException {
        this.columnCount = n2;
    }

    @Override
    public void setColumnDisplaySize(int n2, int n3) throws SQLException {
        this.validateColumnIndex(n2);
        this.columnDisplaySize[n2 - 1] = n3;
    }

    @Override
    public void setColumnLabel(int n2, String string) throws SQLException {
        this.validateColumnIndex(n2);
        this.columnLabel[n2 - 1] = string;
    }

    @Override
    public void setColumnName(int n2, String string) throws SQLException {
        this.validateColumnIndex(n2);
        this.columnName[n2 - 1] = string;
    }

    @Override
    public void setColumnType(int n2, int n3) throws SQLException {
        this.validateColumnIndex(n2);
        this.columnType[n2 - 1] = n3;
    }

    @Override
    public void setColumnTypeName(int n2, String string) throws SQLException {
        this.validateColumnIndex(n2);
        this.columnTypeName[n2 - 1] = string;
    }

    @Override
    public void setCurrency(int n2, boolean bl) throws SQLException {
        this.validateColumnIndex(n2);
        this.currency[n2 - 1] = bl;
    }

    @Override
    public void setNullable(int n2, int n3) throws SQLException {
        this.validateColumnIndex(n2);
        this.nullable[n2 - 1] = n3;
    }

    @Override
    public void setPrecision(int n2, int n3) throws SQLException {
        this.validateColumnIndex(n2);
        this.precision[n2 - 1] = n3;
    }

    @Override
    public void setScale(int n2, int n3) throws SQLException {
        this.validateColumnIndex(n2);
        this.scale[n2 - 1] = n3;
    }

    @Override
    public void setSchemaName(int n2, String string) throws SQLException {
        this.validateColumnIndex(n2);
        this.schemaName[n2 - 1] = string;
    }

    @Override
    public void setSearchable(int n2, boolean bl) throws SQLException {
        this.validateColumnIndex(n2);
        this.searchable[n2 - 1] = bl;
    }

    @Override
    public void setSigned(int n2, boolean bl) throws SQLException {
        this.validateColumnIndex(n2);
        this.signed[n2 - 1] = bl;
    }

    @Override
    public void setTableName(int n2, String string) throws SQLException {
        this.validateColumnIndex(n2);
        this.tableName[n2 - 1] = string;
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        if (clazz.isInterface()) {
            return clazz.isInstance(this);
        }
        SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 177);
        sQLException.fillInStackTrace();
        throw sQLException;
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        if (clazz.isInterface() && clazz.isInstance(this)) {
            return (T)this;
        }
        SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 177);
        sQLException.fillInStackTrace();
        throw sQLException;
    }

    protected OracleConnection getConnectionDuringExceptionHandling() {
        return null;
    }
}

