/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.component.visit.VisitCallback;
import javax.faces.component.visit.VisitContext;
import javax.faces.context.FacesContext;
import org.primefaces.context.PrimeRequestContext;
import org.primefaces.expression.ComponentNotFoundException;
import org.primefaces.expression.SearchExpressionFacade;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.EscapeUtils;
import org.primefaces.util.LangUtils;
import org.primefaces.visit.ResetInputVisitCallback;

public class PrimeFaces {
    private static final Logger LOGGER = Logger.getLogger(PrimeFaces.class.getName());
    private static PrimeFaces instance = new PrimeFaces();
    private final Dialog dialog = new Dialog();
    private final Ajax ajax = new Ajax();

    protected PrimeFaces() {
    }

    public static PrimeFaces current() {
        return instance;
    }

    public static void setCurrent(PrimeFaces primeFaces) {
        instance = primeFaces;
    }

    protected FacesContext getFacesContext() {
        return FacesContext.getCurrentInstance();
    }

    protected PrimeRequestContext getRequestContext() {
        return PrimeRequestContext.getCurrentInstance();
    }

    public boolean isAjaxRequest() {
        return this.getFacesContext().getPartialViewContext().isAjaxRequest();
    }

    public void executeScript(String statement) {
        this.getRequestContext().getScriptsToExecute().add(statement);
    }

    public void scrollTo(String clientId) {
        this.executeScript("PrimeFaces.scrollTo('" + clientId + "');");
    }

    public void focus(String expression) {
        this.focus(expression, (UIComponent)FacesContext.getCurrentInstance().getViewRoot());
    }

    public void focus(String expression, UIComponent base) {
        if (LangUtils.isValueBlank(expression)) {
            return;
        }
        FacesContext facesContext = this.getFacesContext();
        String clientId = SearchExpressionFacade.resolveClientId(facesContext, base, expression);
        this.executeScript("PrimeFaces.focus('" + clientId + "');");
    }

    public void resetInputs(Collection<String> expressions) {
        if (expressions == null || expressions.isEmpty()) {
            return;
        }
        FacesContext facesContext = this.getFacesContext();
        VisitContext visitContext = VisitContext.createVisitContext((FacesContext)facesContext, null, ComponentUtils.VISIT_HINTS_SKIP_UNRENDERED);
        UIViewRoot root = facesContext.getViewRoot();
        for (String expression : expressions) {
            List<UIComponent> components = SearchExpressionFacade.resolveComponents(facesContext, (UIComponent)root, expression);
            for (UIComponent component : components) {
                component.visitTree(visitContext, (VisitCallback)ResetInputVisitCallback.INSTANCE);
            }
        }
    }

    public void resetInputs(String ... expressions) {
        if (expressions == null || expressions.length == 0) {
            return;
        }
        this.resetInputs(Arrays.asList(expressions));
    }

    public void clearTableStates() {
        this.getFacesContext().getExternalContext().getSessionMap().remove("primefaces.TABLE_STATE");
    }

    public void clearTableState(String key) {
        Map sessionMap = this.getFacesContext().getExternalContext().getSessionMap();
        Map dtState = (Map)sessionMap.get("primefaces.TABLE_STATE");
        if (dtState != null) {
            dtState.remove(key);
        }
    }

    public void clearDataListStates() {
        this.getFacesContext().getExternalContext().getSessionMap().remove("primefaces.DATALIST_STATE");
    }

    public void clearDataListState(String key) {
        Map sessionMap = this.getFacesContext().getExternalContext().getSessionMap();
        Map dtState = (Map)sessionMap.get("primefaces.DATALIST_STATE");
        if (dtState != null) {
            dtState.remove(key);
        }
    }

    public Dialog dialog() {
        return this.dialog;
    }

    public Ajax ajax() {
        return this.ajax;
    }

    public class Ajax {
        public void addCallbackParam(String name, Object value) {
            PrimeFaces.this.getRequestContext().getCallbackParams().put(name, value);
        }

        public void update(Collection<String> expressions) {
            if (expressions == null || expressions.isEmpty()) {
                return;
            }
            FacesContext facesContext = PrimeFaces.this.getFacesContext();
            for (String expression : expressions) {
                if (LangUtils.isValueBlank(expression)) continue;
                try {
                    String clientId = SearchExpressionFacade.resolveClientId(facesContext, (UIComponent)facesContext.getViewRoot(), expression);
                    facesContext.getPartialViewContext().getRenderIds().add(clientId);
                }
                catch (ComponentNotFoundException e) {
                    LOGGER.log(Level.WARNING, "PrimeFaces.current().ajax().update() called but component can't be resolved!Expression will just be added to the renderIds.", (Throwable)((Object)e));
                    facesContext.getPartialViewContext().getRenderIds().add(expression);
                }
            }
        }

        public void update(String ... expressions) {
            if (expressions == null || expressions.length == 0) {
                return;
            }
            this.update(Arrays.asList(expressions));
        }
    }

    public class Dialog {
        public void openDynamic(String outcome) {
            PrimeFaces.this.getFacesContext().getAttributes().put("dialog.outcome", outcome);
        }

        public void openDynamic(String outcome, Map<String, Object> options, Map<String, List<String>> params) {
            FacesContext facesContext = PrimeFaces.this.getFacesContext();
            facesContext.getAttributes().put("dialog.outcome", outcome);
            if (options != null) {
                facesContext.getAttributes().put("dialog.options", options);
            }
            if (params != null) {
                facesContext.getAttributes().put("dialog.params", params);
            }
        }

        public void closeDynamic(Object data) {
            FacesContext facesContext = PrimeFaces.this.getFacesContext();
            Map params = facesContext.getExternalContext().getRequestParameterMap();
            String pfdlgcid = (String)params.get("pfdlgcid");
            if (data != null) {
                Map session = facesContext.getExternalContext().getSessionMap();
                session.put(pfdlgcid, data);
            }
            PrimeFaces.this.executeScript("PrimeFaces.closeDialog({pfdlgcid:'" + EscapeUtils.forJavaScript(pfdlgcid) + "'});");
        }

        public void showMessageDynamic(FacesMessage message) {
            this.showMessageDynamic(message, true);
        }

        public void showMessageDynamic(FacesMessage message, boolean escape) {
            String summary = EscapeUtils.forJavaScript(message.getSummary());
            String detail = EscapeUtils.forJavaScript(message.getDetail());
            PrimeFaces.this.executeScript("PrimeFaces.showMessageInDialog({severity:\"" + message.getSeverity() + "\",summary:\"" + summary + "\",detail:\"" + detail + "\",escape:" + escape + "});");
        }
    }
}

