/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.application.resource;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.ResponseWriter;
import javax.faces.context.ResponseWriterWrapper;
import org.primefaces.application.resource.MoveScriptsToBottomState;
import org.primefaces.util.LangUtils;

public class MoveScriptsToBottomResponseWriter
extends ResponseWriterWrapper {
    private final ResponseWriter wrapped;
    private final MoveScriptsToBottomState state;
    private boolean inScript;
    private String scriptType;
    private StringBuilder include;
    private StringBuilder inline;
    private boolean scriptsRendered;

    public MoveScriptsToBottomResponseWriter(ResponseWriter wrapped, MoveScriptsToBottomState state) {
        this.wrapped = wrapped;
        this.state = state;
        this.inScript = false;
        this.scriptsRendered = false;
        this.include = new StringBuilder(50);
        this.inline = new StringBuilder(75);
    }

    public ResponseWriter getWrapped() {
        return this.wrapped;
    }

    public void write(int c) throws IOException {
        if (this.inScript) {
            this.inline.append((char)c);
        } else {
            this.getWrapped().write(c);
        }
    }

    public void write(char[] cbuf) throws IOException {
        if (this.inScript) {
            this.inline.append(cbuf);
        } else {
            this.getWrapped().write(cbuf);
        }
    }

    public void write(char[] cbuf, int off, int len) throws IOException {
        if (this.inScript) {
            this.inline.append(cbuf, off, len);
        } else {
            this.getWrapped().write(cbuf, off, len);
        }
    }

    public void write(String str) throws IOException {
        if (this.inScript) {
            this.inline.append(str);
        } else {
            this.getWrapped().write(str);
        }
    }

    public void writeText(char[] cbuf, int off, int len) throws IOException {
        if (this.inScript) {
            this.inline.append(cbuf, off, len);
        } else {
            this.getWrapped().writeText(cbuf, off, len);
        }
    }

    public void writeText(Object text, String property) throws IOException {
        if (this.inScript) {
            this.inline.append(text);
        } else {
            this.getWrapped().writeText(text, property);
        }
    }

    public void writeText(Object text, UIComponent component, String property) throws IOException {
        if (this.inScript) {
            this.inline.append(text);
        } else {
            this.getWrapped().writeText(text, property);
        }
    }

    public void writeAttribute(String name, Object value, String property) throws IOException {
        if (this.inScript) {
            String strValue;
            if ("src".equalsIgnoreCase(name)) {
                String strValue2 = (String)value;
                if (!LangUtils.isValueBlank(strValue2)) {
                    this.include.append(strValue2);
                }
            } else if ("type".equalsIgnoreCase(name) && !LangUtils.isValueBlank(strValue = (String)value)) {
                this.scriptType = strValue;
            }
        } else {
            this.getWrapped().writeAttribute(name, value, property);
        }
    }

    public void writeURIAttribute(String name, Object value, String property) throws IOException {
        if (this.inScript) {
            String strValue;
            if ("src".equalsIgnoreCase(name)) {
                String strValue2 = (String)value;
                if (!LangUtils.isValueBlank(strValue2)) {
                    this.include.append(strValue2);
                }
            } else if ("type".equalsIgnoreCase(name) && !LangUtils.isValueBlank(strValue = (String)value)) {
                this.scriptType = strValue;
            }
        } else {
            this.getWrapped().writeURIAttribute(name, value, property);
        }
    }

    public void startElement(String name, UIComponent component) throws IOException {
        if ("script".equalsIgnoreCase(name)) {
            this.inScript = true;
            this.scriptType = "text/javascript";
        } else {
            this.getWrapped().startElement(name, component);
        }
    }

    public void endElement(String name) throws IOException {
        if ("script".equalsIgnoreCase(name)) {
            this.inScript = false;
            this.state.addInline(this.scriptType, this.inline);
            this.state.addInclude(this.scriptType, this.include);
            this.scriptType = null;
            this.include.setLength(0);
            this.inline.setLength(0);
        } else if ("body".equalsIgnoreCase(name) || "html".equalsIgnoreCase(name) && !this.scriptsRendered) {
            String type;
            for (Map.Entry<String, ArrayList<String>> entry : this.state.getIncludes().entrySet()) {
                type = entry.getKey();
                ArrayList<String> includes = entry.getValue();
                for (int i = 0; i < includes.size(); ++i) {
                    String src = includes.get(i);
                    if (src == null || src.isEmpty()) continue;
                    this.getWrapped().startElement("script", null);
                    this.getWrapped().writeAttribute("type", (Object)type, null);
                    this.getWrapped().writeAttribute("src", (Object)src, null);
                    this.getWrapped().endElement("script");
                }
            }
            for (Map.Entry<String, ArrayList<String>> entry : this.state.getInlines().entrySet()) {
                ArrayList<String> inlines;
                type = entry.getKey();
                String merged = this.mergeAndMinimizeInlineScripts(type, inlines = entry.getValue());
                if (LangUtils.isValueBlank(merged)) continue;
                this.getWrapped().startElement("script", null);
                this.getWrapped().writeAttribute("type", (Object)type, null);
                this.getWrapped().write(merged);
                this.getWrapped().endElement("script");
            }
            this.getWrapped().endElement(name);
            this.scriptsRendered = true;
        } else {
            this.getWrapped().endElement(name);
        }
    }

    protected String mergeAndMinimizeInlineScripts(String type, ArrayList<String> inlines) {
        StringBuilder script = new StringBuilder(inlines.size() * 100);
        for (int i = 0; i < inlines.size(); ++i) {
            if (i > 0) {
                script.append("\n");
            }
            script.append(inlines.get(i));
            script.append(";");
        }
        String minimized = script.toString();
        if ("text/javascript".equalsIgnoreCase(type) && (minimized = minimized.replace(";;", ";")).contains("PrimeFaces")) {
            minimized = minimized.replace("PrimeFaces.settings", "pf.settings").replace("PrimeFaces.cw", "pf.cw").replace("PrimeFaces.ab", "pf.ab").replace("window.PrimeFaces", "pf");
            minimized = "var pf=window.PrimeFaces;" + minimized;
        }
        return minimized;
    }

    public ResponseWriter cloneWithWriter(Writer writer) {
        return this.getWrapped().cloneWithWriter(writer);
    }
}

