/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.ajaxstatus;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.ajaxstatus.AjaxStatus;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.WidgetBuilder;

public class AjaxStatusRenderer
extends CoreRenderer {
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        AjaxStatus status = (AjaxStatus)component;
        this.encodeMarkup(context, status);
        this.encodeScript(context, status);
    }

    protected void encodeScript(FacesContext context, AjaxStatus status) throws IOException {
        String clientId = status.getClientId(context);
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.init("AjaxStatus", status.resolveWidgetVar(), clientId);
        wb.callback("start", "function()", status.getOnstart()).callback("error", "function()", status.getOnerror()).callback("success", "function()", status.getOnsuccess()).callback("complete", "function()", status.getOncomplete());
        wb.finish();
    }

    protected void encodeMarkup(FacesContext context, AjaxStatus status) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = status.getClientId(context);
        writer.startElement("div", null);
        writer.writeAttribute("id", (Object)clientId, null);
        if (status.getStyle() != null) {
            writer.writeAttribute("style", (Object)status.getStyle(), "style");
        }
        if (status.getStyleClass() != null) {
            writer.writeAttribute("class", (Object)status.getStyleClass(), "styleClass");
        }
        for (String event : AjaxStatus.EVENTS) {
            UIComponent facet = status.getFacet(event);
            if (facet == null) continue;
            this.encodeFacet(context, clientId, facet, event, true);
        }
        UIComponent defaultFacet = status.getFacet("default");
        if (defaultFacet != null) {
            this.encodeFacet(context, clientId, defaultFacet, "default", false);
        }
        writer.endElement("div");
    }

    protected void encodeFacet(FacesContext context, String clientId, UIComponent facet, String facetName, boolean hidden) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("div", null);
        writer.writeAttribute("id", (Object)(clientId + "_" + facetName), null);
        if (hidden) {
            writer.writeAttribute("style", (Object)"display:none", null);
        }
        this.renderChild(context, facet);
        writer.endElement("div");
    }
}

