/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.chips;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import org.primefaces.component.chips.Chips;
import org.primefaces.renderkit.InputRenderer;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.HTML;
import org.primefaces.util.LangUtils;
import org.primefaces.util.WidgetBuilder;

public class ChipsRenderer
extends InputRenderer {
    public void decode(FacesContext context, UIComponent component) {
        Chips chips = (Chips)component;
        String clientId = chips.getClientId(context);
        if (!this.shouldDecode((UIInput)chips)) {
            return;
        }
        Map params = context.getExternalContext().getRequestParameterMap();
        Map paramValues = context.getExternalContext().getRequestParameterValuesMap();
        String[] hInputValues = (String[])paramValues.get(clientId + "_hinput");
        String[] submittedValues = hInputValues != null ? hInputValues : new String[]{};
        String inputValue = (String)params.get(clientId + "_input");
        if (!this.isValueBlank(inputValue)) {
            submittedValues = LangUtils.concat(submittedValues, new String[]{inputValue});
        }
        if (submittedValues.length > chips.getMax()) {
            return;
        }
        if (submittedValues.length > 0) {
            chips.setSubmittedValue(submittedValues);
        } else {
            chips.setSubmittedValue("");
        }
        this.decodeBehaviors(context, (UIComponent)chips);
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        Chips chips = (Chips)component;
        this.encodeMarkup(context, chips);
        this.encodeScript(context, chips);
    }

    protected void encodeMarkup(FacesContext context, Chips chips) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = chips.getClientId(context);
        String inputId = clientId + "_input";
        List values = (List)chips.getValue();
        ArrayList<String> stringValues = new ArrayList<String>();
        boolean disabled = chips.isDisabled();
        String title = chips.getTitle();
        String style = chips.getStyle();
        String styleClass = chips.getStyleClass();
        styleClass = styleClass == null ? "ui-chips ui-widget" : "ui-chips ui-widget " + styleClass;
        String inputStyle = chips.getInputStyle();
        String inputStyleClass = chips.getInputStyleClass();
        String listClass = disabled ? "ui-chips-container ui-inputfield ui-state-default ui-corner-all ui-state-disabled" : "ui-chips-container ui-inputfield ui-state-default ui-corner-all";
        listClass = inputStyleClass == null ? listClass : listClass + " " + inputStyleClass;
        listClass = chips.isValid() ? listClass : listClass + " ui-state-error";
        writer.startElement("div", null);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.writeAttribute("class", (Object)styleClass, null);
        if (style != null) {
            writer.writeAttribute("style", (Object)style, null);
        }
        if (title != null) {
            writer.writeAttribute("title", (Object)title, null);
        }
        writer.startElement("ul", null);
        writer.writeAttribute("class", (Object)listClass, null);
        if (inputStyle != null) {
            writer.writeAttribute("style", (Object)inputStyle, null);
        }
        this.renderARIARequired(context, (UIInput)chips);
        if (values != null && !values.isEmpty()) {
            Converter converter = ComponentUtils.getConverter(context, (UIComponent)chips);
            for (Object value : values) {
                String tokenValue = converter != null ? converter.getAsString(context, (UIComponent)chips, value) : String.valueOf(value);
                writer.startElement("li", null);
                writer.writeAttribute("data-token-value", (Object)tokenValue, null);
                writer.writeAttribute("class", (Object)"ui-chips-token ui-state-active ui-corner-all", null);
                writer.startElement("span", null);
                writer.writeAttribute("class", (Object)"ui-chips-token-label", null);
                writer.writeText((Object)tokenValue, null);
                writer.endElement("span");
                writer.startElement("span", null);
                writer.writeAttribute("class", (Object)"ui-chips-token-icon ui-icon ui-icon-close", null);
                writer.endElement("span");
                writer.endElement("li");
                stringValues.add(tokenValue);
            }
        }
        writer.startElement("li", null);
        writer.writeAttribute("class", (Object)"ui-chips-input-token", null);
        writer.startElement("input", null);
        writer.writeAttribute("type", (Object)"text", null);
        writer.writeAttribute("id", (Object)inputId, null);
        writer.writeAttribute("class", (Object)"ui-widget", null);
        writer.writeAttribute("name", (Object)inputId, null);
        writer.writeAttribute("autocomplete", (Object)"off", null);
        this.renderAccessibilityAttributes(context, (UIInput)chips);
        this.renderPassThruAttributes(context, (UIComponent)chips, HTML.INPUT_TEXT_ATTRS_WITHOUT_EVENTS);
        this.renderDomEvents(context, (UIComponent)chips, HTML.INPUT_TEXT_EVENTS);
        writer.endElement("input");
        writer.endElement("li");
        writer.endElement("ul");
        this.encodeHiddenSelect(context, chips, clientId, stringValues);
        writer.endElement("div");
    }

    protected void encodeHiddenSelect(FacesContext context, Chips chips, String clientId, List<String> values) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String id = clientId + "_hinput";
        writer.startElement("select", null);
        writer.writeAttribute("id", (Object)id, null);
        writer.writeAttribute("name", (Object)id, null);
        writer.writeAttribute("multiple", (Object)"multiple", null);
        writer.writeAttribute("class", (Object)"ui-helper-hidden", null);
        if (chips.isDisabled()) {
            writer.writeAttribute("disabled", (Object)"disabled", "disabled");
        }
        for (String value : values) {
            writer.startElement("option", null);
            writer.writeAttribute("value", (Object)value, null);
            writer.writeAttribute("selected", (Object)"selected", null);
            writer.endElement("option");
        }
        writer.endElement("select");
    }

    protected void encodeScript(FacesContext context, Chips chips) throws IOException {
        String clientId = chips.getClientId(context);
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.init("Chips", chips.resolveWidgetVar(), clientId).attr("max", chips.getMax(), Integer.MAX_VALUE);
        this.encodeClientBehaviors(context, (ClientBehaviorHolder)chips);
        wb.finish();
    }

    @Override
    public Object getConvertedValue(FacesContext context, UIComponent component, Object submittedValue) throws ConverterException {
        Chips chips = (Chips)component;
        if (submittedValue == null || submittedValue.equals("")) {
            return null;
        }
        Converter converter = ComponentUtils.getConverter(context, component);
        String[] values = (String[])submittedValue;
        ArrayList<String> list = new ArrayList<String>();
        for (String value : values) {
            String convertedValue;
            if (this.isValueBlank(value)) continue;
            String string = convertedValue = converter != null ? converter.getAsObject(context, (UIComponent)chips, value) : value;
            if (convertedValue == null) continue;
            list.add(convertedValue);
        }
        return list;
    }
}

