/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.commandbutton;

import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.logging.Logger;
import javax.faces.application.ResourceDependencies;
import javax.faces.application.ResourceDependency;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.event.AjaxBehaviorEvent;
import javax.faces.event.BehaviorEvent;
import javax.faces.event.FacesEvent;
import org.primefaces.component.commandbutton.CommandButtonBase;
import org.primefaces.event.SelectEvent;
import org.primefaces.util.LangUtils;
import org.primefaces.util.MapBuilder;

@ResourceDependencies(value={@ResourceDependency(library="primefaces", name="components.css"), @ResourceDependency(library="primefaces", name="jquery/jquery.js"), @ResourceDependency(library="primefaces", name="jquery/jquery-plugins.js"), @ResourceDependency(library="primefaces", name="core.js"), @ResourceDependency(library="primefaces", name="components.js")})
public class CommandButton
extends CommandButtonBase {
    public static final String COMPONENT_TYPE = "org.primefaces.component.CommandButton";
    private static final Logger LOGGER = Logger.getLogger(CommandButton.class.getName());
    private static final Map<String, Class<? extends BehaviorEvent>> BEHAVIOR_EVENT_MAPPING = MapBuilder.builder().put("click", null).put("dialogReturn", SelectEvent.class).build();
    private static final Collection<String> EVENT_NAMES = BEHAVIOR_EVENT_MAPPING.keySet();
    private String confirmationScript;

    @Override
    public Map<String, Class<? extends BehaviorEvent>> getBehaviorEventMapping() {
        return BEHAVIOR_EVENT_MAPPING;
    }

    public Collection<String> getEventNames() {
        return EVENT_NAMES;
    }

    public String getDefaultEventName() {
        return "click";
    }

    public void queueEvent(FacesEvent event) {
        FacesContext context = this.getFacesContext();
        if (event instanceof AjaxBehaviorEvent) {
            Map params = context.getExternalContext().getRequestParameterMap();
            String eventName = (String)params.get("javax.faces.behavior.event");
            if (eventName.equals("dialogReturn")) {
                AjaxBehaviorEvent behaviorEvent = (AjaxBehaviorEvent)event;
                Map session = context.getExternalContext().getSessionMap();
                String dcid = (String)params.get(this.getClientId(context) + "_pfdlgcid");
                Object selectedValue = session.get(dcid);
                session.remove(dcid);
                event = new SelectEvent((UIComponent)this, behaviorEvent.getBehavior(), selectedValue);
                super.queueEvent(event);
            } else if (eventName.equals("click")) {
                super.queueEvent(event);
            }
        } else {
            super.queueEvent(event);
        }
    }

    public String resolveIcon() {
        String icon = this.getIcon();
        if (icon == null && (icon = this.getImage()) != null) {
            LOGGER.info("image attribute is deprecated to define an icon, use icon attribute instead.");
        }
        return icon;
    }

    public String resolveStyleClass() {
        String userStyleClass;
        String icon = this.resolveIcon();
        Object value = this.getValue();
        String styleClass = "";
        if (value != null && LangUtils.isValueBlank(icon)) {
            styleClass = "ui-button ui-widget ui-state-default ui-corner-all ui-button-text-only";
        } else if (value != null && !LangUtils.isValueBlank(icon)) {
            styleClass = this.getIconPos().equals("left") ? "ui-button ui-widget ui-state-default ui-corner-all ui-button-text-icon-left" : "ui-button ui-widget ui-state-default ui-corner-all ui-button-text-icon-right";
        } else if (value == null && !LangUtils.isValueBlank(icon)) {
            styleClass = "ui-button ui-widget ui-state-default ui-corner-all ui-button-icon-only";
        }
        if (this.isDisabled()) {
            styleClass = styleClass + " ui-state-disabled";
        }
        if ((userStyleClass = this.getStyleClass()) != null) {
            styleClass = styleClass + " " + userStyleClass;
        }
        return styleClass;
    }

    @Override
    public boolean isPartialSubmitSet() {
        return this.getStateHelper().get((Serializable)((Object)CommandButtonBase.PropertyKeys.partialSubmit)) != null || this.getValueExpression(CommandButtonBase.PropertyKeys.partialSubmit.toString()) != null;
    }

    @Override
    public boolean isResetValuesSet() {
        return this.getStateHelper().get((Serializable)((Object)CommandButtonBase.PropertyKeys.resetValues)) != null || this.getValueExpression(CommandButtonBase.PropertyKeys.resetValues.toString()) != null;
    }

    @Override
    public String getConfirmationScript() {
        return this.confirmationScript;
    }

    @Override
    public void setConfirmationScript(String confirmationScript) {
        this.confirmationScript = confirmationScript;
    }

    @Override
    public boolean requiresConfirmation() {
        return this.confirmationScript != null;
    }

    @Override
    public boolean isAjaxified() {
        return !this.getType().equals("reset") && !this.getType().equals("button") && this.isAjax();
    }
}

