/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.datatable.feature;

import java.io.IOException;
import java.util.Map;
import javax.faces.context.FacesContext;
import org.primefaces.component.datatable.DataTable;
import org.primefaces.component.datatable.DataTableRenderer;
import org.primefaces.component.datatable.TableState;
import org.primefaces.component.datatable.feature.DataTableFeature;
import org.primefaces.util.LangUtils;

public class DraggableColumnsFeature
implements DataTableFeature {
    @Override
    public void decode(FacesContext context, DataTable table) {
        Map params = context.getExternalContext().getRequestParameterMap();
        String columnOrderParam = (String)params.get(table.getClientId(context) + "_columnOrder");
        if (LangUtils.isValueBlank(columnOrderParam)) {
            return;
        }
        table.setColumns(table.findOrderedColumns(columnOrderParam));
        if (table.isMultiViewState()) {
            TableState ts = table.getTableState(true);
            ts.setOrderedColumnsAsString(columnOrderParam);
        }
    }

    @Override
    public void encode(FacesContext context, DataTableRenderer renderer, DataTable table) throws IOException {
        throw new RuntimeException("DraggableColumns Feature should not encode.");
    }

    @Override
    public boolean shouldDecode(FacesContext context, DataTable table) {
        return table.isDraggableColumns();
    }

    @Override
    public boolean shouldEncode(FacesContext context, DataTable table) {
        return false;
    }
}

