/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.datepicker;

import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.faces.application.FacesMessage;
import javax.faces.application.ResourceDependencies;
import javax.faces.application.ResourceDependency;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.event.AjaxBehaviorEvent;
import javax.faces.event.FacesEvent;
import javax.faces.event.PhaseId;
import org.primefaces.component.datepicker.DatePickerBase;
import org.primefaces.event.DateViewChangeEvent;
import org.primefaces.event.SelectEvent;
import org.primefaces.util.CalendarUtils;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.LangUtils;
import org.primefaces.util.MessageFactory;

@ResourceDependencies(value={@ResourceDependency(library="primefaces", name="components.css"), @ResourceDependency(library="primefaces", name="jquery/jquery.js"), @ResourceDependency(library="primefaces", name="jquery/jquery-plugins.js"), @ResourceDependency(library="primefaces", name="core.js"), @ResourceDependency(library="primefaces", name="components.js"), @ResourceDependency(library="primefaces", name="datepicker/datepicker.js")})
public class DatePicker
extends DatePickerBase {
    public static final String COMPONENT_TYPE = "org.primefaces.component.DatePicker";
    public static final String CONTAINER_EXTENSION_CLASS = "p-datepicker";
    private static final Collection<String> EVENT_NAMES = LangUtils.unmodifiableList("blur", "change", "valueChange", "click", "dblclick", "focus", "keydown", "keypress", "keyup", "mousedown", "mousemove", "mouseout", "mouseover", "mouseup", "select", "dateSelect", "viewChange", "close");
    private static final Collection<String> UNOBSTRUSIVE_EVENT_NAMES = LangUtils.unmodifiableList("dateSelect", "viewChange", "close");
    private final Map<String, AjaxBehaviorEvent> customEvents = new HashMap<String, AjaxBehaviorEvent>();

    public Collection<String> getEventNames() {
        return EVENT_NAMES;
    }

    @Override
    public Collection<String> getUnobstrusiveEventNames() {
        return UNOBSTRUSIVE_EVENT_NAMES;
    }

    public void queueEvent(FacesEvent event) {
        FacesContext context = this.getFacesContext();
        if (ComponentUtils.isRequestSource((UIComponent)this, context) && event instanceof AjaxBehaviorEvent) {
            Map params = context.getExternalContext().getRequestParameterMap();
            String eventName = (String)params.get("javax.faces.behavior.event");
            String clientId = this.getClientId(context);
            AjaxBehaviorEvent behaviorEvent = (AjaxBehaviorEvent)event;
            if (eventName != null) {
                if (eventName.equals("dateSelect")) {
                    this.customEvents.put("dateSelect", (AjaxBehaviorEvent)event);
                } else if (eventName.equals("close")) {
                    this.customEvents.put("close", (AjaxBehaviorEvent)event);
                } else if (eventName.equals("viewChange")) {
                    int month = Integer.parseInt((String)params.get(clientId + "_month"));
                    int year = Integer.parseInt((String)params.get(clientId + "_year"));
                    DateViewChangeEvent dateViewChangeEvent = new DateViewChangeEvent((UIComponent)this, behaviorEvent.getBehavior(), month, year);
                    dateViewChangeEvent.setPhaseId(behaviorEvent.getPhaseId());
                    super.queueEvent((FacesEvent)dateViewChangeEvent);
                } else {
                    super.queueEvent(event);
                }
            }
        } else {
            super.queueEvent(event);
        }
    }

    public void validate(FacesContext context) {
        super.validate(context);
        if (this.isValid() && ComponentUtils.isRequestSource((UIComponent)this, context)) {
            Iterator<String> customEventIter = this.customEvents.keySet().iterator();
            while (customEventIter.hasNext()) {
                AjaxBehaviorEvent behaviorEvent = this.customEvents.get(customEventIter.next());
                SelectEvent selectEvent = new SelectEvent((UIComponent)this, behaviorEvent.getBehavior(), this.getValue());
                if (behaviorEvent.getPhaseId().equals(PhaseId.APPLY_REQUEST_VALUES)) {
                    selectEvent.setPhaseId(PhaseId.PROCESS_VALIDATIONS);
                } else {
                    selectEvent.setPhaseId(PhaseId.INVOKE_APPLICATION);
                }
                super.queueEvent((FacesEvent)selectEvent);
            }
        }
    }

    protected void validateValue(FacesContext context, Object value) {
        super.validateValue(context, value);
        if (this.isValid() && !DatePicker.isEmpty((Object)value)) {
            List rangeValues;
            Date startDate;
            boolean isDisabledDate = false;
            boolean isRangeDatesSequential = true;
            if (value instanceof Date) {
                isDisabledDate = this.validateDateValue(context, (Date)value);
            } else if (value instanceof List && this.getSelectionMode().equals("range") && !(isDisabledDate = this.validateDateValue(context, startDate = (Date)(rangeValues = (List)value).get(0)))) {
                Date endDate = (Date)rangeValues.get(1);
                isDisabledDate = this.validateDateValue(context, endDate);
                if (this.isValid() && startDate.after(endDate)) {
                    this.setValid(false);
                    isRangeDatesSequential = false;
                }
            }
            if (!this.isValid()) {
                FacesMessage msg = null;
                String validatorMessage = this.getValidatorMessage();
                msg = validatorMessage != null ? new FacesMessage(FacesMessage.SEVERITY_ERROR, validatorMessage, validatorMessage) : (isDisabledDate ? MessageFactory.getMessage("primefaces.calendar.INVALID", FacesMessage.SEVERITY_ERROR, null) : (!isRangeDatesSequential ? MessageFactory.getMessage("primefaces.calendar.DATE_INVALID_RANGE_MESSAGE_ID", FacesMessage.SEVERITY_ERROR, null) : MessageFactory.getMessage("primefaces.calendar.OUT_OF_RANGE", FacesMessage.SEVERITY_ERROR, null)));
                context.addMessage(this.getClientId(context), msg);
            }
        }
    }

    protected boolean validateDateValue(FacesContext context, Date date) {
        List disabledDays;
        Calendar c;
        List disabledDates;
        Date maxDate;
        boolean isDisabledDate = false;
        Date minDate = CalendarUtils.getObjectAsDate(context, this, this.getMindate());
        if (minDate != null && !date.equals(minDate) && date.before(minDate)) {
            this.setValid(false);
        }
        if (this.isValid() && (maxDate = CalendarUtils.getObjectAsDate(context, this, this.getMaxdate())) != null && !date.equals(maxDate) && date.after(maxDate)) {
            this.setValid(false);
        }
        if (this.isValid() && (disabledDates = this.getDisabledDates()) != null) {
            c = Calendar.getInstance(CalendarUtils.calculateTimeZone(this.getTimeZone()), this.calculateLocale(context));
            c.setTime(date);
            int sYear = c.get(1);
            int sMonth = c.get(2);
            int sDay = c.get(5);
            for (Object disabledDate : disabledDates) {
                if (!(disabledDate instanceof Date)) continue;
                c.clear();
                c.setTime((Date)disabledDate);
                if (sYear != c.get(1) || sMonth != c.get(2) || sDay != c.get(5)) continue;
                this.setValid(false);
                isDisabledDate = true;
                break;
            }
        }
        if (this.isValid() && (disabledDays = this.getDisabledDays()) != null) {
            c = Calendar.getInstance(CalendarUtils.calculateTimeZone(this.getTimeZone()), this.calculateLocale(context));
            c.setTime(date);
            int dayOfWeek = c.get(7) - 1;
            if (disabledDays.contains(dayOfWeek)) {
                this.setValid(false);
                isDisabledDate = true;
            }
        }
        return isDisabledDate;
    }
}

