/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.editor;

import java.io.IOException;
import java.util.Map;
import java.util.logging.Logger;
import javax.faces.application.Resource;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import org.primefaces.component.editor.Editor;
import org.primefaces.renderkit.InputRenderer;
import org.primefaces.util.AgentUtils;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.WidgetBuilder;

public class EditorRenderer
extends InputRenderer {
    private static final Logger LOGGER = Logger.getLogger(EditorRenderer.class.getName());

    public void decode(FacesContext context, UIComponent component) {
        Editor editor = (Editor)component;
        if (!this.shouldDecode(editor)) {
            return;
        }
        this.decodeBehaviors(context, (UIComponent)editor);
        String inputParam = editor.getClientId(context) + "_input";
        Map params = context.getExternalContext().getRequestParameterMap();
        String value = (String)params.get(inputParam);
        if (value != null && value.equals("<br/>")) {
            value = "";
        }
        editor.setSubmittedValue(value);
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        Editor editor = (Editor)component;
        this.encodeMarkup(facesContext, editor);
        this.encodeScript(facesContext, editor);
    }

    protected void encodeMarkup(FacesContext context, Editor editor) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = editor.getClientId(context);
        String valueToRender = ComponentUtils.getValueToRender(context, (UIComponent)editor);
        String inputId = clientId + "_input";
        String style = editor.getStyle();
        style = style == null ? "visibility:hidden" : "visibility:hidden;" + style;
        writer.startElement("div", (UIComponent)editor);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.writeAttribute("style", (Object)style, null);
        if (editor.getStyleClass() != null) {
            writer.writeAttribute("class", (Object)editor.getStyleClass(), null);
        }
        writer.startElement("textarea", null);
        writer.writeAttribute("id", (Object)inputId, null);
        writer.writeAttribute("name", (Object)inputId, null);
        if (valueToRender != null) {
            writer.write(valueToRender);
        }
        writer.endElement("textarea");
        writer.endElement("div");
    }

    private void encodeScript(FacesContext context, Editor editor) throws IOException {
        String clientId = editor.getClientId(context);
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.init("Editor", editor.resolveWidgetVar(), clientId).attr("disabled", editor.isDisabled(), false).attr("invalid", editor.isValid(), true).attr("controls", editor.getControls(), null).attr("width", editor.getWidth(), Integer.MIN_VALUE).attr("height", editor.getHeight(), Integer.MIN_VALUE).attr("maxlength", editor.getMaxlength(), Integer.MAX_VALUE).callback("change", "function(e)", editor.getOnchange());
        if (AgentUtils.isIE(context)) {
            Resource resource = context.getApplication().getResourceHandler().createResource("editor/editor-ie.css", "primefaces");
            wb.attr("docCSSFile", resource.getRequestPath());
        }
        if (editor.getMaxlength() != Integer.MAX_VALUE) {
            LOGGER.info("Maxlength option is deprecated and will be removed in a future version.");
        }
        wb.finish();
    }

    @Override
    public Object getConvertedValue(FacesContext context, UIComponent component, Object submittedValue) throws ConverterException {
        Editor editor = (Editor)component;
        String value = (String)submittedValue;
        Converter converter = ComponentUtils.getConverter(context, component);
        if (converter != null) {
            return converter.getAsObject(context, (UIComponent)editor, value);
        }
        return value;
    }
}

