/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.export;

import java.io.IOException;
import java.io.Writer;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.el.MethodExpression;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import org.primefaces.component.api.DynamicColumn;
import org.primefaces.component.api.UIColumn;
import org.primefaces.component.datatable.DataTable;
import org.primefaces.component.export.CSVOptions;
import org.primefaces.component.export.Exporter;
import org.primefaces.component.export.ExporterOptions;
import org.primefaces.util.ComponentUtils;

public class CSVExporter
extends Exporter {
    private CSVOptions csvOptions = CSVOptions.EXCEL;

    public CSVExporter(ExporterOptions options) {
        if (options != null) {
            if (options instanceof CSVOptions) {
                this.csvOptions = (CSVOptions)options;
            } else {
                throw new IllegalArgumentException("Options must be an instance of CSVOptions.");
            }
        }
    }

    @Override
    public void export(FacesContext context, DataTable table, String filename, boolean pageOnly, boolean selectionOnly, String encodingType, MethodExpression preProcessor, MethodExpression postProcessor, ExporterOptions options, MethodExpression onTableRender) throws IOException {
        ExternalContext externalContext = context.getExternalContext();
        this.configureResponse(externalContext, filename, encodingType);
        StringBuilder builder = new StringBuilder();
        if (preProcessor != null) {
            preProcessor.invoke(context.getELContext(), new Object[]{builder});
        }
        this.addColumnFacets(builder, table, Exporter.ColumnType.HEADER);
        if (pageOnly) {
            this.exportPageOnly(context, table, builder);
        } else if (selectionOnly) {
            this.exportSelectionOnly(context, table, builder);
        } else {
            this.exportAll(context, table, builder);
        }
        if (table.hasFooterColumn()) {
            this.addColumnFacets(builder, table, Exporter.ColumnType.FOOTER);
        }
        if (postProcessor != null) {
            postProcessor.invoke(context.getELContext(), new Object[]{builder});
        }
        Writer writer = externalContext.getResponseOutputWriter();
        writer.write(builder.toString());
        writer.flush();
        writer.close();
    }

    @Override
    public void export(FacesContext facesContext, List<String> clientIds, String outputFileName, boolean pageOnly, boolean selectionOnly, String encodingType, MethodExpression preProcessor, MethodExpression postProcessor, ExporterOptions options, MethodExpression onTableRender) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void export(FacesContext facesContext, String outputFileName, List<DataTable> tables, boolean pageOnly, boolean selectionOnly, String encodingType, MethodExpression preProcessor, MethodExpression postProcessor, ExporterOptions options, MethodExpression onTableRender) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    protected void addColumnFacets(StringBuilder builder, DataTable table, Exporter.ColumnType columnType) throws IOException {
        boolean firstCellWritten = false;
        for (UIColumn col : table.getColumns()) {
            String textValue;
            if (col instanceof DynamicColumn) {
                ((DynamicColumn)col).applyStatelessModel();
            }
            if (!col.isRendered() || !col.isExportable()) continue;
            if (firstCellWritten) {
                builder.append(this.csvOptions.getDelimiterChar());
            }
            UIComponent facet = col.getFacet(columnType.facet());
            switch (columnType) {
                case HEADER: {
                    textValue = col.getExportHeaderValue() != null ? col.getExportHeaderValue() : col.getHeaderText();
                    break;
                }
                case FOOTER: {
                    textValue = col.getExportFooterValue() != null ? col.getExportFooterValue() : col.getFooterText();
                    break;
                }
                default: {
                    textValue = null;
                }
            }
            if (textValue != null) {
                this.addColumnValue(builder, textValue);
            } else if (facet != null) {
                this.addColumnValue(builder, facet);
            } else {
                this.addColumnValue(builder, "");
            }
            firstCellWritten = true;
        }
        builder.append(this.csvOptions.getEndOfLineSymbols());
    }

    @Override
    protected void exportCells(DataTable table, Object document) {
        StringBuilder builder = (StringBuilder)document;
        boolean firstCellWritten = false;
        for (UIColumn col : table.getColumns()) {
            if (col instanceof DynamicColumn) {
                ((DynamicColumn)col).applyStatelessModel();
            }
            if (!col.isRendered() || !col.isExportable()) continue;
            if (firstCellWritten) {
                builder.append(this.csvOptions.getDelimiterChar());
            }
            try {
                this.addColumnValue(builder, col.getChildren(), col);
            }
            catch (IOException ex) {
                throw new FacesException((Throwable)ex);
            }
            firstCellWritten = true;
        }
    }

    protected void configureResponse(ExternalContext externalContext, String filename, String encodingType) {
        externalContext.setResponseContentType("text/csv; charset=" + encodingType);
        externalContext.setResponseHeader("Expires", "0");
        externalContext.setResponseHeader("Cache-Control", "must-revalidate, post-check=0, pre-check=0");
        externalContext.setResponseHeader("Pragma", "public");
        externalContext.setResponseHeader("Content-disposition", ComponentUtils.createContentDisposition("attachment", filename + ".csv"));
        externalContext.addResponseCookie("primefaces.download", "true", Collections.emptyMap());
    }

    protected void addColumnValues(StringBuilder builder, List<UIColumn> columns) throws IOException {
        Iterator<UIColumn> iterator = columns.iterator();
        while (iterator.hasNext()) {
            UIColumn col = iterator.next();
            this.addColumnValue(builder, col.getChildren(), col);
            if (!iterator.hasNext()) continue;
            builder.append(this.csvOptions.getDelimiterChar());
        }
    }

    protected void addColumnValue(StringBuilder builder, UIComponent component) throws IOException {
        String value = component == null ? "" : this.exportValue(FacesContext.getCurrentInstance(), component);
        this.addColumnValue(builder, value);
    }

    protected void addColumnValue(StringBuilder builder, String value) throws IOException {
        value = value == null ? "" : value.replace(this.csvOptions.getQuoteString(), this.csvOptions.getDoubleQuoteString());
        builder.append(this.csvOptions.getQuoteChar()).append(value).append(this.csvOptions.getQuoteChar());
    }

    protected void addColumnValue(StringBuilder builder, List<UIComponent> components, UIColumn column) throws IOException {
        FacesContext context = FacesContext.getCurrentInstance();
        builder.append(this.csvOptions.getQuoteChar());
        if (column.getExportFunction() != null) {
            String value = this.exportColumnByFunction(context, column);
            value = value == null ? "" : value.replace(this.csvOptions.getQuoteString(), this.csvOptions.getDoubleQuoteString());
            builder.append(value);
        } else {
            for (UIComponent component : components) {
                if (!component.isRendered()) continue;
                String value = this.exportValue(context, component);
                value = value == null ? "" : value.replace(this.csvOptions.getQuoteString(), this.csvOptions.getDoubleQuoteString());
                builder.append(value);
            }
        }
        builder.append(this.csvOptions.getQuoteChar());
    }

    @Override
    protected void postRowExport(DataTable table, Object document) {
        ((StringBuilder)document).append(this.csvOptions.getEndOfLineSymbols());
    }
}

