/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.export;

import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.el.MethodExpression;
import javax.faces.FacesException;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIColumn;
import javax.faces.component.UIComponent;
import javax.faces.component.UIData;
import javax.faces.component.UIPanel;
import javax.faces.component.UISelectMany;
import javax.faces.component.ValueHolder;
import javax.faces.component.html.HtmlCommandLink;
import javax.faces.component.html.HtmlGraphicImage;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import org.primefaces.component.celleditor.CellEditor;
import org.primefaces.component.datatable.DataTable;
import org.primefaces.component.export.ExporterOptions;
import org.primefaces.component.overlaypanel.OverlayPanel;
import org.primefaces.util.ComponentUtils;

public abstract class Exporter {
    public abstract void export(FacesContext var1, DataTable var2, String var3, boolean var4, boolean var5, String var6, MethodExpression var7, MethodExpression var8, ExporterOptions var9, MethodExpression var10) throws IOException;

    public abstract void export(FacesContext var1, List<String> var2, String var3, boolean var4, boolean var5, String var6, MethodExpression var7, MethodExpression var8, ExporterOptions var9, MethodExpression var10) throws IOException;

    public abstract void export(FacesContext var1, String var2, List<DataTable> var3, boolean var4, boolean var5, String var6, MethodExpression var7, MethodExpression var8, ExporterOptions var9, MethodExpression var10) throws IOException;

    protected List<UIColumn> getColumnsToExport(UIData table) {
        ArrayList<UIColumn> columns = new ArrayList<UIColumn>();
        for (UIComponent child : table.getChildren()) {
            if (!(child instanceof UIColumn)) continue;
            UIColumn column = (UIColumn)child;
            columns.add(column);
        }
        return columns;
    }

    protected boolean hasColumnFooter(List<UIColumn> columns) {
        for (UIColumn column : columns) {
            if (column.getFooter() == null) continue;
            return true;
        }
        return false;
    }

    protected String exportColumnByFunction(FacesContext context, org.primefaces.component.api.UIColumn column) {
        MethodExpression exportFunction = column.getExportFunction();
        if (exportFunction != null) {
            return (String)exportFunction.invoke(context.getELContext(), new Object[]{column});
        }
        return "";
    }

    protected String exportValue(FacesContext context, UIComponent component) {
        if (component instanceof HtmlCommandLink) {
            HtmlCommandLink link = (HtmlCommandLink)component;
            Object value = link.getValue();
            if (value != null) {
                return String.valueOf(value);
            }
            for (UIComponent child : link.getChildren()) {
                if (!(child instanceof ValueHolder)) continue;
                return this.exportValue(context, child);
            }
            return "";
        }
        if (component instanceof ValueHolder) {
            Object submittedValue;
            if (component instanceof EditableValueHolder && (submittedValue = ((EditableValueHolder)component).getSubmittedValue()) != null) {
                return submittedValue.toString();
            }
            ValueHolder valueHolder = (ValueHolder)component;
            Object value = valueHolder.getValue();
            if (value == null) {
                return "";
            }
            Converter converter = valueHolder.getConverter();
            if (converter == null) {
                Class<?> valueType = value.getClass();
                converter = context.getApplication().createConverter(valueType);
            }
            if (converter != null) {
                if (component instanceof UISelectMany) {
                    StringBuilder builder = new StringBuilder();
                    List<Object> collection = null;
                    if (value instanceof List) {
                        collection = (List<Object>)value;
                    } else if (value.getClass().isArray()) {
                        collection = Arrays.asList(value);
                    } else {
                        throw new FacesException("Value of " + component.getClientId(context) + " must be a List or an Array.");
                    }
                    int collectionSize = collection.size();
                    for (int i = 0; i < collectionSize; ++i) {
                        Object object = collection.get(i);
                        builder.append(converter.getAsString(context, component, object));
                        if (i >= collectionSize - 1) continue;
                        builder.append(",");
                    }
                    String valuesAsString = builder.toString();
                    builder.setLength(0);
                    return valuesAsString;
                }
                return converter.getAsString(context, component, value);
            }
            return value.toString();
        }
        if (component instanceof CellEditor) {
            return this.exportValue(context, ((CellEditor)component).getFacet("output"));
        }
        if (component instanceof HtmlGraphicImage) {
            return (String)component.getAttributes().get("alt");
        }
        if (component instanceof OverlayPanel) {
            return "";
        }
        String value = component.toString();
        if (value != null) {
            return value.trim();
        }
        return "";
    }

    protected void exportPageOnly(FacesContext context, DataTable table, Object document) {
        int first = table.getFirst();
        int rows = table.getRows();
        if (rows == 0) {
            rows = table.getRowCount();
        }
        int rowsToExport = first + rows;
        for (int rowIndex = first; rowIndex < rowsToExport; ++rowIndex) {
            this.exportRow(table, document, rowIndex);
        }
    }

    protected void exportAll(FacesContext context, DataTable table, Object document) {
        int first = table.getFirst();
        int rowCount = table.getRowCount();
        int rows = table.getRows();
        boolean lazy = table.isLazy();
        if (lazy) {
            if (rowCount > 0) {
                table.setFirst(0);
                table.setRows(rowCount);
                table.clearLazyCache();
                table.loadLazyData();
            }
            for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
                this.exportRow(table, document, rowIndex);
            }
            table.setFirst(first);
            table.setRows(rows);
            table.setRowIndex(-1);
            table.clearLazyCache();
            table.loadLazyData();
        } else {
            for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
                this.exportRow(table, document, rowIndex);
            }
            table.setFirst(first);
        }
    }

    protected void exportRow(DataTable table, Object document, int rowIndex) {
        table.setRowIndex(rowIndex);
        if (!table.isRowAvailable()) {
            return;
        }
        this.preRowExport(table, document);
        this.exportCells(table, document);
        this.postRowExport(table, document);
    }

    protected void exportRow(DataTable table, Object document) {
        this.preRowExport(table, document);
        this.exportCells(table, document);
        this.postRowExport(table, document);
    }

    protected void exportSelectionOnly(FacesContext context, DataTable table, Object document) {
        Object selection = table.getSelection();
        String var = table.getVar();
        if (selection != null) {
            Map requestMap = context.getExternalContext().getRequestMap();
            if (selection.getClass().isArray()) {
                int size = Array.getLength(selection);
                for (int i = 0; i < size; ++i) {
                    requestMap.put(var, Array.get(selection, i));
                    this.exportRow(table, document);
                }
            } else if (List.class.isAssignableFrom(selection.getClass())) {
                List list = (List)selection;
                for (int i = 0; i < list.size(); ++i) {
                    requestMap.put(var, list.get(i));
                    this.exportRow(table, document);
                }
            } else {
                requestMap.put(var, selection);
                this.exportCells(table, document);
            }
        }
    }

    public String getSheetName(FacesContext context, DataTable table) {
        UIComponent header = table.getFacet("header");
        if (header != null) {
            if (header instanceof UIPanel) {
                for (UIComponent child : header.getChildren()) {
                    String value;
                    if (!child.isRendered() || (value = ComponentUtils.getValueToRender(context, child)) == null) continue;
                    return value;
                }
            } else {
                return ComponentUtils.getValueToRender(context, header);
            }
        }
        return null;
    }

    protected void preRowExport(DataTable table, Object document) {
    }

    protected void postRowExport(DataTable table, Object document) {
    }

    protected abstract void exportCells(DataTable var1, Object var2);

    protected static enum ColumnType {
        HEADER("header"),
        FOOTER("footer");

        private final String facet;

        private ColumnType(String facet) {
            this.facet = facet;
        }

        public String facet() {
            return this.facet;
        }

        public String toString() {
            return this.facet;
        }
    }
}

