/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.gmap;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.application.ResourceDependencies;
import javax.faces.application.ResourceDependency;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.event.AjaxBehaviorEvent;
import javax.faces.event.BehaviorEvent;
import javax.faces.event.FacesEvent;
import org.primefaces.PrimeFaces;
import org.primefaces.component.gmap.GMapBase;
import org.primefaces.component.gmap.GMapInfoWindow;
import org.primefaces.event.AbstractAjaxBehaviorEvent;
import org.primefaces.event.map.GeocodeEvent;
import org.primefaces.event.map.MarkerDragEvent;
import org.primefaces.event.map.OverlaySelectEvent;
import org.primefaces.event.map.PointSelectEvent;
import org.primefaces.event.map.ReverseGeocodeEvent;
import org.primefaces.event.map.StateChangeEvent;
import org.primefaces.model.map.GeocodeResult;
import org.primefaces.model.map.LatLng;
import org.primefaces.model.map.LatLngBounds;
import org.primefaces.model.map.Marker;
import org.primefaces.util.MapBuilder;

@ResourceDependencies(value={@ResourceDependency(library="primefaces", name="jquery/jquery.js"), @ResourceDependency(library="primefaces", name="core.js"), @ResourceDependency(library="primefaces", name="components.js"), @ResourceDependency(library="primefaces", name="gmap/gmap.js")})
public class GMap
extends GMapBase {
    public static final String COMPONENT_TYPE = "org.primefaces.component.GMap";
    private static final Map<String, Class<? extends BehaviorEvent>> BEHAVIOR_EVENT_MAPPING = MapBuilder.builder().put("overlaySelect", OverlaySelectEvent.class).put("stateChange", StateChangeEvent.class).put("pointSelect", PointSelectEvent.class).put("markerDrag", MarkerDragEvent.class).put("geocode", GeocodeEvent.class).put("reverseGeocode", ReverseGeocodeEvent.class).build();
    private static final Collection<String> EVENT_NAMES = BEHAVIOR_EVENT_MAPPING.keySet();

    @Override
    public Map<String, Class<? extends BehaviorEvent>> getBehaviorEventMapping() {
        return BEHAVIOR_EVENT_MAPPING;
    }

    public Collection<String> getEventNames() {
        return EVENT_NAMES;
    }

    public void queueEvent(FacesEvent event) {
        FacesContext context = this.getFacesContext();
        Map params = context.getExternalContext().getRequestParameterMap();
        String eventName = (String)params.get("javax.faces.behavior.event");
        String clientId = this.getClientId(context);
        if (this.isSelfRequest(context)) {
            AjaxBehaviorEvent behaviorEvent = (AjaxBehaviorEvent)event;
            AbstractAjaxBehaviorEvent wrapperEvent = null;
            if (eventName.equals("overlaySelect")) {
                wrapperEvent = new OverlaySelectEvent((UIComponent)this, behaviorEvent.getBehavior(), this.getModel().findOverlay((String)params.get(clientId + "_overlayId")));
                GMapInfoWindow infoWindow = this.getInfoWindow();
                if (infoWindow != null) {
                    PrimeFaces.current().ajax().update(infoWindow.getClientId(context));
                }
            } else if (eventName.equals("stateChange")) {
                String[] centerLoc = ((String)params.get(clientId + "_center")).split(",");
                String[] northeastLoc = ((String)params.get(clientId + "_northeast")).split(",");
                String[] southwestLoc = ((String)params.get(clientId + "_southwest")).split(",");
                int zoomLevel = Integer.parseInt((String)params.get(clientId + "_zoom"));
                LatLng center = new LatLng(Double.valueOf(centerLoc[0]), Double.valueOf(centerLoc[1]));
                LatLng northeast = new LatLng(Double.valueOf(northeastLoc[0]), Double.valueOf(northeastLoc[1]));
                LatLng southwest = new LatLng(Double.valueOf(southwestLoc[0]), Double.valueOf(southwestLoc[1]));
                wrapperEvent = new StateChangeEvent((UIComponent)this, behaviorEvent.getBehavior(), new LatLngBounds(northeast, southwest), zoomLevel, center);
            } else if (eventName.equals("pointSelect")) {
                String[] latlng = ((String)params.get(clientId + "_pointLatLng")).split(",");
                LatLng position = new LatLng(Double.valueOf(latlng[0]), Double.valueOf(latlng[1]));
                wrapperEvent = new PointSelectEvent((UIComponent)this, behaviorEvent.getBehavior(), position);
            } else if (eventName.equals("markerDrag")) {
                Marker marker = (Marker)this.getModel().findOverlay((String)params.get(clientId + "_markerId"));
                double lat = Double.parseDouble((String)params.get(clientId + "_lat"));
                double lng = Double.parseDouble((String)params.get(clientId + "_lng"));
                marker.setLatlng(new LatLng(lat, lng));
                wrapperEvent = new MarkerDragEvent((UIComponent)this, behaviorEvent.getBehavior(), marker);
            } else if (eventName.equals("geocode")) {
                ArrayList<GeocodeResult> results = new ArrayList<GeocodeResult>();
                String query = (String)params.get(clientId + "_query");
                String[] addresses = ((String)params.get(clientId + "_addresses")).split("_primefaces_");
                String[] lats = ((String)params.get(clientId + "_lat")).split(",");
                String[] lngs = ((String)params.get(clientId + "_lng")).split(",");
                for (int i = 0; i < addresses.length; ++i) {
                    results.add(new GeocodeResult(addresses[i], new LatLng(Double.valueOf(lats[i]), Double.valueOf(lngs[i]))));
                }
                wrapperEvent = new GeocodeEvent((UIComponent)this, behaviorEvent.getBehavior(), query, results);
            } else if (eventName.equals("reverseGeocode")) {
                ArrayList<String> addresses = new ArrayList<String>();
                String[] results = ((String)params.get(clientId + "_address")).split("_primefaces_");
                for (int i = 0; i < results.length; ++i) {
                    addresses.add(results[i]);
                }
                double lat = Double.parseDouble((String)params.get(clientId + "_lat"));
                double lng = Double.parseDouble((String)params.get(clientId + "_lng"));
                LatLng coord = new LatLng(lat, lng);
                wrapperEvent = new ReverseGeocodeEvent((UIComponent)this, behaviorEvent.getBehavior(), coord, addresses);
            }
            if (wrapperEvent == null) {
                throw new FacesException("Component " + this.getClass().getName() + " does not support event " + eventName + "!");
            }
            wrapperEvent.setPhaseId(behaviorEvent.getPhaseId());
            super.queueEvent((FacesEvent)wrapperEvent);
        } else {
            super.queueEvent(event);
        }
    }

    public GMapInfoWindow getInfoWindow() {
        for (UIComponent kid : this.getChildren()) {
            if (!(kid instanceof GMapInfoWindow)) continue;
            return (GMapInfoWindow)kid;
        }
        return null;
    }

    private boolean isSelfRequest(FacesContext context) {
        return this.getClientId(context).equals(context.getExternalContext().getRequestParameterMap().get("javax.faces.source"));
    }
}

