/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.inplace;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import javax.faces.application.ResourceDependencies;
import javax.faces.application.ResourceDependency;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.event.BehaviorEvent;
import org.primefaces.component.inplace.InplaceBase;
import org.primefaces.util.MapBuilder;

@ResourceDependencies(value={@ResourceDependency(library="primefaces", name="components.css"), @ResourceDependency(library="primefaces", name="jquery/jquery.js"), @ResourceDependency(library="primefaces", name="core.js"), @ResourceDependency(library="primefaces", name="components.js")})
public class Inplace
extends InplaceBase {
    public static final String COMPONENT_TYPE = "org.primefaces.component.Inplace";
    public static final String CONTAINER_CLASS = "ui-inplace ui-hidden-container";
    public static final String DISPLAY_CLASS = "ui-inplace-display";
    public static final String DISABLED_DISPLAY_CLASS = "ui-inplace-display-disabled";
    public static final String CONTENT_CLASS = "ui-inplace-content";
    public static final String EDITOR_CLASS = "ui-inplace-editor";
    public static final String SAVE_BUTTON_CLASS = "ui-inplace-save";
    public static final String CANCEL_BUTTON_CLASS = "ui-inplace-cancel";
    public static final String DISPLAY_INLINE = "inline";
    public static final String DISPLAY_NONE = "none";
    private static final Map<String, Class<? extends BehaviorEvent>> BEHAVIOR_EVENT_MAPPING = MapBuilder.builder().put("save", null).put("cancel", null).build();
    private static final Collection<String> EVENT_NAMES = BEHAVIOR_EVENT_MAPPING.keySet();

    @Override
    public Map<String, Class<? extends BehaviorEvent>> getBehaviorEventMapping() {
        return BEHAVIOR_EVENT_MAPPING;
    }

    public Collection<String> getEventNames() {
        return EVENT_NAMES;
    }

    public void processDecodes(FacesContext context) {
        if (this.shouldSkipChildren(context)) {
            this.decode(context);
        } else {
            super.processDecodes(context);
        }
    }

    public void processValidators(FacesContext context) {
        if (!this.shouldSkipChildren(context)) {
            super.processValidators(context);
        }
    }

    public void processUpdates(FacesContext context) {
        if (!this.shouldSkipChildren(context)) {
            super.processUpdates(context);
        }
    }

    private boolean shouldSkipChildren(FacesContext context) {
        return context.getExternalContext().getRequestParameterMap().containsKey(this.getClientId(context) + "_cancel") || this.isDisabled();
    }

    public boolean isValid() {
        boolean valid = true;
        Iterator it = this.getFacetsAndChildren();
        while (it.hasNext()) {
            UIComponent component = (UIComponent)it.next();
            if (!(component instanceof EditableValueHolder) || ((EditableValueHolder)component).isValid()) continue;
            valid = false;
            break;
        }
        return valid;
    }
}

