/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.panel;

import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import javax.el.ELContext;
import javax.el.ValueExpression;
import javax.faces.application.ResourceDependencies;
import javax.faces.application.ResourceDependency;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.event.AjaxBehaviorEvent;
import javax.faces.event.BehaviorEvent;
import javax.faces.event.FacesEvent;
import org.primefaces.component.menu.Menu;
import org.primefaces.component.panel.PanelBase;
import org.primefaces.event.CloseEvent;
import org.primefaces.event.ToggleEvent;
import org.primefaces.model.Visibility;
import org.primefaces.util.MapBuilder;

@ResourceDependencies(value={@ResourceDependency(library="primefaces", name="components.css"), @ResourceDependency(library="primefaces", name="jquery/jquery.js"), @ResourceDependency(library="primefaces", name="jquery/jquery-plugins.js"), @ResourceDependency(library="primefaces", name="core.js"), @ResourceDependency(library="primefaces", name="components.js")})
public class Panel
extends PanelBase {
    public static final String COMPONENT_TYPE = "org.primefaces.component.Panel";
    public static final String PANEL_CLASS = "ui-panel ui-widget ui-widget-content ui-corner-all";
    public static final String PANEL_TITLEBAR_CLASS = "ui-panel-titlebar ui-widget-header ui-helper-clearfix ui-corner-all";
    public static final String PANEL_TITLE_CLASS = "ui-panel-title";
    public static final String PANEL_TITLE_ICON_CLASS = "ui-panel-titlebar-icon ui-corner-all ui-state-default";
    public static final String PANEL_CONTENT_CLASS = "ui-panel-content ui-widget-content";
    public static final String PANEL_FOOTER_CLASS = "ui-panel-footer ui-widget-content";
    public static final String PANEL_ACTIONS_CLASS = "ui-panel-actions";
    public static final String ARIA_CLOSE = "primefaces.dialog.aria.CLOSE";
    public static final String ARIA_TOGGLE = "primefaces.panel.aria.TOGGLE";
    public static final String ARIA_OPTIONS_MENU = "primefaces.panel.aria.OPTIONS_MENU";
    private static final Map<String, Class<? extends BehaviorEvent>> BEHAVIOR_EVENT_MAPPING = MapBuilder.builder().put("toggle", ToggleEvent.class).put("close", CloseEvent.class).build();
    private static final Collection<String> EVENT_NAMES = BEHAVIOR_EVENT_MAPPING.keySet();
    private Menu optionsMenu;

    @Override
    public Map<String, Class<? extends BehaviorEvent>> getBehaviorEventMapping() {
        return BEHAVIOR_EVENT_MAPPING;
    }

    public Collection<String> getEventNames() {
        return EVENT_NAMES;
    }

    public Menu getOptionsMenu() {
        UIComponent optionsFacet;
        if (this.optionsMenu == null && (optionsFacet = this.getFacet("options")) != null) {
            this.optionsMenu = optionsFacet instanceof Menu ? (Menu)optionsFacet : (Menu)optionsFacet.getChildren().get(0);
        }
        return this.optionsMenu;
    }

    public void queueEvent(FacesEvent event) {
        FacesContext context = this.getFacesContext();
        Map params = context.getExternalContext().getRequestParameterMap();
        String eventName = (String)params.get("javax.faces.behavior.event");
        String clientId = this.getClientId(context);
        if (this.isSelfRequest(context)) {
            AjaxBehaviorEvent behaviorEvent = (AjaxBehaviorEvent)event;
            if (eventName.equals("toggle")) {
                boolean collapsed = Boolean.parseBoolean((String)params.get(clientId + "_collapsed"));
                Visibility visibility = collapsed ? Visibility.HIDDEN : Visibility.VISIBLE;
                ToggleEvent eventToQueue = new ToggleEvent((UIComponent)this, behaviorEvent.getBehavior(), visibility);
                eventToQueue.setPhaseId(behaviorEvent.getPhaseId());
                super.queueEvent((FacesEvent)new ToggleEvent((UIComponent)this, behaviorEvent.getBehavior(), visibility));
            } else if (eventName.equals("close")) {
                CloseEvent eventToQueue = new CloseEvent((UIComponent)this, behaviorEvent.getBehavior());
                eventToQueue.setPhaseId(behaviorEvent.getPhaseId());
                super.queueEvent((FacesEvent)eventToQueue);
            }
        } else {
            super.queueEvent(event);
        }
    }

    public void processDecodes(FacesContext context) {
        if (this.isSelfRequest(context)) {
            this.decode(context);
        } else {
            super.processDecodes(context);
        }
    }

    public void processValidators(FacesContext context) {
        if (!this.isSelfRequest(context)) {
            super.processValidators(context);
        }
    }

    public void processUpdates(FacesContext context) {
        if (!this.isSelfRequest(context)) {
            super.processUpdates(context);
        }
        FacesContext facesContext = this.getFacesContext();
        ELContext eLContext = facesContext.getELContext();
        ValueExpression collapsedVE = this.getValueExpression(PanelBase.PropertyKeys.collapsed.toString());
        if (collapsedVE != null && !collapsedVE.isReadOnly(eLContext)) {
            collapsedVE.setValue(eLContext, (Object)this.isCollapsed());
            this.getStateHelper().put((Serializable)((Object)PanelBase.PropertyKeys.collapsed), null);
        }
    }

    private boolean isSelfRequest(FacesContext context) {
        return this.getClientId(context).equals(context.getExternalContext().getRequestParameterMap().get("javax.faces.source"));
    }
}

