/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.slider;

import java.util.Collection;
import java.util.Map;
import javax.faces.application.FacesMessage;
import javax.faces.application.ResourceDependencies;
import javax.faces.application.ResourceDependency;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.event.AjaxBehaviorEvent;
import javax.faces.event.BehaviorEvent;
import javax.faces.event.FacesEvent;
import org.primefaces.component.slider.SliderBase;
import org.primefaces.event.SlideEndEvent;
import org.primefaces.expression.SearchExpressionFacade;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.LangUtils;
import org.primefaces.util.MapBuilder;
import org.primefaces.util.MessageFactory;

@ResourceDependencies(value={@ResourceDependency(library="primefaces", name="components.css"), @ResourceDependency(library="primefaces", name="jquery/jquery.js"), @ResourceDependency(library="primefaces", name="jquery/jquery-plugins.js"), @ResourceDependency(library="primefaces", name="core.js"), @ResourceDependency(library="primefaces", name="components.js")})
public class Slider
extends SliderBase {
    public static final String COMPONENT_TYPE = "org.primefaces.component.Slider";
    public static final String VALUE_OUT_OF_RANGE = "primefaces.slider.OUT_OF_RANGE";
    private static final String DEFAULT_EVENT = "slideEnd";
    private static final Map<String, Class<? extends BehaviorEvent>> BEHAVIOR_EVENT_MAPPING = MapBuilder.builder().put("slideEnd", SlideEndEvent.class).build();
    private static final Collection<String> EVENT_NAMES = BEHAVIOR_EVENT_MAPPING.keySet();

    @Override
    public Map<String, Class<? extends BehaviorEvent>> getBehaviorEventMapping() {
        return BEHAVIOR_EVENT_MAPPING;
    }

    public Collection<String> getEventNames() {
        return EVENT_NAMES;
    }

    public String getDefaultEventName() {
        return DEFAULT_EVENT;
    }

    public void queueEvent(FacesEvent event) {
        FacesContext context = this.getFacesContext();
        if (ComponentUtils.isRequestSource((UIComponent)this, context)) {
            Map params = context.getExternalContext().getRequestParameterMap();
            String eventName = (String)params.get("javax.faces.behavior.event");
            String clientId = this.getClientId(context);
            AjaxBehaviorEvent behaviorEvent = (AjaxBehaviorEvent)event;
            if (eventName.equals(DEFAULT_EVENT)) {
                double sliderValue = Double.parseDouble((String)params.get(clientId + "_slideValue"));
                SlideEndEvent slideEndEvent = new SlideEndEvent((UIComponent)this, behaviorEvent.getBehavior(), sliderValue);
                slideEndEvent.setPhaseId(behaviorEvent.getPhaseId());
                super.queueEvent((FacesEvent)slideEndEvent);
            }
        } else {
            super.queueEvent(event);
        }
    }

    public void validate(FacesContext context) {
        super.validate(context);
        if (!this.isValid()) {
            return;
        }
        String[] inputIds = this.getFor().split(",");
        if (this.isRange()) {
            UIInput inputFrom = (UIInput)SearchExpressionFacade.resolveComponent(context, (UIComponent)this, inputIds[0].trim());
            UIInput inputTo = (UIInput)SearchExpressionFacade.resolveComponent(context, (UIComponent)this, inputIds[1].trim());
            String valueFromStr = this.getSubmittedValue(inputFrom).toString();
            String valueToStr = this.getSubmittedValue(inputTo).toString();
            double valueFrom = Double.valueOf(valueFromStr);
            double valueTo = Double.valueOf(valueToStr);
            if (valueTo < valueFrom) {
                this.setValid(false);
                inputFrom.setValid(false);
                inputTo.setValid(false);
            } else {
                if (valueFrom < this.getMinValue() || valueFrom > this.getMaxValue()) {
                    this.setValid(false);
                    inputFrom.setValid(false);
                }
                if (valueTo > this.getMaxValue() || valueTo < this.getMinValue()) {
                    this.setValid(false);
                    inputTo.setValid(false);
                }
            }
        } else {
            UIInput input = (UIInput)SearchExpressionFacade.resolveComponent(context, (UIComponent)this, inputIds[0].trim());
            Object submittedValue = this.getSubmittedValue(input);
            if (submittedValue == null) {
                return;
            }
            String submittedValueString = submittedValue.toString();
            if (LangUtils.isValueBlank(submittedValueString)) {
                return;
            }
            double submittedValueDouble = Double.valueOf(submittedValueString);
            if (submittedValueDouble < this.getMinValue() || submittedValueDouble > this.getMaxValue()) {
                this.setValid(false);
                input.setValid(false);
            }
        }
        if (!this.isValid()) {
            String validatorMessage = this.getValidatorMessage();
            FacesMessage msg = null;
            msg = validatorMessage != null ? new FacesMessage(FacesMessage.SEVERITY_ERROR, validatorMessage, validatorMessage) : MessageFactory.getMessage(VALUE_OUT_OF_RANGE, FacesMessage.SEVERITY_ERROR, null);
            context.addMessage(this.getClientId(context), msg);
        }
    }

    private Object getSubmittedValue(UIInput input) {
        return input.getSubmittedValue() == null && input.isLocalValueSet() ? input.getValue() : input.getSubmittedValue();
    }
}

