/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.tabview;

import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import javax.el.ValueExpression;
import javax.faces.application.ResourceDependencies;
import javax.faces.application.ResourceDependency;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.event.AjaxBehaviorEvent;
import javax.faces.event.BehaviorEvent;
import javax.faces.event.FacesEvent;
import org.primefaces.component.tabview.Tab;
import org.primefaces.component.tabview.TabViewBase;
import org.primefaces.event.TabChangeEvent;
import org.primefaces.event.TabCloseEvent;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.MapBuilder;

@ResourceDependencies(value={@ResourceDependency(library="primefaces", name="components.css"), @ResourceDependency(library="primefaces", name="jquery/jquery.js"), @ResourceDependency(library="primefaces", name="jquery/jquery-plugins.js"), @ResourceDependency(library="primefaces", name="core.js"), @ResourceDependency(library="primefaces", name="components.js")})
public class TabView
extends TabViewBase {
    public static final String COMPONENT_TYPE = "org.primefaces.component.TabView";
    public static final String CONTAINER_CLASS = "ui-tabs ui-widget ui-widget-content ui-corner-all ui-hidden-container";
    public static final String NAVIGATOR_CLASS = "ui-tabs-nav ui-helper-reset ui-widget-header ui-corner-all";
    public static final String INACTIVE_TAB_HEADER_CLASS = "ui-tabs-header ui-state-default";
    public static final String ACTIVE_TAB_HEADER_CLASS = "ui-tabs-header ui-state-default ui-tabs-selected ui-state-active";
    public static final String PANELS_CLASS = "ui-tabs-panels";
    public static final String ACTIVE_TAB_CONTENT_CLASS = "ui-tabs-panel ui-widget-content ui-corner-bottom";
    public static final String INACTIVE_TAB_CONTENT_CLASS = "ui-tabs-panel ui-widget-content ui-corner-bottom ui-helper-hidden";
    public static final String NAVIGATOR_SCROLLER_CLASS = "ui-tabs-navscroller";
    public static final String NAVIGATOR_LEFT_CLASS = "ui-tabs-navscroller-btn ui-tabs-navscroller-btn-left ui-state-default ui-corner-right";
    public static final String NAVIGATOR_RIGHT_CLASS = "ui-tabs-navscroller-btn ui-tabs-navscroller-btn-right ui-state-default ui-corner-left";
    public static final String NAVIGATOR_LEFT_ICON_CLASS = "ui-icon ui-icon-carat-1-w";
    public static final String NAVIGATOR_RIGHT_ICON_CLASS = "ui-icon ui-icon-carat-1-e";
    public static final String SCROLLABLE_TABS_CLASS = "ui-tabs-scrollable";
    private static final Map<String, Class<? extends BehaviorEvent>> BEHAVIOR_EVENT_MAPPING = MapBuilder.builder().put("tabChange", TabChangeEvent.class).put("tabClose", TabCloseEvent.class).build();
    private static final Collection<String> EVENT_NAMES = BEHAVIOR_EVENT_MAPPING.keySet();

    @Override
    public Map<String, Class<? extends BehaviorEvent>> getBehaviorEventMapping() {
        return BEHAVIOR_EVENT_MAPPING;
    }

    public Collection<String> getEventNames() {
        return EVENT_NAMES;
    }

    public boolean isContentLoadRequest(FacesContext context) {
        return context.getExternalContext().getRequestParameterMap().containsKey(this.getClientId(context) + "_contentLoad");
    }

    public Tab findTab(String tabClientId) {
        for (UIComponent component : this.getChildren()) {
            if (!component.getClientId().equals(tabClientId)) continue;
            return (Tab)component;
        }
        return null;
    }

    @Override
    public void queueEvent(FacesEvent event) {
        FacesContext context = this.getFacesContext();
        if (ComponentUtils.isRequestSource((UIComponent)this, context) && event instanceof AjaxBehaviorEvent) {
            Map params = context.getExternalContext().getRequestParameterMap();
            String eventName = (String)params.get("javax.faces.behavior.event");
            String clientId = this.getClientId(context);
            boolean repeating = this.isRepeating();
            AjaxBehaviorEvent behaviorEvent = (AjaxBehaviorEvent)event;
            if (eventName.equals("tabChange")) {
                String tabClientId = (String)params.get(clientId + "_newTab");
                TabChangeEvent changeEvent = new TabChangeEvent((UIComponent)this, behaviorEvent.getBehavior(), this.findTab(tabClientId));
                if (repeating) {
                    int tabindex = Integer.parseInt((String)params.get(clientId + "_tabindex"));
                    this.setIndex(tabindex);
                    changeEvent.setData(this.getIndexData());
                    changeEvent.setTab((Tab)((Object)this.getChildren().get(0)));
                }
                changeEvent.setPhaseId(behaviorEvent.getPhaseId());
                super.queueEvent((FacesEvent)changeEvent);
                if (repeating) {
                    this.setIndex(-1);
                }
            } else if (eventName.equals("tabClose")) {
                String tabClientId = (String)params.get(clientId + "_closeTab");
                TabCloseEvent closeEvent = new TabCloseEvent((UIComponent)this, behaviorEvent.getBehavior(), this.findTab(tabClientId));
                if (repeating) {
                    int tabindex = Integer.parseInt((String)params.get(clientId + "_tabindex"));
                    this.setIndex(tabindex);
                    closeEvent.setData(this.getIndexData());
                    closeEvent.setTab((Tab)((Object)this.getChildren().get(0)));
                }
                closeEvent.setPhaseId(behaviorEvent.getPhaseId());
                super.queueEvent((FacesEvent)closeEvent);
                if (repeating) {
                    this.setIndex(-1);
                }
            }
        } else {
            super.queueEvent(event);
        }
    }

    protected void resetActiveIndex() {
        this.getStateHelper().remove((Serializable)((Object)TabViewBase.PropertyKeys.activeIndex));
    }

    @Override
    public void processUpdates(FacesContext context) {
        if (!this.isRendered()) {
            return;
        }
        super.processUpdates(context);
        ValueExpression expr = this.getValueExpression(TabViewBase.PropertyKeys.activeIndex.toString());
        if (expr != null) {
            expr.setValue(this.getFacesContext().getELContext(), (Object)this.getActiveIndex());
            this.resetActiveIndex();
        }
    }
}

