/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.tabview;

import java.io.IOException;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.tabview.Tab;
import org.primefaces.component.tabview.TabView;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.LangUtils;
import org.primefaces.util.WidgetBuilder;

public class TabViewRenderer
extends CoreRenderer {
    public void decode(FacesContext context, UIComponent component) {
        TabView tabView;
        Map params = context.getExternalContext().getRequestParameterMap();
        String activeIndexValue = (String)params.get((tabView = (TabView)component).getClientId(context) + "_activeIndex");
        if (!LangUtils.isValueBlank(activeIndexValue)) {
            tabView.setActiveIndex(Integer.parseInt(activeIndexValue));
        }
        this.decodeBehaviors(context, component);
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        Map params = context.getExternalContext().getRequestParameterMap();
        TabView tabView = (TabView)component;
        String clientId = tabView.getClientId(context);
        String var = tabView.getVar();
        if (tabView.isContentLoadRequest(context)) {
            Tab tabToLoad = null;
            if (var == null) {
                String tabClientId = (String)params.get(clientId + "_newTab");
                tabToLoad = tabView.findTab(tabClientId);
                tabToLoad.encodeAll(context);
                tabToLoad.setLoaded(true);
            } else {
                int tabindex = Integer.parseInt((String)params.get(clientId + "_tabindex"));
                tabView.setIndex(tabindex);
                tabToLoad = (Tab)((Object)tabView.getChildren().get(0));
                tabToLoad.encodeAll(context);
                tabView.setIndex(-1);
            }
        } else {
            tabView.resetLoadedTabsState();
            this.encodeMarkup(context, tabView);
            this.encodeScript(context, tabView);
        }
    }

    protected void encodeScript(FacesContext context, TabView tabView) throws IOException {
        String clientId = tabView.getClientId(context);
        boolean dynamic = tabView.isDynamic();
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.init("TabView", tabView.resolveWidgetVar(), clientId);
        if (dynamic) {
            wb.attr("dynamic", true).attr("cache", tabView.isCache());
        }
        wb.callback("onTabChange", "function(index)", tabView.getOnTabChange()).callback("onTabShow", "function(index)", tabView.getOnTabShow()).callback("onTabClose", "function(index)", tabView.getOnTabClose());
        wb.attr("effect", tabView.getEffect(), null).attr("effectDuration", tabView.getEffectDuration(), null).attr("scrollable", tabView.isScrollable()).attr("tabindex", tabView.getTabindex(), null);
        this.encodeClientBehaviors(context, tabView);
        wb.finish();
    }

    protected void encodeMarkup(FacesContext context, TabView tabView) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = tabView.getClientId(context);
        String widgetVar = tabView.resolveWidgetVar();
        String orientation = tabView.getOrientation();
        String styleClass = tabView.getStyleClass();
        String defaultStyleClass = "ui-tabs ui-widget ui-widget-content ui-corner-all ui-hidden-container ui-tabs-" + orientation;
        if (tabView.isScrollable()) {
            defaultStyleClass = defaultStyleClass + " " + "ui-tabs-scrollable";
        }
        String string = styleClass = styleClass == null ? defaultStyleClass : defaultStyleClass + " " + styleClass;
        if (ComponentUtils.isRTL(context, tabView)) {
            styleClass = styleClass + " ui-tabs-rtl";
        }
        writer.startElement("div", (UIComponent)tabView);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.writeAttribute("class", (Object)styleClass, "styleClass");
        if (tabView.getStyle() != null) {
            writer.writeAttribute("style", (Object)tabView.getStyle(), "style");
        }
        writer.writeAttribute("data-widget", (Object)widgetVar, null);
        if (orientation.equals("bottom")) {
            this.encodeContents(context, tabView);
            this.encodeHeaders(context, tabView);
        } else {
            this.encodeHeaders(context, tabView);
            this.encodeContents(context, tabView);
        }
        this.encodeStateHolder(context, tabView, clientId + "_activeIndex", String.valueOf(tabView.getActiveIndex()));
        if (tabView.isScrollable()) {
            String scrollParam = clientId + "_scrollState";
            String scrollState = (String)context.getExternalContext().getRequestParameterMap().get(scrollParam);
            String scrollValue = scrollState == null ? "0" : scrollState;
            this.encodeStateHolder(context, tabView, scrollParam, scrollValue);
        }
        writer.endElement("div");
    }

    protected void encodeStateHolder(FacesContext facesContext, TabView tabView, String name, String value) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.startElement("input", null);
        writer.writeAttribute("type", (Object)"hidden", null);
        writer.writeAttribute("id", (Object)name, null);
        writer.writeAttribute("name", (Object)name, null);
        writer.writeAttribute("value", (Object)value, null);
        writer.writeAttribute("autocomplete", (Object)"off", null);
        writer.endElement("input");
    }

    protected void encodeHeaders(FacesContext context, TabView tabView) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String var = tabView.getVar();
        int activeIndex = tabView.getActiveIndex();
        boolean scrollable = tabView.isScrollable();
        if (scrollable) {
            writer.startElement("div", null);
            writer.writeAttribute("class", (Object)"ui-tabs-navscroller", null);
            this.encodeScrollerButton(context, tabView, "ui-tabs-navscroller-btn ui-tabs-navscroller-btn-left ui-state-default ui-corner-right", "ui-icon ui-icon-carat-1-w");
            this.encodeScrollerButton(context, tabView, "ui-tabs-navscroller-btn ui-tabs-navscroller-btn-right ui-state-default ui-corner-left", "ui-icon ui-icon-carat-1-e");
        }
        writer.startElement("ul", null);
        writer.writeAttribute("class", (Object)"ui-tabs-nav ui-helper-reset ui-widget-header ui-corner-all", null);
        writer.writeAttribute("role", (Object)"tablist", null);
        if (var == null) {
            int j = 0;
            for (int i = 0; i < tabView.getChildCount(); ++i) {
                UIComponent child = (UIComponent)tabView.getChildren().get(i);
                if (!child.isRendered() || !(child instanceof Tab)) continue;
                this.encodeTabHeader(context, tabView, (Tab)child, j, j == activeIndex);
                ++j;
            }
        } else {
            int dataCount = tabView.getRowCount();
            activeIndex = activeIndex >= dataCount ? 0 : activeIndex;
            Tab tab = (Tab)((Object)tabView.getChildren().get(0));
            for (int i = 0; i < dataCount; ++i) {
                tabView.setIndex(i);
                this.encodeTabHeader(context, tabView, tab, i, i == activeIndex);
            }
            tabView.setIndex(-1);
        }
        writer.endElement("ul");
        if (scrollable) {
            writer.endElement("div");
        }
    }

    protected void encodeTabHeader(FacesContext context, TabView tabView, Tab tab, int index, boolean active) throws IOException {
        UIComponent actions;
        String styleClass;
        ResponseWriter writer = context.getResponseWriter();
        String defaultStyleClass = active ? "ui-tabs-header ui-state-default ui-tabs-selected ui-state-active" : "ui-tabs-header ui-state-default";
        defaultStyleClass = defaultStyleClass + " ui-corner-" + tabView.getOrientation();
        if (tab.isDisabled()) {
            defaultStyleClass = defaultStyleClass + " ui-state-disabled";
        }
        styleClass = (styleClass = tab.getTitleStyleClass()) == null ? defaultStyleClass : defaultStyleClass + " " + styleClass;
        UIComponent titleFacet = tab.getFacet("title");
        String tabindex = tab.isDisabled() ? "-1" : tabView.getTabindex();
        writer.startElement("li", (UIComponent)tab);
        writer.writeAttribute("class", (Object)styleClass, null);
        writer.writeAttribute("role", (Object)"tab", null);
        writer.writeAttribute("aria-expanded", (Object)String.valueOf(active), null);
        writer.writeAttribute("aria-selected", (Object)String.valueOf(active), null);
        writer.writeAttribute("aria-label", (Object)tab.getAriaLabel(), null);
        writer.writeAttribute("data-index", (Object)index, null);
        if (tab.getTitleStyle() != null) {
            writer.writeAttribute("style", (Object)tab.getTitleStyle(), null);
        }
        if (tab.getTitletip() != null) {
            writer.writeAttribute("title", (Object)tab.getTitletip(), null);
        }
        if (tabindex != null) {
            writer.writeAttribute("tabindex", (Object)tabindex, null);
        }
        writer.startElement("a", null);
        writer.writeAttribute("href", (Object)("#" + tab.getClientId(context)), null);
        writer.writeAttribute("tabindex", (Object)"-1", null);
        if (titleFacet == null) {
            String tabTitle = tab.getTitle();
            if (tabTitle != null) {
                writer.writeText((Object)tabTitle, null);
            }
        } else {
            titleFacet.encodeAll(context);
        }
        writer.endElement("a");
        if (tab.isClosable()) {
            writer.startElement("span", null);
            writer.writeAttribute("class", (Object)"ui-icon ui-icon-close", null);
            writer.endElement("span");
        }
        if ((actions = tab.getFacet("actions")) != null && actions.isRendered()) {
            writer.startElement("li", null);
            writer.writeAttribute("class", (Object)"ui-tabs-actions", null);
            writer.writeAttribute("aria-hidden", (Object)String.valueOf(!active), null);
            actions.encodeAll(context);
            writer.endElement("li");
        }
        writer.endElement("li");
    }

    protected void encodeContents(FacesContext context, TabView tabView) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String var = tabView.getVar();
        int activeIndex = tabView.getActiveIndex();
        boolean dynamic = tabView.isDynamic();
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"ui-tabs-panels", null);
        if (var == null) {
            int j = 0;
            for (int i = 0; i < tabView.getChildCount(); ++i) {
                UIComponent child = (UIComponent)tabView.getChildren().get(i);
                if (!child.isRendered() || !(child instanceof Tab)) continue;
                this.encodeTabContent(context, (Tab)child, j, j == activeIndex, dynamic);
                ++j;
            }
        } else {
            int dataCount = tabView.getRowCount();
            activeIndex = activeIndex >= dataCount ? 0 : activeIndex;
            Tab tab = (Tab)((Object)tabView.getChildren().get(0));
            for (int i = 0; i < dataCount; ++i) {
                tabView.setIndex(i);
                this.encodeTabContent(context, tab, i, i == activeIndex, dynamic);
            }
            tabView.setIndex(-1);
        }
        writer.endElement("div");
    }

    protected void encodeTabContent(FacesContext context, Tab tab, int index, boolean active, boolean dynamic) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String styleClass = active ? "ui-tabs-panel ui-widget-content ui-corner-bottom" : "ui-tabs-panel ui-widget-content ui-corner-bottom ui-helper-hidden";
        writer.startElement("div", null);
        writer.writeAttribute("id", (Object)tab.getClientId(context), null);
        writer.writeAttribute("class", (Object)styleClass, null);
        writer.writeAttribute("role", (Object)"tabpanel", null);
        writer.writeAttribute("aria-hidden", (Object)String.valueOf(!active), null);
        writer.writeAttribute("data-index", (Object)index, null);
        if (dynamic) {
            if (active) {
                tab.encodeAll(context);
                tab.setLoaded(true);
            }
        } else {
            tab.encodeAll(context);
        }
        writer.endElement("div");
    }

    protected void encodeScrollerButton(FacesContext context, TabView tabView, String styleClass, String iconClass) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("a", null);
        writer.writeAttribute("class", (Object)styleClass, null);
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)iconClass, null);
        writer.endElement("span");
        writer.endElement("a");
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }
}

