/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.timeline;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import org.primefaces.PrimeFaces;
import org.primefaces.component.timeline.Timeline;
import org.primefaces.component.timeline.TimelineRenderer;
import org.primefaces.component.timeline.TimelineUpdater;
import org.primefaces.model.timeline.TimelineEvent;
import org.primefaces.model.timeline.TimelineGroup;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.FastStringWriter;

public class DefaultTimelineUpdater
extends TimelineUpdater
implements PhaseListener {
    private static final long serialVersionUID = 20130317L;
    private static final String PREVENT_RENDER = Boolean.TRUE.toString();
    private static final Logger LOGGER = Logger.getLogger(DefaultTimelineUpdater.class.getName());
    private String widgetVar;
    private List<CrudOperationData> crudOperationDatas;

    @Override
    public void add(TimelineEvent event) {
        if (event == null) {
            return;
        }
        this.checkCrudOperationDataList();
        this.crudOperationDatas.add(new CrudOperationData(CrudOperation.ADD, event));
    }

    @Override
    public void update(TimelineEvent event, int index) {
        if (event == null) {
            return;
        }
        this.checkCrudOperationDataList();
        this.crudOperationDatas.add(new CrudOperationData(CrudOperation.UPDATE, event, index));
    }

    @Override
    public void delete(int index) {
        this.checkCrudOperationDataList();
        this.crudOperationDatas.add(new CrudOperationData(CrudOperation.DELETE, index));
    }

    @Override
    public void select(int index) {
        this.checkCrudOperationDataList();
        this.crudOperationDatas.add(new CrudOperationData(CrudOperation.SELECT, index));
    }

    @Override
    public void clear() {
        this.checkCrudOperationDataList();
        this.crudOperationDatas.add(new CrudOperationData(CrudOperation.CLEAR));
    }

    public PhaseId getPhaseId() {
        return PhaseId.RENDER_RESPONSE;
    }

    public void beforePhase(PhaseEvent event) {
        if (this.crudOperationDatas == null) {
            return;
        }
        FacesContext fc = event.getFacesContext();
        StringBuilder sb = new StringBuilder();
        Timeline timeline = (Timeline)fc.getViewRoot().findComponent(this.id);
        TimelineRenderer timelineRenderer = ComponentUtils.getUnwrappedRenderer(fc, "org.primefaces.component", "org.primefaces.component.TimelineRenderer", TimelineRenderer.class);
        HashMap<String, String> groupsContent = null;
        List<TimelineGroup> groups = timeline.getValue().getGroups();
        UIComponent groupFacet = timeline.getFacet("group");
        if (groups != null && groupFacet != null) {
            groupsContent = new HashMap<String, String>();
        }
        TimeZone targetTZ = ComponentUtils.resolveTimeZone(timeline.getTimeZone());
        TimeZone browserTZ = ComponentUtils.resolveTimeZone(timeline.getBrowserTimeZone());
        try (FastStringWriter fsw = new FastStringWriter();
             FastStringWriter fswHtml = new FastStringWriter();){
            boolean renderComponent = false;
            for (CrudOperationData crudOperationData : this.crudOperationDatas) {
                switch (crudOperationData.getCrudOperation()) {
                    case ADD: {
                        sb.append(";PF('");
                        sb.append(this.widgetVar);
                        sb.append("').addEvent(");
                        sb.append(timelineRenderer.encodeEvent(fc, fsw, fswHtml, timeline, browserTZ, targetTZ, groups, groupFacet, groupsContent, crudOperationData.getEvent()));
                        sb.append(", " + PREVENT_RENDER + ")");
                        renderComponent = true;
                        break;
                    }
                    case UPDATE: {
                        sb.append(";PF('");
                        sb.append(this.widgetVar);
                        sb.append("').changeEvent(");
                        sb.append(crudOperationData.getIndex());
                        sb.append(",");
                        sb.append(timelineRenderer.encodeEvent(fc, fsw, fswHtml, timeline, browserTZ, targetTZ, groups, groupFacet, groupsContent, crudOperationData.getEvent()));
                        sb.append(", " + PREVENT_RENDER + ")");
                        renderComponent = true;
                        break;
                    }
                    case DELETE: {
                        sb.append(";PF('");
                        sb.append(this.widgetVar);
                        sb.append("').deleteEvent(");
                        sb.append(crudOperationData.getIndex());
                        sb.append(", " + PREVENT_RENDER + ")");
                        renderComponent = true;
                        break;
                    }
                    case SELECT: {
                        sb.append(";PF('");
                        sb.append(this.widgetVar);
                        sb.append("').setSelection(");
                        sb.append(crudOperationData.getIndex());
                        sb.append(")");
                        break;
                    }
                    case CLEAR: {
                        sb.append(";PF('");
                        sb.append(this.widgetVar);
                        sb.append("').deleteAllEvents()");
                    }
                }
            }
            if (renderComponent) {
                sb.append(";PF('");
                sb.append(this.widgetVar);
                sb.append("').renderTimeline()");
            }
            PrimeFaces.current().executeScript(sb.toString());
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Timeline with id " + this.id + " could not be updated, at least one CRUD operation failed", e);
        }
    }

    public void afterPhase(PhaseEvent event) {
    }

    public String getWidgetVar() {
        return this.widgetVar;
    }

    public void setWidgetVar(String widgetVar) {
        this.widgetVar = widgetVar;
    }

    private void checkCrudOperationDataList() {
        if (this.crudOperationDatas == null) {
            this.crudOperationDatas = new ArrayList<CrudOperationData>();
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultTimelineUpdater that = (DefaultTimelineUpdater)o;
        return !(this.widgetVar != null ? !this.widgetVar.equals(that.widgetVar) : that.widgetVar != null);
    }

    public int hashCode() {
        return this.widgetVar != null ? this.widgetVar.hashCode() : 0;
    }

    class CrudOperationData
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final CrudOperation crudOperation;
        private TimelineEvent event;
        private int index;

        CrudOperationData(CrudOperation crudOperation) {
            this.crudOperation = crudOperation;
        }

        CrudOperationData(CrudOperation crudOperation, TimelineEvent event) {
            this.crudOperation = crudOperation;
            this.event = event;
        }

        CrudOperationData(CrudOperation crudOperation, int index) {
            this.crudOperation = crudOperation;
            this.index = index;
        }

        CrudOperationData(CrudOperation crudOperation, TimelineEvent event, int index) {
            this.crudOperation = crudOperation;
            this.event = event;
            this.index = index;
        }

        public CrudOperation getCrudOperation() {
            return this.crudOperation;
        }

        public TimelineEvent getEvent() {
            return this.event;
        }

        public int getIndex() {
            return this.index;
        }
    }

    static enum CrudOperation {
        ADD,
        UPDATE,
        DELETE,
        SELECT,
        CLEAR;

    }
}

