/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.tree;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.component.UINamingContainer;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.PrimeFaces;
import org.primefaces.component.tree.Tree;
import org.primefaces.component.tree.TreeBase;
import org.primefaces.component.tree.UITreeNode;
import org.primefaces.model.TreeNode;
import org.primefaces.model.filter.FilterConstraint;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.renderkit.RendererUtils;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.LangUtils;
import org.primefaces.util.SharedStringBuilder;
import org.primefaces.util.WidgetBuilder;

public class TreeRenderer
extends CoreRenderer {
    private static final String SB_DECODE_SELECTION = TreeRenderer.class.getName() + "#decodeSelection";

    public void decode(FacesContext context, UIComponent component) {
        Tree tree = (Tree)component;
        if (tree.isDragDropRequest(context)) {
            this.decodeDragDrop(context, tree);
        }
        if (tree.getSelectionMode() != null) {
            this.decodeSelection(context, tree);
        }
        this.decodeBehaviors(context, (UIComponent)tree);
    }

    public void decodeSelection(FacesContext context, Tree tree) {
        Map params = context.getExternalContext().getRequestParameterMap();
        String clientId = tree.getClientId(context);
        String selection = (String)params.get(clientId + "_selection");
        boolean isSingle = tree.getSelectionMode().equalsIgnoreCase("single");
        if (this.isValueBlank(selection)) {
            if (isSingle) {
                tree.setSelection(null);
            } else {
                tree.setSelection(new TreeNode[0]);
            }
        } else {
            String[] selectedRowKeys = selection.split(",");
            if (isSingle) {
                tree.setRowKey(selectedRowKeys[0]);
                tree.setSelection(tree.getRowNode());
            } else {
                ArrayList<TreeNode> selectedNodes = new ArrayList<TreeNode>();
                for (int i = 0; i < selectedRowKeys.length; ++i) {
                    tree.setRowKey(selectedRowKeys[i]);
                    TreeNode rowNode = tree.getRowNode();
                    if (rowNode == null) continue;
                    selectedNodes.add(rowNode);
                }
                tree.setSelection(selectedNodes.toArray(new TreeNode[selectedNodes.size()]));
            }
            tree.setRowKey(null);
        }
        if (tree.isCheckboxSelection() && tree.isDynamic() && tree.isSelectionRequest(context) && tree.isPropagateSelectionDown()) {
            String selectedNodeRowKey = (String)params.get(clientId + "_instantSelection");
            tree.setRowKey(selectedNodeRowKey);
            TreeNode selectedNode = tree.getRowNode();
            ArrayList<String> descendantRowKeys = new ArrayList<String>();
            tree.populateRowKeys(selectedNode, descendantRowKeys);
            int size = descendantRowKeys.size();
            StringBuilder sb = SharedStringBuilder.get(context, SB_DECODE_SELECTION);
            for (int i = 0; i < size; ++i) {
                sb.append((String)descendantRowKeys.get(i));
                if (i == size - 1) continue;
                sb.append(",");
            }
            PrimeFaces.current().ajax().addCallbackParam("descendantRowKeys", sb.toString());
            sb.setLength(0);
            descendantRowKeys = null;
        }
    }

    public void decodeDragDrop(FacesContext context, Tree tree) {
        TreeNode dropNode;
        Map params = context.getExternalContext().getRequestParameterMap();
        String clientId = tree.getClientId(context);
        String dragNodeRowKey = (String)params.get(clientId + "_dragNode");
        String dropNodeRowKey = (String)params.get(clientId + "_dropNode");
        String dragSource = (String)params.get(clientId + "_dragSource");
        int dndIndex = Integer.parseInt((String)params.get(clientId + "_dndIndex"));
        boolean isDroppedNodeCopy = Boolean.parseBoolean((String)params.get(clientId + "_isDroppedNodeCopy"));
        String[] dragNodeRowKeyArr = dragNodeRowKey.split(",");
        ArrayList<TreeNode> dragNodeList = new ArrayList<TreeNode>();
        for (String rowKey : dragNodeRowKeyArr) {
            if (dragSource.equals(clientId)) {
                tree.setRowKey(rowKey);
                dragNodeList.add(tree.getRowNode());
                continue;
            }
            Tree otherTree = (Tree)tree.findComponent(":" + dragSource);
            otherTree.setRowKey(rowKey);
            dragNodeList.add(otherTree.getRowNode());
        }
        if (this.isValueBlank(dropNodeRowKey)) {
            dropNode = tree.getValue();
        } else {
            tree.setRowKey(dropNodeRowKey);
            dropNode = tree.getRowNode();
        }
        tree.setDropNode(dropNode);
        TreeNode[] dragNodes = new TreeNode[dragNodeList.size()];
        dragNodes = dragNodeList.toArray(dragNodes);
        if (tree.isMultipleDrag()) {
            tree.setDragNodes(dragNodes);
        } else {
            tree.setDragNode(dragNodes[0]);
        }
        if (!tree.isTreeNodeDropped()) {
            return;
        }
        List<TreeNode> dropNodeChildren = dropNode.getChildren();
        if (tree.isMultipleDrag()) {
            for (TreeNode dragNode : dragNodes) {
                dropNodeChildren.remove(dragNode);
            }
        }
        for (TreeNode dragNode : dragNodes) {
            if (isDroppedNodeCopy) {
                dragNode = tree.createCopyOfTreeNode(dragNode);
            }
            if (dndIndex >= 0 && dndIndex < dropNode.getChildCount()) {
                dropNodeChildren.add(dndIndex, dragNode);
                continue;
            }
            dropNodeChildren.add(dragNode);
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        Tree tree = (Tree)component;
        if (tree.isNodeExpandRequest(context)) {
            boolean vertical = tree.getOrientation().equals("vertical");
            String clientId = tree.getClientId(context);
            Map params = context.getExternalContext().getRequestParameterMap();
            String rowKey = (String)params.get(clientId + "_expandNode");
            if (!vertical && rowKey.equals("root")) {
                this.encodeHorizontalTreeNodeChildren(context, tree, tree.getValue(), tree.getClientId(context), null, tree.isDynamic(), tree.isCheckboxSelection());
            } else {
                tree.setRowKey(rowKey);
                TreeNode node = tree.getRowNode();
                node.setExpanded(true);
                if (vertical) {
                    this.encodeTreeNodeChildren(context, tree, node, clientId, tree.isDynamic(), tree.isCheckboxSelection(), tree.isDroppable());
                } else {
                    this.encodeHorizontalTreeNodeChildren(context, tree, node, tree.getClientId(context), rowKey, tree.isDynamic(), tree.isCheckboxSelection());
                }
                tree.setRowKey(null);
            }
        } else if (tree.isFilterRequest(context)) {
            String clientId = tree.getClientId();
            Map params = context.getExternalContext().getRequestParameterMap();
            String filteredValue = (String)params.get(clientId + "_filter");
            Locale filterLocale = context.getViewRoot().getLocale();
            tree.getFilteredRowKeys().clear();
            this.encodeFilteredNodes(context, tree, tree.getValue(), filteredValue, filterLocale);
            TreeNode root = tree.getValue();
            if (root != null && root.getRowKey() == null) {
                root.setRowKey("root");
                tree.buildRowKeys(root);
                tree.initPreselection();
            }
            if (root != null && (LangUtils.isValueBlank(filteredValue) || tree.getFilteredRowKeys().size() > 0)) {
                this.encodeTreeNodeChildren(context, tree, root, clientId, tree.isDynamic(), tree.isCheckboxSelection(), tree.isDroppable());
            }
        } else {
            this.encodeMarkup(context, tree);
            this.encodeScript(context, tree);
        }
    }

    protected void encodeFilteredNodes(FacesContext context, Tree tree, TreeNode node, String filteredValue, Locale filterLocale) throws IOException {
        int childCount = node.getChildCount();
        if (childCount > 0) {
            String var = tree.getVar();
            Map requestMap = context.getExternalContext().getRequestMap();
            ValueExpression filterByVE = tree.getValueExpression(TreeBase.PropertyKeys.filterBy.toString());
            FilterConstraint filterConstraint = this.getFilterConstraint(tree);
            for (int i = 0; i < childCount; ++i) {
                TreeNode childNode = node.getChildren().get(i);
                requestMap.put(var, childNode.getData());
                if (filterConstraint.applies(filterByVE.getValue(context.getELContext()), filteredValue, filterLocale)) {
                    tree.getFilteredRowKeys().add(childNode.getRowKey());
                }
                this.encodeFilteredNodes(context, tree, childNode, filteredValue, filterLocale);
            }
            requestMap.remove(var);
        }
    }

    protected void encodeScript(FacesContext context, Tree tree) throws IOException {
        String clientId = tree.getClientId(context);
        boolean dynamic = tree.isDynamic();
        String selectionMode = tree.getSelectionMode();
        boolean filter = tree.getValueExpression("filterBy") != null;
        String widget = tree.getOrientation().equals("vertical") ? "VerticalTree" : "HorizontalTree";
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.init(widget, tree.resolveWidgetVar(), clientId);
        wb.attr("dynamic", dynamic).attr("highlight", tree.isHighlight(), true).attr("animate", tree.isAnimate(), false).attr("droppable", tree.isDroppable(), false).attr("cache", tree.isCache() && dynamic).attr("dragdropScope", tree.getDragdropScope(), null).attr("disabled", tree.isDisabled(), false).callback("onNodeClick", "function(node, event)", tree.getOnNodeClick());
        if (selectionMode != null) {
            wb.attr("selectionMode", selectionMode);
            wb.attr("propagateUp", tree.isPropagateSelectionUp());
            wb.attr("propagateDown", tree.isPropagateSelectionDown());
        }
        if (tree.isDraggable()) {
            wb.attr("draggable", true).attr("dragMode", tree.getDragMode()).attr("dropRestrict", tree.getDropRestrict()).attr("multipleDrag", tree.isMultipleDrag()).attr("dropCopyNode", tree.isDropCopyNode());
        }
        if (tree.getOnDrop() != null) {
            wb.attr("controlled", true);
        }
        if (filter) {
            wb.attr("filter", true).attr("filterMode", tree.getFilterMode(), "lenient");
        }
        this.encodeIconStates(context, tree, wb);
        this.encodeClientBehaviors(context, tree);
        wb.finish();
    }

    protected void encodeMarkup(FacesContext context, Tree tree) throws IOException {
        boolean vertical = tree.getOrientation().equals("vertical");
        TreeNode root = tree.getValue();
        if (root != null && root.getRowKey() == null) {
            root.setRowKey("root");
            tree.buildRowKeys(root);
            tree.initPreselection();
        }
        if (vertical) {
            this.encodeVerticalTree(context, tree, root);
        } else {
            this.encodeHorizontalTree(context, tree, root);
        }
    }

    public void encodeVerticalTree(FacesContext context, Tree tree, TreeNode root) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = tree.getClientId(context);
        boolean dynamic = tree.isDynamic();
        String selectionMode = tree.getSelectionMode();
        boolean selectable = selectionMode != null;
        boolean multiselectable = selectable && selectionMode.equals("single");
        boolean checkbox = selectable && selectionMode.equals("checkbox");
        boolean droppable = tree.isDroppable();
        boolean filter = tree.getValueExpression("filterBy") != null;
        boolean isDisabled = tree.isDisabled();
        if (root != null && root.getRowKey() == null) {
            root.setRowKey("root");
            tree.buildRowKeys(root);
            tree.initPreselection();
        }
        if (ComponentUtils.isRTL(context, tree)) {
            tree.setRTLRendering(true);
        }
        String containerClass = tree.isRTLRendering() ? "ui-tree ui-tree-rtl ui-widget ui-widget-content ui-corner-all" : "ui-tree ui-widget ui-widget-content ui-corner-all";
        String string = containerClass = isDisabled ? containerClass + " ui-state-disabled" : containerClass;
        if (tree.getStyleClass() != null) {
            containerClass = containerClass + " " + tree.getStyleClass();
        }
        if (tree.isShowUnselectableCheckbox()) {
            containerClass = containerClass + " ui-tree-checkbox-all";
        }
        writer.startElement("div", (UIComponent)tree);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.writeAttribute("class", (Object)containerClass, null);
        writer.writeAttribute("role", (Object)"tree", null);
        if (!isDisabled) {
            writer.writeAttribute("tabindex", (Object)tree.getTabindex(), null);
        }
        writer.writeAttribute("aria-multiselectable", (Object)String.valueOf(multiselectable), null);
        if (tree.getStyle() != null) {
            writer.writeAttribute("style", (Object)tree.getStyle(), null);
        }
        if (filter) {
            this.encodeFilter(context, tree, clientId + "_filter");
        }
        writer.startElement("ul", null);
        writer.writeAttribute("class", (Object)"ui-tree-container", null);
        if (root != null) {
            this.encodeTreeNodeChildren(context, tree, root, clientId, dynamic, checkbox, droppable);
        }
        writer.endElement("ul");
        if (selectable) {
            this.encodeStateHolder(context, tree, clientId + "_selection", tree.getSelectedRowKeysAsString());
        }
        this.encodeStateHolder(context, tree, clientId + "_scrollState", tree.getScrollState());
        writer.endElement("div");
    }

    protected void encodeFilter(FacesContext context, Tree tree, String name) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"ui-tree-filter-container", null);
        writer.startElement("input", null);
        writer.writeAttribute("id", (Object)name, null);
        writer.writeAttribute("name", (Object)name, null);
        writer.writeAttribute("type", (Object)"text", null);
        writer.writeAttribute("autocomplete", (Object)"off", null);
        writer.writeAttribute("class", (Object)"ui-tree-filter ui-inputfield ui-inputtext ui-widget ui-state-default ui-corner-all", null);
        writer.endElement("input");
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)"ui-icon ui-icon-search", null);
        writer.endElement("span");
        writer.endElement("div");
    }

    protected void encodeHorizontalTree(FacesContext context, Tree tree, TreeNode root) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = tree.getClientId(context);
        boolean dynamic = tree.isDynamic();
        String selectionMode = tree.getSelectionMode();
        boolean checkbox = selectionMode != null && selectionMode.equals("checkbox");
        String containerClass = tree.getStyleClass() == null ? "ui-tree ui-tree-horizontal ui-widget ui-widget-content ui-corner-all" : "ui-tree ui-tree-horizontal ui-widget ui-widget-content ui-corner-all " + tree.getStyleClass();
        String string = containerClass = tree.isDisabled() ? containerClass + " ui-state-disabled" : containerClass;
        if (tree.isShowUnselectableCheckbox()) {
            containerClass = containerClass + " ui-tree-checkbox-all";
        }
        writer.startElement("div", (UIComponent)tree);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.writeAttribute("class", (Object)containerClass, null);
        writer.writeAttribute("role", (Object)"tree", null);
        if (root != null) {
            this.encodeHorizontalTreeNode(context, tree, root, clientId, null, NodeOrder.NONE, dynamic, checkbox);
        }
        if (selectionMode != null) {
            this.encodeStateHolder(context, tree, clientId + "_selection", tree.getSelectedRowKeysAsString());
        }
        writer.endElement("div");
    }

    protected void encodeHorizontalTreeNode(FacesContext context, Tree tree, TreeNode node, String clientId, String rowKey, NodeOrder nodeOrder, boolean dynamic, boolean checkbox) throws IOException {
        String nodeContentClass;
        String nodeClass;
        ResponseWriter writer = context.getResponseWriter();
        UITreeNode uiTreeNode = tree.getUITreeNodeByType(node.getType());
        boolean expanded = node.isExpanded();
        boolean leaf = node.isLeaf();
        boolean selectable = node.isSelectable();
        boolean partialSelected = node.isPartialSelected();
        boolean selected = node.isSelected();
        if (leaf) {
            nodeClass = "ui-treenode ui-treenode-leaf";
        } else {
            nodeClass = "ui-treenode ui-treenode-parent";
            String string = nodeClass = expanded ? nodeClass + " ui-treenode-expanded" : nodeClass + " ui-treenode-collapsed";
        }
        nodeClass = selected ? nodeClass + " ui-treenode-selected" : (partialSelected ? nodeClass + " ui-treenode-hasselected" : nodeClass + " ui-treenode-unselected");
        writer.startElement("table", (UIComponent)tree);
        writer.startElement("tbody", null);
        writer.startElement("tr", null);
        if (nodeOrder != NodeOrder.NONE) {
            this.encodeConnector(context, tree, nodeOrder);
        }
        writer.startElement("td", null);
        writer.writeAttribute("data-nodetype", (Object)uiTreeNode.getType(), null);
        if (rowKey != null) {
            tree.setRowKey(rowKey);
            writer.writeAttribute("data-rowkey", (Object)rowKey, null);
        } else {
            context.getExternalContext().getRequestMap().put(tree.getVar(), tree.getValue().getData());
            writer.writeAttribute("data-rowkey", (Object)"root", null);
        }
        nodeClass = uiTreeNode.getStyleClass() == null ? nodeClass : nodeClass + " " + uiTreeNode.getStyleClass();
        writer.writeAttribute("class", (Object)nodeClass, null);
        String string = nodeContentClass = tree.getSelectionMode() != null && node.isSelectable() ? "ui-treenode-content ui-tree-selectable ui-state-default ui-corner-all" : "ui-treenode-content ui-state-default ui-corner-all";
        if (selected) {
            nodeContentClass = nodeContentClass + " ui-state-highlight";
        }
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)nodeContentClass, null);
        if (!leaf) {
            String toggleIcon = expanded ? "ui-tree-toggler ui-icon ui-icon-minus" : "ui-tree-toggler ui-icon ui-icon-plus";
            writer.startElement("span", null);
            writer.writeAttribute("class", (Object)toggleIcon, null);
            writer.endElement("span");
        }
        if (checkbox) {
            RendererUtils.encodeCheckbox(context, selected, partialSelected, !selectable, "ui-selection");
        }
        this.encodeIcon(context, uiTreeNode, expanded);
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)"ui-treenode-label ui-corner-all", null);
        if (!tree.isDisabled()) {
            writer.writeAttribute("tabindex", (Object)"-1", null);
        }
        writer.writeAttribute("role", (Object)"treeitem", null);
        writer.writeAttribute("aria-label", (Object)uiTreeNode.getAriaLabel(), null);
        uiTreeNode.encodeAll(context);
        writer.endElement("span");
        writer.endElement("div");
        writer.endElement("td");
        if (!leaf) {
            writer.startElement("td", null);
            writer.writeAttribute("class", (Object)"ui-treenode-children-container", null);
            if (!expanded) {
                writer.writeAttribute("style", (Object)"display:none", null);
            }
            writer.startElement("div", null);
            writer.writeAttribute("class", (Object)"ui-treenode-children", null);
            if (dynamic && expanded || !dynamic) {
                this.encodeHorizontalTreeNodeChildren(context, tree, node, clientId, rowKey, dynamic, checkbox);
            }
            writer.endElement("div");
            writer.endElement("td");
        }
        writer.endElement("tr");
        writer.endElement("tbody");
        writer.endElement("table");
    }

    protected void encodeHorizontalTreeNodeChildren(FacesContext context, Tree tree, TreeNode node, String clientId, String rowKey, boolean dynamic, boolean checkbox) throws IOException {
        int childIndex = 0;
        Iterator<TreeNode> iterator = node.getChildren().iterator();
        while (iterator.hasNext()) {
            String childRowKey = rowKey == null ? String.valueOf(childIndex) : rowKey + "_" + childIndex;
            NodeOrder no = null;
            no = node.getChildCount() == 1 ? NodeOrder.NONE : (childIndex == 0 ? NodeOrder.FIRST : (childIndex == node.getChildCount() - 1 ? NodeOrder.LAST : NodeOrder.MIDDLE));
            this.encodeHorizontalTreeNode(context, tree, iterator.next(), clientId, childRowKey, no, dynamic, checkbox);
            ++childIndex;
        }
    }

    protected void encodeConnector(FacesContext context, Tree tree, NodeOrder nodeOrder) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("td", null);
        writer.writeAttribute("class", (Object)"ui-treenode-connector", null);
        writer.startElement("table", null);
        writer.writeAttribute("class", (Object)"ui-treenode-connector-table", null);
        writer.startElement("tbody", null);
        writer.startElement("tr", null);
        writer.startElement("td", null);
        if (!nodeOrder.equals((Object)NodeOrder.FIRST)) {
            writer.writeAttribute("class", (Object)"ui-treenode-connector-line", null);
        }
        writer.endElement("td");
        writer.endElement("tr");
        writer.startElement("tr", null);
        writer.startElement("td", null);
        if (!nodeOrder.equals((Object)NodeOrder.LAST)) {
            writer.writeAttribute("class", (Object)"ui-treenode-connector-line", null);
        }
        writer.endElement("td");
        writer.endElement("tr");
        writer.endElement("tbody");
        writer.endElement("table");
        writer.endElement("td");
    }

    public void encodeTreeNode(FacesContext context, Tree tree, TreeNode node, String clientId, boolean dynamic, boolean checkbox, boolean dragdrop) throws IOException {
        String contentClass;
        String containerClass;
        boolean selectable;
        String rowKey = node.getRowKey();
        boolean selected = node.isSelected();
        boolean partialSelected = node.isPartialSelected();
        boolean filter = tree.getValueExpression("filterBy") != null;
        boolean isStrictMode = tree.getFilterMode().equals("strict");
        UITreeNode uiTreeNode = tree.getUITreeNodeByType(node.getType());
        if (!uiTreeNode.isRendered()) {
            return;
        }
        List<String> filteredRowKeys = tree.getFilteredRowKeys();
        boolean match = false;
        if (filter && !filteredRowKeys.isEmpty()) {
            for (String filteredRowKey : filteredRowKeys) {
                String rowKeyExt = rowKey + "_";
                String filteredRowKeyExt = filteredRowKey + "_";
                if (!filteredRowKey.startsWith(rowKeyExt) && (isStrictMode || !rowKey.startsWith(filteredRowKeyExt)) && !filteredRowKey.equals(rowKey)) continue;
                match = true;
                if (node.isLeaf() || rowKey.startsWith(filteredRowKey)) break;
                node.setExpanded(true);
                break;
            }
            if (!match) {
                return;
            }
        }
        ResponseWriter writer = context.getResponseWriter();
        tree.setRowKey(rowKey);
        boolean isLeaf = node.isLeaf();
        boolean expanded = node.isExpanded();
        boolean bl = selectable = tree.getSelectionMode() != null && node.isSelectable();
        String toggleIcon = expanded ? "ui-tree-toggler ui-icon ui-icon-triangle-1-s" : (tree.isRTLRendering() ? "ui-tree-toggler ui-icon ui-icon-triangle-1-w" : "ui-tree-toggler ui-icon ui-icon-triangle-1-e");
        String stateIcon = isLeaf ? "ui-treenode-leaf-icon" : toggleIcon;
        Object datakey = tree.getDatakey();
        String nodeId = clientId + UINamingContainer.getSeparatorChar((FacesContext)context) + rowKey;
        String string = containerClass = isLeaf ? "ui-treenode ui-treenode-leaf" : "ui-treenode ui-treenode-parent";
        containerClass = selected ? containerClass + " ui-treenode-selected" : (partialSelected ? containerClass + " ui-treenode-hasselected" : containerClass + " ui-treenode-unselected");
        containerClass = uiTreeNode.getStyleClass() == null ? containerClass : containerClass + " " + uiTreeNode.getStyleClass();
        writer.startElement("li", null);
        writer.writeAttribute("id", (Object)nodeId, null);
        writer.writeAttribute("data-rowkey", (Object)rowKey, null);
        writer.writeAttribute("data-nodetype", (Object)uiTreeNode.getType(), null);
        writer.writeAttribute("class", (Object)containerClass, null);
        if (datakey != null) {
            writer.writeAttribute("data-datakey", datakey, null);
        }
        String string2 = contentClass = selectable ? "ui-treenode-content ui-tree-selectable" : "ui-treenode-content";
        if (dragdrop) {
            contentClass = contentClass + " ui-treenode-droppable";
        }
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)contentClass, null);
        writer.writeAttribute("role", (Object)"treeitem", null);
        writer.writeAttribute("aria-expanded", (Object)String.valueOf(expanded), null);
        writer.writeAttribute("aria-selected", (Object)String.valueOf(selected), null);
        if (checkbox) {
            writer.writeAttribute("aria-checked", (Object)String.valueOf(selected), null);
        }
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)stateIcon, null);
        writer.endElement("span");
        if (checkbox) {
            RendererUtils.encodeCheckbox(context, selected, partialSelected, !selectable, "ui-selection");
        }
        this.encodeIcon(context, uiTreeNode, expanded);
        String nodeLabelClass = selected ? "ui-treenode-label ui-corner-all ui-state-highlight" : "ui-treenode-label ui-corner-all";
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)nodeLabelClass, null);
        if (!tree.isDisabled()) {
            writer.writeAttribute("tabindex", (Object)"-1", null);
        }
        writer.writeAttribute("role", (Object)"treeitem", null);
        writer.writeAttribute("aria-label", (Object)uiTreeNode.getAriaLabel(), null);
        uiTreeNode.encodeAll(context);
        writer.endElement("span");
        writer.endElement("span");
        writer.startElement("ul", null);
        writer.writeAttribute("class", (Object)"ui-treenode-children", null);
        writer.writeAttribute("role", (Object)"group", null);
        if (!expanded) {
            writer.writeAttribute("style", (Object)"display:none", null);
        }
        if (dynamic && expanded || !dynamic) {
            this.encodeTreeNodeChildren(context, tree, node, clientId, dynamic, checkbox, dragdrop);
        }
        writer.endElement("ul");
        writer.endElement("li");
        if (dragdrop) {
            this.encodeDropTarget(context, tree);
        }
    }

    public void encodeTreeNodeChildren(FacesContext context, Tree tree, TreeNode node, String clientId, boolean dynamic, boolean checkbox, boolean droppable) throws IOException {
        int childCount = node.getChildCount();
        if (childCount > 0) {
            for (int i = 0; i < childCount; ++i) {
                if (i == 0 && droppable) {
                    this.encodeDropTarget(context, tree);
                }
                this.encodeTreeNode(context, tree, node.getChildren().get(i), clientId, dynamic, checkbox, droppable);
            }
        }
    }

    protected void encodeDropTarget(FacesContext context, Tree tree) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("li", null);
        writer.writeAttribute("class", (Object)"ui-tree-droppoint", null);
        writer.endElement("li");
    }

    protected void encodeIconStates(FacesContext context, Tree tree, WidgetBuilder wb) throws IOException {
        Map<String, UITreeNode> nodes = tree.getTreeNodes();
        wb.append(",iconStates:{");
        boolean firstWritten = false;
        for (String type : nodes.keySet()) {
            UITreeNode node = nodes.get(type);
            String expandedIcon = node.getExpandedIcon();
            String collapsedIcon = node.getCollapsedIcon();
            if (expandedIcon == null || collapsedIcon == null) continue;
            if (firstWritten) {
                wb.append(",");
            }
            wb.append("'" + node.getType() + "' : {");
            wb.append("expandedIcon:'" + expandedIcon + "'");
            wb.append(",collapsedIcon:'" + collapsedIcon + "'");
            wb.append("}");
            firstWritten = true;
        }
        wb.append("}");
    }

    protected void encodeIcon(FacesContext context, UITreeNode uiTreeNode, boolean expanded) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("span", null);
        String icon = uiTreeNode.getIconToRender(expanded);
        if (icon != null) {
            writer.writeAttribute("class", (Object)("ui-treenode-icon ui-icon " + icon), null);
        }
        writer.endElement("span");
    }

    protected void encodeStateHolder(FacesContext context, Tree tree, String id, String value) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("input", null);
        writer.writeAttribute("type", (Object)"hidden", null);
        writer.writeAttribute("id", (Object)id, null);
        writer.writeAttribute("name", (Object)id, null);
        writer.writeAttribute("autocomplete", (Object)"off", null);
        writer.writeAttribute("value", (Object)value, null);
        writer.endElement("input");
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }

    public FilterConstraint getFilterConstraint(Tree tree) {
        String filterMatchMode = tree.getFilterMatchMode();
        FilterConstraint filterConstraint = Tree.FILTER_CONSTRAINTS.get(filterMatchMode);
        if (filterConstraint == null) {
            throw new FacesException("Illegal filter match mode:" + filterMatchMode);
        }
        return filterConstraint;
    }

    protected static enum NodeOrder {
        FIRST,
        MIDDLE,
        LAST,
        NONE;

    }
}

